/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils;

import java.util.HashMap;
import java.util.Map;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Attributes;
import org.opcfoundation.ua.core.NodeClass;

public class AttributesUtil {
    static final Map<UnsignedInteger, String> attributeNames = new HashMap<UnsignedInteger, String>();

    public static boolean isValid(UnsignedInteger unsignedInteger) {
        return unsignedInteger.compareTo(Attributes.NodeId) >= 0 && unsignedInteger.compareTo(Attributes.UserExecutable) <= 0;
    }

    public static boolean isValid(NodeClass nodeClass, UnsignedInteger unsignedInteger) {
        int n = nodeClass.ordinal();
        if (unsignedInteger.equals(Attributes.NodeId) || unsignedInteger.equals(Attributes.NodeClass) || unsignedInteger.equals(Attributes.BrowseName) || unsignedInteger.equals(Attributes.DisplayName) || unsignedInteger.equals(Attributes.Description) || unsignedInteger.equals(Attributes.WriteMask) || unsignedInteger.equals(Attributes.UserWriteMask)) {
            return true;
        }
        if (unsignedInteger.equals(Attributes.Value) || unsignedInteger.equals(Attributes.DataType) || unsignedInteger.equals(Attributes.ValueRank)) {
            return (n & (NodeClass.VariableType.ordinal() | NodeClass.Variable.ordinal())) != 0;
        }
        if (unsignedInteger.equals(Attributes.IsAbstract)) {
            return (n & (NodeClass.VariableType.ordinal() | NodeClass.ObjectType.ordinal() | NodeClass.DataType.ordinal() | NodeClass.ReferenceType.ordinal())) != 0;
        }
        if (unsignedInteger.equals(Attributes.Symmetric) || unsignedInteger.equals(Attributes.InverseName)) {
            return (n & NodeClass.ReferenceType.ordinal()) != 0;
        }
        if (unsignedInteger.equals(Attributes.ContainsNoLoops)) {
            return (n & NodeClass.View.ordinal()) != 0;
        }
        if (unsignedInteger.equals(Attributes.EventNotifier)) {
            return (n & (NodeClass.Object.ordinal() | NodeClass.View.ordinal())) != 0;
        }
        if (unsignedInteger.equals(Attributes.AccessLevel) || unsignedInteger.equals(Attributes.UserAccessLevel) || unsignedInteger.equals(Attributes.MinimumSamplingInterval) || unsignedInteger.equals(Attributes.Historizing)) {
            return (n & NodeClass.Variable.ordinal()) != 0;
        }
        if (unsignedInteger.equals(Attributes.ArrayDimensions)) {
            return (n & (NodeClass.Variable.ordinal() | NodeClass.VariableType.ordinal())) != 0;
        }
        if (unsignedInteger.equals(Attributes.Executable) || unsignedInteger.equals(Attributes.UserExecutable)) {
            return (n & NodeClass.Method.ordinal()) != 0;
        }
        return false;
    }

    public static String toString(UnsignedInteger unsignedInteger) {
        try {
            return attributeNames.get(unsignedInteger);
        }
        catch (NullPointerException nullPointerException) {
            return "<InvalidAttributeValue " + unsignedInteger + ">";
        }
    }

    static {
        attributeNames.put(Attributes.NodeId, "NodeId");
        attributeNames.put(Attributes.NodeClass, "NodeClass");
        attributeNames.put(Attributes.BrowseName, "BrowseName");
        attributeNames.put(Attributes.DisplayName, "DisplayName");
        attributeNames.put(Attributes.Description, "Description");
        attributeNames.put(Attributes.WriteMask, "WriteMask");
        attributeNames.put(Attributes.UserWriteMask, "UserWriteMask");
        attributeNames.put(Attributes.IsAbstract, "IsAbstract");
        attributeNames.put(Attributes.Symmetric, "Symmetric");
        attributeNames.put(Attributes.InverseName, "InverseName");
        attributeNames.put(Attributes.ContainsNoLoops, "ContainsNoLoops");
        attributeNames.put(Attributes.EventNotifier, "EventNotifier");
        attributeNames.put(Attributes.Value, "Value");
        attributeNames.put(Attributes.DataType, "DataType");
        attributeNames.put(Attributes.ValueRank, "ValueRank");
        attributeNames.put(Attributes.ArrayDimensions, "ArrayDimensions");
        attributeNames.put(Attributes.AccessLevel, "AccessLevel");
        attributeNames.put(Attributes.UserAccessLevel, "UserAccessLevel");
        attributeNames.put(Attributes.MinimumSamplingInterval, "MinimumSamplingInterval");
        attributeNames.put(Attributes.Historizing, "Historizing");
        attributeNames.put(Attributes.Executable, "Executable");
        attributeNames.put(Attributes.UserExecutable, "UserExecutable");
    }
}

