/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.tcp.nio;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.opcfoundation.ua.application.Server;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.ChannelSecurityToken;
import org.opcfoundation.ua.core.CloseSecureChannelRequest;
import org.opcfoundation.ua.core.CloseSecureChannelResponse;
import org.opcfoundation.ua.core.MessageSecurityMode;
import org.opcfoundation.ua.core.OpenSecureChannelRequest;
import org.opcfoundation.ua.core.OpenSecureChannelResponse;
import org.opcfoundation.ua.core.ResponseHeader;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.encoding.IEncodeable;
import org.opcfoundation.ua.transport.AsyncWrite;
import org.opcfoundation.ua.transport.CloseableObjectState;
import org.opcfoundation.ua.transport.Endpoint;
import org.opcfoundation.ua.transport.ServerConnection;
import org.opcfoundation.ua.transport.endpoint.AbstractServerSecureChannel;
import org.opcfoundation.ua.transport.endpoint.EndpointServiceRequest;
import org.opcfoundation.ua.transport.security.Cert;
import org.opcfoundation.ua.transport.security.KeyPair;
import org.opcfoundation.ua.transport.security.SecurityAlgorithm;
import org.opcfoundation.ua.transport.security.SecurityConfiguration;
import org.opcfoundation.ua.transport.security.SecurityMode;
import org.opcfoundation.ua.transport.security.SecurityPolicy;
import org.opcfoundation.ua.transport.tcp.impl.SecurityToken;
import org.opcfoundation.ua.transport.tcp.nio.InputMessage;
import org.opcfoundation.ua.transport.tcp.nio.OpcTcpServerConnection;
import org.opcfoundation.ua.transport.tcp.nio.PendingRequest;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.opcfoundation.ua.utils.EndpointUtil;
import org.opcfoundation.ua.utils.StackUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcTcpServerSecureChannel
extends AbstractServerSecureChannel {
    static Logger logger = LoggerFactory.getLogger(OpcTcpServerSecureChannel.class);
    public SecurityConfiguration securityConfiguration;
    AtomicInteger tokenIdCounter = new AtomicInteger();
    OpcTcpServerConnection connection;
    public final AtomicInteger sendSequenceNumber = new AtomicInteger(new Random().nextInt(1024));
    public final AtomicInteger recvSequenceNumber = new AtomicInteger();

    @Override
    public KeyPair getLocalCertificate() {
        return this.securityConfiguration.getLocalCertificate2();
    }

    @Override
    public Cert getRemoteCertificate() {
        return this.securityConfiguration.getRemoteCertificate2();
    }

    public OpcTcpServerSecureChannel(OpcTcpServerConnection opcTcpServerConnection, int n) {
        super(n);
        this.connection = opcTcpServerConnection;
    }

    @Override
    public String getConnectURL() {
        return this.connection.ctx.endpointUrl;
    }

    @Override
    public ServerConnection getConnection() {
        return this.connection;
    }

    @Override
    public Endpoint getEndpoint() {
        return this.connection.binding.endpointAddress;
    }

    @Override
    public Server getServer() {
        return this.connection.binding.serviceServer;
    }

    @Override
    public void getPendingServiceRequests(Collection<EndpointServiceRequest<?, ?>> collection) {
        collection.addAll(this.connection.pendingRequests.values());
    }

    protected void handleSecureMessage(InputMessage inputMessage, IEncodeable iEncodeable) throws ServiceResultException {
        logger.debug("onSecureMessage: server={}", (Object)this.getServer());
        logger.debug("onSecureMessage: endpoint={}", (Object)this.getEndpoint());
        int n = inputMessage.getRequestId();
        PendingRequest pendingRequest = new PendingRequest(this, this.getEndpoint(), this.getServer(), inputMessage.getRequestId(), (ServiceRequest)iEncodeable);
        this.connection.pendingRequests.put(n, pendingRequest);
        this.getServer().getServiceHandlerComposition().serve(pendingRequest);
    }

    private SecurityToken createToken(OpenSecureChannelRequest openSecureChannelRequest, InputMessage inputMessage) throws ServiceResultException {
        byte[] byArray = openSecureChannelRequest.getClientNonce();
        int n = this.tokenIdCounter.incrementAndGet();
        SecurityAlgorithm securityAlgorithm = this.securityConfiguration.getSecurityPolicy().getSymmetricEncryptionAlgorithm();
        byte[] byArray2 = CryptoUtil.createNonce(securityAlgorithm);
        UnsignedInteger unsignedInteger = openSecureChannelRequest.getRequestedLifetime() != null && openSecureChannelRequest.getRequestedLifetime().intValue() > 0 ? openSecureChannelRequest.getRequestedLifetime() : StackUtils.SERVER_GIVEN_TOKEN_LIFETIME;
        logger.debug("tokenLifetime: {}", (Object)unsignedInteger);
        SecurityToken securityToken = new SecurityToken(this.securityConfiguration, this.getSecureChannelId(), n, System.currentTimeMillis(), unsignedInteger.longValue(), byArray2, byArray);
        this.tokens.put(n, securityToken);
        return securityToken;
    }

    private void sendOpenChannelResponse(InputMessage inputMessage, SecurityToken securityToken, SecurityConfiguration securityConfiguration) throws ServiceResultException {
        boolean bl;
        ChannelSecurityToken channelSecurityToken = new ChannelSecurityToken();
        channelSecurityToken.setChannelId(UnsignedInteger.valueOf(this.getSecureChannelId()));
        channelSecurityToken.setCreatedAt(new DateTime());
        channelSecurityToken.setRevisedLifetime(UnsignedInteger.valueOf(securityToken.getLifeTime()));
        channelSecurityToken.setTokenId(UnsignedInteger.valueOf(securityToken.getTokenId()));
        this.setState(CloseableObjectState.Open);
        this.connection.secureChannels.put(this.getSecureChannelId(), this);
        OpenSecureChannelRequest openSecureChannelRequest = (OpenSecureChannelRequest)inputMessage.getMessage();
        OpenSecureChannelResponse openSecureChannelResponse = new OpenSecureChannelResponse();
        openSecureChannelResponse.setSecurityToken(channelSecurityToken);
        openSecureChannelResponse.setServerNonce(securityToken.getLocalNonce());
        openSecureChannelResponse.setServerProtocolVersion(UnsignedInteger.valueOf(this.connection.agreedProtocolVersion));
        UnsignedInteger unsignedInteger = openSecureChannelRequest.getRequestHeader() == null ? null : openSecureChannelRequest.getRequestHeader().getRequestHandle();
        ResponseHeader responseHeader = new ResponseHeader();
        openSecureChannelResponse.setResponseHeader(responseHeader);
        responseHeader.setRequestHandle(unsignedInteger);
        AsyncWrite asyncWrite = new AsyncWrite(openSecureChannelResponse);
        boolean bl2 = bl = inputMessage.getMessageType() == 5132367 || inputMessage.getMessageType() == 5196867;
        if (bl) {
            this.connection.sendAsymmSecureMessage(asyncWrite, securityConfiguration, securityToken.getSecureChannelId(), inputMessage.getRequestId(), this.sendSequenceNumber);
        } else {
            this.connection.sendSecureMessage(asyncWrite, this.activeToken, inputMessage.getRequestId(), 4674381, this.sendSequenceNumber);
        }
    }

    protected void handleOpenChannel(InputMessage inputMessage, OpenSecureChannelRequest openSecureChannelRequest) throws ServiceResultException {
        SecurityConfiguration securityConfiguration = (SecurityConfiguration)inputMessage.getToken();
        SecurityPolicy securityPolicy = securityConfiguration.getSecurityPolicy();
        MessageSecurityMode messageSecurityMode = openSecureChannelRequest.getSecurityMode();
        SecurityMode securityMode = new SecurityMode(securityPolicy, messageSecurityMode);
        KeyPair keyPair = null;
        Cert cert = securityConfiguration.getRemoteCertificate2();
        if (messageSecurityMode.hasSigning() || EndpointUtil.containsSecureUserTokenPolicy(this.getServer().getUserTokenPolicies())) {
            keyPair = securityConfiguration.getLocalCertificate2();
        } else if (cert != null) {
            logger.debug("Client defines a certificate although SecurityPolicy.NONE is defined");
        }
        this.securityConfiguration = new SecurityConfiguration(securityMode, keyPair, cert);
        SecurityToken securityToken = this.createToken(openSecureChannelRequest, inputMessage);
        this.recvSequenceNumber.set(inputMessage.getSequenceNumbers().get(inputMessage.getSequenceNumbers().size() - 1) + 1);
        this.setState(CloseableObjectState.Opening);
        this.setActiveSecurityToken(securityToken);
        this.sendOpenChannelResponse(inputMessage, securityToken, this.securityConfiguration);
        logger.info("SecureChannel opened; {}", (Object)this.getActiveSecurityToken());
    }

    protected void handleRenewSecureChannelRequest(InputMessage inputMessage, OpenSecureChannelRequest openSecureChannelRequest) throws ServiceResultException {
        SecurityToken securityToken = this.createToken(openSecureChannelRequest, inputMessage);
        this.sendOpenChannelResponse(inputMessage, securityToken, (SecurityConfiguration)inputMessage.getToken());
        logger.info("SecureChannel renewed; {}", (Object)securityToken);
    }

    protected void handleCloseSecureChannelRequest(InputMessage inputMessage, CloseSecureChannelRequest closeSecureChannelRequest) {
        this.close();
        CloseSecureChannelResponse closeSecureChannelResponse = new CloseSecureChannelResponse();
        UnsignedInteger unsignedInteger = closeSecureChannelRequest.getRequestHeader() == null ? null : closeSecureChannelRequest.getRequestHeader().getRequestHandle();
        ResponseHeader responseHeader = new ResponseHeader();
        closeSecureChannelResponse.setResponseHeader(responseHeader);
        responseHeader.setRequestHandle(unsignedInteger);
        AsyncWrite asyncWrite = new AsyncWrite(closeSecureChannelResponse);
        this.connection.sendSecureMessage(asyncWrite, this.getActiveSecurityToken(), inputMessage.getRequestId(), 5196867, this.sendSequenceNumber);
    }

    @Override
    protected synchronized void onStateTransition(CloseableObjectState closeableObjectState, CloseableObjectState closeableObjectState2) {
        super.onStateTransition(closeableObjectState, closeableObjectState2);
        if (closeableObjectState2 == CloseableObjectState.Closed) {
            logger.info("Secure Channel closed, token={}", (Object)this.activeToken);
            this.connection.secureChannels.remove(this.getSecureChannelId());
            this.connection.fireSecureChannelDetached(this);
            ServiceResultException serviceResultException = new ServiceResultException(StatusCodes.Bad_SecureChannelClosed);
            for (PendingRequest pendingRequest : this.getPendingRequests2()) {
                AsyncWrite asyncWrite = pendingRequest.write;
                if (asyncWrite == null) continue;
                asyncWrite.attemptSetError(serviceResultException);
            }
        }
    }

    protected Collection<PendingRequest> getPendingRequests2() {
        ArrayList<PendingRequest> arrayList = new ArrayList<PendingRequest>();
        for (PendingRequest pendingRequest : this.connection.pendingRequests.values()) {
            if (pendingRequest.channel != this) continue;
            arrayList.add(pendingRequest);
        }
        return arrayList;
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean needsCertificate() {
        return this.getMessageSecurityMode().hasSigning() || EndpointUtil.containsSecureUserTokenPolicy(this.getServer().getUserTokenPolicies());
    }
}

