/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.tcp.nio;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.CloseSecureChannelRequest;
import org.opcfoundation.ua.core.EndpointConfiguration;
import org.opcfoundation.ua.core.MessageSecurityMode;
import org.opcfoundation.ua.core.OpenSecureChannelRequest;
import org.opcfoundation.ua.core.SecurityTokenRequestType;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.encoding.EncoderMode;
import org.opcfoundation.ua.encoding.IEncodeable;
import org.opcfoundation.ua.encoding.binary.BinaryEncoder;
import org.opcfoundation.ua.encoding.binary.EncoderCalc;
import org.opcfoundation.ua.transport.AsyncWrite;
import org.opcfoundation.ua.transport.CloseableObject;
import org.opcfoundation.ua.transport.CloseableObjectState;
import org.opcfoundation.ua.transport.Endpoint;
import org.opcfoundation.ua.transport.EndpointBinding;
import org.opcfoundation.ua.transport.IConnectionListener;
import org.opcfoundation.ua.transport.ServerSecureChannel;
import org.opcfoundation.ua.transport.endpoint.AbstractServerSecureChannel;
import org.opcfoundation.ua.transport.endpoint.EndpointBindingCollection;
import org.opcfoundation.ua.transport.security.Cert;
import org.opcfoundation.ua.transport.security.CertificateValidator;
import org.opcfoundation.ua.transport.security.KeyPair;
import org.opcfoundation.ua.transport.security.SecurityAlgorithm;
import org.opcfoundation.ua.transport.security.SecurityConfiguration;
import org.opcfoundation.ua.transport.security.SecurityMode;
import org.opcfoundation.ua.transport.security.SecurityPolicy;
import org.opcfoundation.ua.transport.tcp.impl.Acknowledge;
import org.opcfoundation.ua.transport.tcp.impl.ChunkAsymmEncryptSigner;
import org.opcfoundation.ua.transport.tcp.impl.ChunkFactory;
import org.opcfoundation.ua.transport.tcp.impl.ChunkSymmEncryptSigner;
import org.opcfoundation.ua.transport.tcp.impl.ChunkUtils;
import org.opcfoundation.ua.transport.tcp.impl.ErrorMessage;
import org.opcfoundation.ua.transport.tcp.impl.Hello;
import org.opcfoundation.ua.transport.tcp.impl.SecurityToken;
import org.opcfoundation.ua.transport.tcp.nio.AbstractServerConnection;
import org.opcfoundation.ua.transport.tcp.nio.ChunksToMessage;
import org.opcfoundation.ua.transport.tcp.nio.InputMessage;
import org.opcfoundation.ua.transport.tcp.nio.MessageToChunks;
import org.opcfoundation.ua.transport.tcp.nio.MessageType;
import org.opcfoundation.ua.transport.tcp.nio.OpcTcpServer;
import org.opcfoundation.ua.transport.tcp.nio.OpcTcpServerSecureChannel;
import org.opcfoundation.ua.transport.tcp.nio.PendingRequest;
import org.opcfoundation.ua.transport.tcp.nio.SecureInputMessageBuilder;
import org.opcfoundation.ua.utils.CertificateUtils;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.opcfoundation.ua.utils.IStatefulObject;
import org.opcfoundation.ua.utils.IncubationQueue;
import org.opcfoundation.ua.utils.ObjectUtils;
import org.opcfoundation.ua.utils.StackUtils;
import org.opcfoundation.ua.utils.StateListener;
import org.opcfoundation.ua.utils.TimerUtil;
import org.opcfoundation.ua.utils.asyncsocket.AsyncInputStream;
import org.opcfoundation.ua.utils.asyncsocket.AsyncSocket;
import org.opcfoundation.ua.utils.asyncsocket.AsyncSocketImpl;
import org.opcfoundation.ua.utils.asyncsocket.BufferMonitorState;
import org.opcfoundation.ua.utils.asyncsocket.MonitorListener;
import org.opcfoundation.ua.utils.asyncsocket.SocketState;
import org.opcfoundation.ua.utils.bytebuffer.ByteBufferArrayWriteable2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcTcpServerConnection
extends AbstractServerConnection {
    private static final Logger logger = LoggerFactory.getLogger(OpcTcpServerConnection.class);
    int agreedProtocolVersion;
    Map<Integer, PendingRequest> pendingRequests = new ConcurrentHashMap<Integer, PendingRequest>();
    EndpointBinding binding;
    OpcTcpServer endpointServer;
    AsyncSocket s;
    private static long handshakeTimeout = 600000L;
    Timer timer = TimerUtil.getTimer();
    TimerTask timeoutTimer;
    Runnable timeout = new Runnable(){

        @Override
        public void run() {
            OpcTcpServerConnection.this.setError(StatusCodes.Bad_Timeout);
        }
    };
    EncoderContext encoderCtx;
    EndpointConfiguration endpointConfiguration;
    MonitorListener inputListener = new MonitorListener(){

        @Override
        public void onStateTransition(IStatefulObject<BufferMonitorState, ?> iStatefulObject, BufferMonitorState bufferMonitorState, BufferMonitorState bufferMonitorState2) {
            if (bufferMonitorState2.isUnreachable()) {
                if (OpcTcpServerConnection.this.secureMessageBuilder != null) {
                    OpcTcpServerConnection.this.secureMessageBuilder.close();
                    OpcTcpServerConnection.this.secureMessageBuilder = null;
                }
                return;
            }
            if (bufferMonitorState2 != BufferMonitorState.Triggered) {
                logger.error("Unexpected trigger state {}", (Object)bufferMonitorState2);
                return;
            }
            AsyncInputStream asyncInputStream = OpcTcpServerConnection.this.s.getInputStream();
            ByteBuffer byteBuffer = asyncInputStream.peek(8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.getInt();
            int n = byteBuffer.getInt();
            if (n < 12) {
                OpcTcpServerConnection.this.setError(StatusCodes.Bad_TcpInternalError);
                if (OpcTcpServerConnection.this.secureMessageBuilder != null) {
                    OpcTcpServerConnection.this.secureMessageBuilder.close();
                }
                return;
            }
            if (n > OpcTcpServerConnection.this.ctx.maxRecvChunkSize) {
                if (!OpcTcpServerConnection.this.hasError()) {
                    try {
                        OpcTcpServerConnection.this.sendError(new ErrorMessage(StatusCodes.Bad_CommunicationError, "Chunk size (" + n + ") exceeded maximum (" + OpcTcpServerConnection.this.ctx.maxRecvChunkSize + ")"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                OpcTcpServerConnection.this.setError(StatusCodes.Bad_TcpMessageTooLarge);
                if (OpcTcpServerConnection.this.secureMessageBuilder != null) {
                    OpcTcpServerConnection.this.secureMessageBuilder.close();
                }
                return;
            }
            if (asyncInputStream.available() >= n) {
                ByteBuffer byteBuffer2 = asyncInputStream.read(n);
                byteBuffer2.rewind();
                try {
                    try {
                        OpcTcpServerConnection.this.handleChunk(byteBuffer2);
                    }
                    catch (RuntimeException runtimeException) {
                        logger.warn("Error in handleChunk", (Throwable)runtimeException);
                        throw StackUtils.toServiceResultException(runtimeException);
                    }
                }
                catch (ServiceResultException serviceResultException) {
                    logger.info("Error in handleChunk", (Throwable)serviceResultException);
                    try {
                        OpcTcpServerConnection.this.sendError(new ErrorMessage(serviceResultException.getStatusCode(), serviceResultException.getMessage()));
                    }
                    catch (ServiceResultException serviceResultException2) {
                        logger.warn("Could not send ErrorMessage:", (Throwable)serviceResultException2);
                    }
                    OpcTcpServerConnection.this.setError(serviceResultException);
                }
                asyncInputStream.createMonitor(asyncInputStream.getPosition() + 8L, this);
            } else {
                asyncInputStream.createMonitor(asyncInputStream.getPosition() + (long)n, this);
            }
        }
    };
    SecureInputMessageBuilder.MessageListener messageListener = new SecureInputMessageBuilder.MessageListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessageComplete(InputMessage inputMessage) {
            IEncodeable iEncodeable = inputMessage.getMessage();
            for (Object object : OpcTcpServerConnection.this.channelListeners) {
                if (!object.handleMessage(inputMessage)) continue;
                return;
            }
            if (iEncodeable == null) {
                4 var3_3 = this;
                synchronized (var3_3) {
                    Object object;
                    object = inputMessage.getError();
                    if (object == null) {
                        return;
                    }
                    OpcTcpServerConnection.this.setError(StackUtils.toServiceResultException((Exception)object));
                    return;
                }
            }
            try {
                if (inputMessage.getMessageType() == 4674381) {
                    OpcTcpServerConnection.this.handleSecureMessage(inputMessage);
                } else if (inputMessage.getMessageType() == 5196867) {
                    OpcTcpServerConnection.this.handleCloseSecureChannelRequest(inputMessage);
                } else if (inputMessage.getMessageType() == 5132367) {
                    OpcTcpServerConnection.this.handleOpenSecureChannelRequest(inputMessage);
                }
            }
            catch (ServiceResultException serviceResultException) {
                try {
                    OpcTcpServerConnection.this.sendError(new ErrorMessage(serviceResultException.getStatusCode(), serviceResultException.getMessage()));
                }
                catch (ServiceResultException serviceResultException2) {
                    // empty catch block
                }
                OpcTcpServerConnection.this.setError(serviceResultException);
            }
        }
    };

    public static long getHandshakeTimeout() {
        return handshakeTimeout;
    }

    public static void setHandshakeTimeout(long l) {
        handshakeTimeout = l;
    }

    OpcTcpServerConnection(OpcTcpServer opcTcpServer, AsyncSocketImpl asyncSocketImpl) {
        this.endpointServer = opcTcpServer;
        this.s = asyncSocketImpl;
        this.encoderCtx = opcTcpServer.getEncoderContext();
        this.socketListener = new StateListener<SocketState>(){

            @Override
            public void onStateTransition(IStatefulObject<SocketState, ?> iStatefulObject, SocketState socketState, SocketState socketState2) {
                if (socketState2 == SocketState.Error) {
                    OpcTcpServerConnection.this.setError(StackUtils.toServiceResultException(OpcTcpServerConnection.this.s.getStateMonitor().getError()));
                }
                if (socketState2 == SocketState.Closed) {
                    OpcTcpServerConnection.this.close();
                }
            }
        };
        asyncSocketImpl.getStateMonitor().addStateListener(this.socketListener);
        asyncSocketImpl.getInputStream().createMonitor(8L, this.inputListener);
        this.setState(CloseableObjectState.Opening);
        this.timeoutTimer = TimerUtil.schedule(this.timer, this.timeout, StackUtils.getBlockingWorkExecutor(), System.currentTimeMillis() + handshakeTimeout);
    }

    protected synchronized void sendChunks(ByteBuffer ... byteBufferArray) {
        this.startChunkSend(byteBufferArray);
        for (ByteBuffer byteBuffer : byteBufferArray) {
            this.endChunkSend(byteBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startChunkSend(ByteBuffer ... byteBufferArray) {
        IncubationQueue incubationQueue = this.chunkIncubator;
        synchronized (incubationQueue) {
            for (ByteBuffer byteBuffer : byteBufferArray) {
                this.chunkIncubator.incubate(byteBuffer);
            }
        }
    }

    protected void sendHello(Hello hello) {
        this.ctx.endpointUrl = hello.getEndpointUrl();
        ChunkFactory chunkFactory = new ChunkFactory(this.ctx.maxSendChunkSize, 8, 0, 0, 0, 1, MessageSecurityMode.None, 0);
        MessageToChunks messageToChunks = new MessageToChunks(hello, this.ctx, this.encoderCtx, chunkFactory, MessageType.Encodeable);
        ByteBuffer[] byteBufferArray = messageToChunks.call();
        ByteBuffer[] byteBufferArray2 = chunkFactory.expandToCompleteChunk(byteBufferArray);
        assert (byteBufferArray2.length == 1);
        byteBufferArray2[0].putInt(1179403592);
        byteBufferArray2[0].rewind();
        this.sendChunks(byteBufferArray2);
    }

    protected void sendAcknowledge(Acknowledge acknowledge) throws ServiceResultException {
        ChunkFactory.AcknowledgeChunkFactory acknowledgeChunkFactory = new ChunkFactory.AcknowledgeChunkFactory();
        MessageToChunks messageToChunks = new MessageToChunks(acknowledge, this.ctx, this.encoderCtx, acknowledgeChunkFactory, MessageType.Encodeable);
        ByteBuffer[] byteBufferArray = messageToChunks.call();
        ByteBuffer[] byteBufferArray2 = acknowledgeChunkFactory.expandToCompleteChunk(byteBufferArray);
        assert (byteBufferArray2.length == 1);
        byteBufferArray2[0].putInt(1179337537);
        byteBufferArray2[0].rewind();
        this.sendChunks(byteBufferArray2);
    }

    protected void sendError(ErrorMessage errorMessage) throws ServiceResultException {
        ChunkFactory.ErrorMessageChunkFactory errorMessageChunkFactory = new ChunkFactory.ErrorMessageChunkFactory();
        MessageToChunks messageToChunks = new MessageToChunks(errorMessage, this.ctx, this.encoderCtx, errorMessageChunkFactory, MessageType.Encodeable);
        ByteBuffer[] byteBufferArray = messageToChunks.call();
        ByteBuffer[] byteBufferArray2 = errorMessageChunkFactory.expandToCompleteChunk(byteBufferArray);
        assert (byteBufferArray2.length == 1);
        byteBufferArray2[0].putInt(1179800133);
        byteBufferArray2[0].rewind();
        this.sendChunks(byteBufferArray2);
    }

    protected void handleHelloMessage(Hello hello) throws ServiceResultException {
        List<EndpointBinding> list;
        this.cancelTimeoutTimer();
        EndpointBindingCollection endpointBindingCollection = this.endpointServer.getEndpointBindings();
        if (endpointBindingCollection == null) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
        }
        String string = this.trimUrl(hello.getEndpointUrl());
        logger.debug("onHello: url={}", (Object)string);
        if (string == null || string.equals("")) {
            this.binding = this.endpointServer.discoveryEndpointBinding;
        } else {
            list = endpointBindingCollection.get(string);
            if (list.isEmpty()) {
                this.binding = endpointBindingCollection.getDefault(string);
                if (this.binding == null) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpEndpointUrlInvalid);
                }
            } else {
                this.binding = list.get(0);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" endpoints={}", (Object)Arrays.toString(endpointBindingCollection.getEndpointAddresses().toArray(new Endpoint[0])));
            logger.debug(" endpoint=" + (this.binding == null ? "binding is null" : this.binding.endpointAddress));
        }
        if (this.getState() != CloseableObjectState.Opening) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
        }
        list = new Acknowledge();
        if (hello.getSendBufferSize().longValue() < 8192L) {
            this.setError(new ServiceResultException(StatusCodes.Bad_TcpInternalError, "Peer send buffer size <  8192"));
        }
        if (hello.getReceiveBufferSize().longValue() < 8192L) {
            this.setError(new ServiceResultException(StatusCodes.Bad_TcpInternalError, "Peer recv buffer size <  8192"));
        }
        if (this.getError() != null) {
            logger.warn("onHello: " + this.getError());
        }
        this.agreedProtocolVersion = Math.min(0, hello.getProtocolVersion().intValue());
        ((Acknowledge)((Object)list)).setProtocolVersion(UnsignedInteger.getFromBits(this.agreedProtocolVersion));
        if (hello.getMaxMessageSize() != null && hello.getMaxMessageSize().intValue() != 0) {
            this.ctx.maxSendMessageSize = this.ctx.maxSendMessageSize == 0 ? hello.getMaxMessageSize().intValue() : Math.min(this.ctx.maxSendMessageSize, hello.getMaxMessageSize().intValue());
        }
        if (this.binding != null) {
            int n = this.binding.endpointAddress.getEndpointConfiguration().getMaxMessageSize();
            this.ctx.maxSendMessageSize = this.ctx.maxSendMessageSize == 0 ? n : Math.min(this.ctx.maxSendMessageSize, n);
            this.ctx.maxRecvMessageSize = this.ctx.maxRecvMessageSize == 0 ? n : Math.min(this.ctx.maxRecvMessageSize, n);
            this.encoderCtx.maxMessageSize = n;
        } else {
            this.encoderCtx.maxMessageSize = this.ctx.maxSendMessageSize;
        }
        if (hello.getMaxChunkCount().intValue() != 0) {
            this.ctx.maxSendChunkCount = Math.min(this.ctx.maxSendChunkCount, hello.getMaxChunkCount().intValue());
        }
        ((Acknowledge)((Object)list)).setMaxChunkCount(UnsignedInteger.getFromBits(this.ctx.maxRecvChunkCount));
        this.ctx.maxSendChunkSize = Math.min(hello.getReceiveBufferSize().intValue(), this.ctx.maxSendChunkSize);
        this.ctx.maxRecvChunkSize = Math.min(hello.getSendBufferSize().intValue(), this.ctx.maxRecvChunkSize);
        ((Acknowledge)((Object)list)).setSendBufferSize(UnsignedInteger.getFromBits(this.ctx.maxSendChunkSize));
        ((Acknowledge)((Object)list)).setReceiveBufferSize(UnsignedInteger.getFromBits(this.ctx.maxRecvChunkSize));
        this.ctx.maxRecvChunkSize = Math.min(this.ctx.maxRecvChunkSize, hello.getReceiveBufferSize().intValue());
        this.ctx.maxSendChunkSize = Math.min(this.ctx.maxSendChunkSize, hello.getSendBufferSize().intValue());
        this.setState(CloseableObjectState.Opening);
        this.ctx.endpointUrl = hello.getEndpointUrl();
        this.sendAcknowledge((Acknowledge)((Object)list));
        this.setState(CloseableObjectState.Open);
    }

    protected void cancelTimeoutTimer() {
        if (this.timeoutTimer != null) {
            this.timeoutTimer.cancel();
            this.timeoutTimer = null;
            this.timeout = null;
        }
    }

    protected void handleAcknowledgeMessage(Acknowledge acknowledge) throws ServiceResultException {
        throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
    }

    protected void handleErrorMessage(ErrorMessage errorMessage) {
        logger.debug("onError: {}", (Object)errorMessage);
        this.setError(errorMessage.getError());
    }

    protected void handleAsymmChunk(ByteBuffer byteBuffer) throws ServiceResultException {
        byteBuffer.rewind();
        if (this.secureMessageBuilder != null && !this.secureMessageBuilder.moreChunksRequired()) {
            this.secureMessageBuilder = null;
        }
        if (this.secureMessageBuilder == null) {
            Object object;
            Cert cert;
            int n = ChunkUtils.getSecureChannelId(byteBuffer);
            OpcTcpServerSecureChannel opcTcpServerSecureChannel = (OpcTcpServerSecureChannel)this.secureChannels.get(n);
            String string = ChunkUtils.getString(byteBuffer);
            SecurityPolicy securityPolicy = SecurityPolicy.getSecurityPolicy(string);
            if (securityPolicy == null) {
                logger.warn("Security policy \"{}\" is not supported by the stack", (Object)string);
                throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, "Security policy \"" + string + "\" is not supported by the stack");
            }
            byte[] byArray = ChunkUtils.getByteString(byteBuffer);
            byte[] byArray2 = ChunkUtils.getByteString(byteBuffer);
            logger.debug("secureChannelId={}", (Object)n);
            logger.debug("secureChannel={}", (Object)opcTcpServerSecureChannel);
            logger.debug("securityPolicyUri={}", (Object)string);
            logger.debug("securityPolicy={}", (Object)securityPolicy);
            logger.debug("encodedRemoteCertificate={}", (Object)byArray);
            logger.debug("encodedLocalCertificateThumbprint={}", (Object)byArray2);
            KeyPair keyPair = this.binding.serviceServer.getApplication().getApplicationInstanceCertificate(byArray2);
            if (keyPair == null && securityPolicy != SecurityPolicy.NONE) {
                logger.warn("Requested Application Instance Certificate is not found in the server");
                throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "Requested Application Instance Certificate is not found in the server");
            }
            try {
                cert = byArray == null ? null : new Cert(CertificateUtils.decodeX509Certificate(byArray));
            }
            catch (CertificateException certificateException) {
                throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed);
            }
            CertificateValidator certificateValidator = this.getRemoteCertificateValidator();
            if (certificateValidator != null && (object = certificateValidator.validateCertificate(cert)) != null && !((StatusCode)object).isGood()) {
                logger.warn("Remote certificate not accepted: {}", (Object)((StatusCode)object).toString());
                throw new ServiceResultException((StatusCode)object);
            }
            object = securityPolicy == SecurityPolicy.NONE ? MessageSecurityMode.None : MessageSecurityMode.SignAndEncrypt;
            SecurityMode securityMode = new SecurityMode(securityPolicy, (MessageSecurityMode)object);
            this.securityConfiguration = new SecurityConfiguration(securityMode, keyPair, cert);
            AtomicInteger atomicInteger = opcTcpServerSecureChannel == null ? null : opcTcpServerSecureChannel.recvSequenceNumber;
            this.secureMessageBuilder = new SecureInputMessageBuilder(this.securityConfiguration, this.messageListener, this.ctx, this.encoderCtx, atomicInteger);
        }
        logger.debug("onAsymmSecureChunk: {}", (Object)byteBuffer);
        this.secureMessageBuilder.addChunk(byteBuffer);
    }

    @Override
    protected CertificateValidator getRemoteCertificateValidator() {
        return this.binding == null ? null : this.binding.serviceServer.getApplication().getOpctcpSettings().getCertificateValidator();
    }

    protected void handleCloseSecureChannelRequest(InputMessage inputMessage) throws ServiceResultException {
        logger.debug("onCloseChannel");
        IEncodeable iEncodeable = inputMessage.getMessage();
        if (!(iEncodeable instanceof CloseSecureChannelRequest)) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
        }
        CloseSecureChannelRequest closeSecureChannelRequest = (CloseSecureChannelRequest)iEncodeable;
        int n = inputMessage.getSecureChannelId();
        OpcTcpServerSecureChannel opcTcpServerSecureChannel = (OpcTcpServerSecureChannel)this.secureChannels.get(n);
        if (opcTcpServerSecureChannel == null) {
            throw new ServiceResultException(StatusCodes.Bad_SecureChannelIdInvalid);
        }
        opcTcpServerSecureChannel.handleCloseSecureChannelRequest(inputMessage, closeSecureChannelRequest);
    }

    protected void handleOpenSecureChannelRequest(InputMessage inputMessage) throws ServiceResultException {
        Object object;
        IEncodeable iEncodeable = inputMessage.getMessage();
        if (iEncodeable == null) {
            OpcTcpServerConnection opcTcpServerConnection = this;
            synchronized (opcTcpServerConnection) {
                Exception exception = inputMessage.getError();
                logger.warn("InputMessage has error", (Throwable)exception);
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, (Throwable)exception);
            }
        }
        if (!(iEncodeable instanceof OpenSecureChannelRequest)) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
        }
        OpenSecureChannelRequest openSecureChannelRequest = (OpenSecureChannelRequest)iEncodeable;
        if (openSecureChannelRequest.getRequestType() == SecurityTokenRequestType.Issue) {
            object = new OpcTcpServerSecureChannel(this, this.endpointServer.secureChannelCounter.incrementAndGet());
            logger.debug("handleOpenSecureChannelRequest: endpointServer={} SecureChannelId={}", (Object)this.endpointServer, (Object)((AbstractServerSecureChannel)object).getSecureChannelId());
            ((OpcTcpServerSecureChannel)object).handleOpenChannel(inputMessage, openSecureChannelRequest);
        } else if (openSecureChannelRequest.getRequestType() == SecurityTokenRequestType.Renew) {
            object = (OpcTcpServerSecureChannel)this.secureChannels.get(inputMessage.getSecureChannelId());
            if (object == null) {
                throw new ServiceResultException(StatusCodes.Bad_SecureChannelIdInvalid);
            }
            if (!ObjectUtils.objectEquals(openSecureChannelRequest.getRequestType(), SecurityTokenRequestType.Renew)) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
            }
            ((OpcTcpServerSecureChannel)object).handleRenewSecureChannelRequest(inputMessage, openSecureChannelRequest);
        }
        object = this.secureChannels.values().toArray();
        for (Object object2 : object) {
            if (!((CloseableObjectState)((Object)((AbstractServerSecureChannel)object2).getState())).equals((Object)CloseableObjectState.Closed)) continue;
            this.secureChannels.remove(((AbstractServerSecureChannel)object2).getSecureChannelId());
        }
    }

    protected void handleSecureMessage(InputMessage inputMessage) throws ServiceResultException {
        OpcTcpServerSecureChannel opcTcpServerSecureChannel;
        IEncodeable iEncodeable = inputMessage.getMessage();
        int n = inputMessage.getSecureChannelId();
        if (logger.isDebugEnabled()) {
            logger.debug("handleSecureMessage: secureChannelId=" + n + "msg=" + (iEncodeable == null ? "null" : iEncodeable.getClass().getSimpleName()));
        }
        if ((opcTcpServerSecureChannel = (OpcTcpServerSecureChannel)this.secureChannels.get(n)) == null) {
            throw new ServiceResultException(StatusCodes.Bad_SecureChannelIdInvalid);
        }
        if (iEncodeable instanceof OpenSecureChannelRequest) {
            OpenSecureChannelRequest openSecureChannelRequest = (OpenSecureChannelRequest)iEncodeable;
            if (!ObjectUtils.objectEquals(openSecureChannelRequest.getRequestType(), SecurityTokenRequestType.Renew)) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
            }
            opcTcpServerSecureChannel.handleRenewSecureChannelRequest(inputMessage, openSecureChannelRequest);
        } else if (iEncodeable instanceof CloseSecureChannelRequest) {
            opcTcpServerSecureChannel.handleCloseSecureChannelRequest(inputMessage, (CloseSecureChannelRequest)iEncodeable);
        } else {
            opcTcpServerSecureChannel.handleSecureMessage(inputMessage, iEncodeable);
        }
    }

    @Override
    protected synchronized void onStateTransition(CloseableObjectState closeableObjectState, CloseableObjectState closeableObjectState2) {
        super.onStateTransition(closeableObjectState, closeableObjectState2);
        logger.debug("onStateTransition: {}->{}", (Object)closeableObjectState, (Object)closeableObjectState2);
        if (closeableObjectState2 == CloseableObjectState.Closing) {
            ServiceResultException serviceResultException = (ServiceResultException)this.getError();
            ArrayList<ServerSecureChannel> arrayList = new ArrayList<ServerSecureChannel>();
            this.getSecureChannels(arrayList);
            for (ServerSecureChannel serverSecureChannel : arrayList) {
                OpcTcpServerSecureChannel opcTcpServerSecureChannel = (OpcTcpServerSecureChannel)serverSecureChannel;
                if (opcTcpServerSecureChannel != null && serviceResultException != null) {
                    opcTcpServerSecureChannel.setError(serviceResultException);
                }
                serverSecureChannel.close();
            }
        }
    }

    @Override
    public void addConnectionListener(IConnectionListener iConnectionListener) {
        logger.debug("addConnectionListener: listener={}", (Object)iConnectionListener);
        super.addConnectionListener(iConnectionListener);
    }

    @Override
    public void removeConnectionListener(IConnectionListener iConnectionListener) {
        logger.debug("removeConnectionListener: listener={}", (Object)iConnectionListener);
        super.removeConnectionListener(iConnectionListener);
        this.cancelTimeoutTimer();
    }

    private String trimUrl(String string) {
        if (string == null) {
            return null;
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endChunkSend(ByteBuffer byteBuffer) {
        this.chunkIncubator.hatch(byteBuffer);
        OpcTcpServerConnection opcTcpServerConnection = this;
        synchronized (opcTcpServerConnection) {
            while (this.chunkIncubator.nextIsHatched()) {
                ByteBuffer byteBuffer2 = (ByteBuffer)this.chunkIncubator.removeNextHatchedIfAvailable();
                byteBuffer2.rewind();
                this.s.getOutputStream().offer(byteBuffer2);
            }
        }
    }

    protected BufferMonitorState flush(long l) throws InterruptedException, IOException {
        return this.s.getOutputStream().createMonitor(l, null).waitForState(BufferMonitorState.FINAL_STATES);
    }

    @Override
    public SocketAddress getLocalAddress() {
        Socket socket = this.s.socket();
        if (socket == null) {
            return null;
        }
        return socket.getLocalSocketAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        Socket socket = this.s.socket();
        if (socket == null) {
            return null;
        }
        return socket.getRemoteSocketAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int sendAsymmSecureMessage(AsyncWrite asyncWrite, SecurityConfiguration securityConfiguration, int n, int n2, AtomicInteger atomicInteger) throws ServiceResultException {
        Object object = asyncWrite;
        synchronized (object) {
            if (asyncWrite.isCanceled()) {
                return -1;
            }
            asyncWrite.setQueued();
        }
        object = new ChunkFactory.AsymmMsgChunkFactory(this.ctx.maxSendChunkSize, securityConfiguration);
        MessageToChunks messageToChunks = new MessageToChunks(asyncWrite.getMessage(), this.ctx, this.encoderCtx, (ChunkFactory)object, MessageType.Message);
        ByteBuffer[] byteBufferArray = messageToChunks.call();
        ByteBuffer[] byteBufferArray2 = ((ChunkFactory)object).expandToCompleteChunk(byteBufferArray);
        Object object2 = asyncWrite;
        synchronized (object2) {
            if (asyncWrite.isCanceled()) {
                return -1;
            }
            asyncWrite.setWriting();
        }
        object2 = securityConfiguration.getSecurityPolicy();
        this.startChunkSend(byteBufferArray2);
        for (int i = 0; i < byteBufferArray2.length; ++i) {
            ByteBuffer byteBuffer = byteBufferArray2[i];
            ByteBuffer byteBuffer2 = byteBufferArray[i];
            boolean bl = byteBuffer == byteBufferArray2[byteBufferArray2.length - 1];
            byteBuffer.rewind();
            byteBuffer.putInt(0x4E504F | (bl ? 0x46000000 : 0x43000000));
            byteBuffer.position(8);
            byteBuffer.putInt(n);
            byte[] byArray = ((SecurityPolicy)object2).getEncodedPolicyUri();
            byteBuffer.putInt(byArray.length);
            byteBuffer.put(byArray);
            byArray = securityConfiguration.getEncodedLocalCertificate();
            byteBuffer.putInt(byArray == null ? -1 : byArray.length);
            if (byArray != null) {
                byteBuffer.put(byArray);
            }
            byteBuffer.putInt((byArray = securityConfiguration.getEncodedRemoteCertificateThumbprint()) == null ? -1 : byArray.length);
            if (byArray != null) {
                byteBuffer.put(byArray);
            }
            byteBuffer.putInt(atomicInteger.getAndIncrement());
            byteBuffer.putInt(n2);
            new ChunkAsymmEncryptSigner(byteBuffer, byteBuffer2, securityConfiguration).run();
            byteBuffer.rewind();
            this.endChunkSend(byteBuffer);
        }
        asyncWrite.setWritten();
        return byteBufferArray2.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendSecureMessage(final AsyncWrite asyncWrite, final SecurityToken securityToken, int n, int n2, AtomicInteger atomicInteger) {
        ByteBuffer[] byteBufferArray;
        ByteBuffer[] byteBufferArray2;
        boolean bl;
        int n3;
        ByteBuffer[] byteBufferArray3;
        assert (securityToken != null);
        try {
            int n4;
            byteBufferArray3 = asyncWrite;
            synchronized (byteBufferArray3) {
                if (asyncWrite.isCanceled()) {
                    return;
                }
                asyncWrite.setQueued();
            }
            if (logger.isTraceEnabled()) {
                logger.trace("sendSecureMessage: " + ObjectUtils.printFieldsDeep(asyncWrite.getMessage()));
            }
            byteBufferArray3 = new EncoderCalc();
            byteBufferArray3.setEncoderContext(this.encoderCtx);
            byteBufferArray3.putMessage(asyncWrite.getMessage());
            int n5 = byteBufferArray3.getLength();
            if (n5 > this.ctx.maxSendMessageSize && this.ctx.maxSendMessageSize != 0) {
                throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
            }
            SecurityPolicy securityPolicy = securityToken.getSecurityPolicy();
            MessageSecurityMode messageSecurityMode = securityToken.getMessageSecurityMode();
            SecurityAlgorithm securityAlgorithm = securityPolicy.getSymmetricEncryptionAlgorithm();
            SecurityAlgorithm object = securityPolicy.getSymmetricSignatureAlgorithm();
            int n6 = CryptoUtil.getCipherBlockSize(securityAlgorithm, null);
            int n7 = CryptoUtil.getSignatureSize(object, null);
            int n8 = n4 = messageSecurityMode == MessageSecurityMode.SignAndEncrypt ? securityToken.getRemoteEncryptingKey().length : 0;
            n3 = messageSecurityMode == MessageSecurityMode.SignAndEncrypt ? (n4 > 2048 ? 2 : 1) : 0;
            int n9 = this.ctx.maxSendChunkSize - 24 - n3 - n7;
            n9 -= (n9 + n3 + n7 + 8) % n6;
            int n10 = StackUtils.cores();
            int n11 = (n5 + n10 - 1) / n10;
            if (n11 > n9) {
                n11 = n9;
            }
            if (n11 < 4096) {
                n11 = 4096;
            }
            int n12 = n11 + 24 + n3 + n7;
            ChunkFactory chunkFactory = new ChunkFactory(n12, 8, 8, 8, n7, n6, messageSecurityMode, n4);
            int n13 = (n5 + chunkFactory.maxPlaintextSize - 1) / chunkFactory.maxPlaintextSize;
            if (n13 > this.ctx.maxSendChunkCount && this.ctx.maxSendChunkCount != 0) {
                throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
            }
            bl = n13 > 1 && n10 > 0 && messageSecurityMode != MessageSecurityMode.None;
            int n14 = n5;
            byteBufferArray2 = new ByteBuffer[n13];
            byteBufferArray = new ByteBuffer[n13];
            for (int i = 0; i < n13; ++i) {
                byteBufferArray2[i] = chunkFactory.allocate(n14);
                byteBufferArray[i] = chunkFactory.expandToCompleteChunk(byteBufferArray2[i]);
                n14 -= byteBufferArray2[i].remaining();
            }
            assert (n14 == 0);
            AsyncWrite asyncWrite2 = asyncWrite;
            synchronized (asyncWrite2) {
                if (asyncWrite.isCanceled()) {
                    return;
                }
                asyncWrite.setWriting();
            }
        }
        catch (ServiceResultException serviceResultException) {
            asyncWrite.setError(serviceResultException);
            return;
        }
        byteBufferArray3 = byteBufferArray;
        final ByteBuffer[] byteBufferArray4 = byteBufferArray2;
        final int n15 = byteBufferArray.length;
        final boolean bl2 = bl;
        int n16 = 0;
        OpcTcpServerConnection opcTcpServerConnection = this;
        synchronized (opcTcpServerConnection) {
            n16 = atomicInteger.getAndAdd(byteBufferArray.length);
            this.startChunkSend(byteBufferArray);
        }
        for (ByteBuffer byteBuffer : byteBufferArray) {
            n3 = byteBuffer == byteBufferArray[byteBufferArray.length - 1] ? 1 : 0;
            byteBuffer.rewind();
            byteBuffer.putInt(n2 | (n3 != 0 ? 0x46000000 : 0x43000000));
            byteBuffer.position(8);
            byteBuffer.putInt(securityToken.getSecureChannelId());
            byteBuffer.putInt(securityToken.getTokenId());
            byteBuffer.putInt(n16++);
            byteBuffer.putInt(n);
        }
        final AtomicInteger atomicInteger2 = new AtomicInteger();
        ByteBufferArrayWriteable2.ChunkListener chunkListener = new ByteBufferArrayWriteable2.ChunkListener(){

            @Override
            public void onChunkComplete(ByteBuffer[] byteBufferArray, final int n) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        new ChunkSymmEncryptSigner(byteBufferArray3[n], byteBufferArray4[n], securityToken).run();
                        byteBufferArray3[n].rewind();
                        OpcTcpServerConnection.this.endChunkSend(byteBufferArray3[n]);
                        if (atomicInteger2.incrementAndGet() == n15) {
                            asyncWrite.setWritten();
                        }
                    }
                };
                if (bl2 && n15 > 1) {
                    StackUtils.getNonBlockingWorkExecutor().execute(runnable);
                } else {
                    runnable.run();
                }
            }
        };
        ByteBufferArrayWriteable2 byteBufferArrayWriteable2 = new ByteBufferArrayWriteable2(byteBufferArray2, chunkListener);
        byteBufferArrayWriteable2.order(ByteOrder.LITTLE_ENDIAN);
        final BinaryEncoder binaryEncoder = new BinaryEncoder(byteBufferArrayWriteable2);
        binaryEncoder.setEncoderContext(this.encoderCtx);
        binaryEncoder.setEncoderMode(EncoderMode.NonStrict);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    binaryEncoder.putMessage(asyncWrite.getMessage());
                }
                catch (ServiceResultException serviceResultException) {
                    asyncWrite.setError(StackUtils.toServiceResultException(serviceResultException));
                }
            }
        };
        StackUtils.getBlockingWorkExecutor().execute(runnable);
    }

    protected void handleChunk(ByteBuffer byteBuffer) throws ServiceResultException {
        int n = ChunkUtils.getMessageType(byteBuffer);
        int n2 = n & 0xFFFFFF;
        if (n2 == 4674381) {
            this.handleSymmChunk(byteBuffer);
        } else if (n2 == 5196867) {
            this.handleCloseChunk(byteBuffer);
        } else if (n2 == 5132367) {
            this.handleAsymmChunk(byteBuffer);
        } else if (n2 == 4998472 || n2 == 4932417 || n2 == 0x525245) {
            this.handleRawChunk(byteBuffer);
        } else {
            this.close();
        }
    }

    protected void handleRawChunk(ByteBuffer byteBuffer) {
        int n = ChunkUtils.getMessageType(byteBuffer);
        int n2 = n & 0xFFFFFF;
        int n3 = n & 0xFF000000;
        if (n3 != 0x46000000) {
            this.close();
        }
        byteBuffer.position(8);
        try {
            if (n2 == 4998472) {
                ChunksToMessage chunksToMessage = new ChunksToMessage(this.ctx, this.encoderCtx, Hello.class, byteBuffer);
                this.handleHelloMessage((Hello)chunksToMessage.call());
            } else if (n2 == 4932417) {
                ChunksToMessage chunksToMessage = new ChunksToMessage(this.ctx, this.encoderCtx, Acknowledge.class, byteBuffer);
                this.handleAcknowledgeMessage((Acknowledge)chunksToMessage.call());
            } else if (n2 == 0x525245) {
                ChunksToMessage chunksToMessage = new ChunksToMessage(this.ctx, this.encoderCtx, ErrorMessage.class, byteBuffer);
                this.handleErrorMessage((ErrorMessage)chunksToMessage.call());
            }
        }
        catch (Exception exception) {
            this.setError(StackUtils.toServiceResultException(exception));
        }
    }

    protected void handleCloseChunk(ByteBuffer byteBuffer) throws ServiceResultException {
        this.close();
    }

    protected void handleSymmChunk(ByteBuffer byteBuffer) throws ServiceResultException {
        int n = ChunkUtils.getSecureChannelId(byteBuffer);
        int n2 = ChunkUtils.getTokenId(byteBuffer);
        byteBuffer.rewind();
        OpcTcpServerSecureChannel opcTcpServerSecureChannel = (OpcTcpServerSecureChannel)this.secureChannels.get(n);
        if (opcTcpServerSecureChannel == null) {
            throw new ServiceResultException(StatusCodes.Bad_TcpSecureChannelUnknown);
        }
        if (((CloseableObjectState)((Object)opcTcpServerSecureChannel.getState())).equals((Object)CloseableObjectState.Closed)) {
            throw new ServiceResultException(StatusCodes.Bad_SecureChannelIdInvalid);
        }
        SecurityToken securityToken = opcTcpServerSecureChannel.getSecurityToken(n2);
        if (securityToken == null) {
            throw new ServiceResultException(StatusCodes.Bad_SecureChannelTokenUnknown);
        }
        if (!securityToken.isValid()) {
            securityToken = opcTcpServerSecureChannel.getLatestNonExpiredToken();
        }
        if (securityToken == null || !securityToken.isValid()) {
            System.err.println("Token expired");
            throw new ServiceResultException(StatusCodes.Bad_SecureChannelClosed);
        }
        SecurityToken securityToken2 = opcTcpServerSecureChannel.getActiveSecurityToken();
        if (securityToken != securityToken2) {
            logger.debug("handleSymmChunk: activeToken={}, token={}", (Object)securityToken2, (Object)securityToken);
            if (securityToken2.getCreationTime() < securityToken.getCreationTime()) {
                opcTcpServerSecureChannel.setActiveSecurityToken(securityToken);
            }
        }
        logger.debug("handleSymmChunk: {}", (Object)this.secureMessageBuilder);
        if (this.secureMessageBuilder != null && !this.secureMessageBuilder.moreChunksRequired()) {
            this.secureMessageBuilder = null;
        }
        if (this.secureMessageBuilder == null) {
            this.secureMessageBuilder = new SecureInputMessageBuilder(securityToken, this.messageListener, this.ctx, this.encoderCtx, opcTcpServerSecureChannel.recvSequenceNumber);
            logger.debug("handleSymmChunk: secureMessageBuilder={}", (Object)this.secureMessageBuilder);
        }
        this.secureMessageBuilder.addChunk(byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CloseableObject close() {
        try {
            this.setState(CloseableObjectState.Closing);
        }
        finally {
            try {
                this.s.close();
            }
            catch (IOException iOException) {}
            this.setState(CloseableObjectState.Closed);
        }
        return this;
    }

    @Override
    protected synchronized void setError(ServiceResultException serviceResultException) {
        if (!this.hasError()) {
            try {
                this.sendError(new ErrorMessage(serviceResultException.getStatusCode(), serviceResultException.getMessage()));
            }
            catch (ServiceResultException serviceResultException2) {
                logger.warn("Could not send error message", (Throwable)serviceResultException2);
            }
            super.setError(serviceResultException);
        }
    }
}

