/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.tcp.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.opcfoundation.ua.application.Application;
import org.opcfoundation.ua.application.Server;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.transport.CloseableObjectState;
import org.opcfoundation.ua.transport.ConnectionMonitor;
import org.opcfoundation.ua.transport.Endpoint;
import org.opcfoundation.ua.transport.EndpointBinding;
import org.opcfoundation.ua.transport.EndpointServer;
import org.opcfoundation.ua.transport.IConnectionListener;
import org.opcfoundation.ua.transport.ServerConnection;
import org.opcfoundation.ua.transport.UriUtil;
import org.opcfoundation.ua.transport.endpoint.EndpointBindingCollection;
import org.opcfoundation.ua.transport.impl.ConnectionCollection;
import org.opcfoundation.ua.transport.tcp.nio.OpcTcpServerConnection;
import org.opcfoundation.ua.utils.AbstractState;
import org.opcfoundation.ua.utils.StackUtils;
import org.opcfoundation.ua.utils.asyncsocket.AsyncServerSocket;
import org.opcfoundation.ua.utils.asyncsocket.AsyncSocketImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcTcpServer
extends AbstractState<CloseableObjectState, ServiceResultException>
implements EndpointServer {
    static Logger logger = LoggerFactory.getLogger(OpcTcpServer.class);
    Application application;
    AtomicInteger secureChannelCounter = new AtomicInteger();
    EndpointBindingCollection endpointBindings = new EndpointBindingCollection();
    public Server discoveryServer;
    public EndpointBinding discoveryEndpointBinding;
    private int receiveBufferSize = 0;
    Map<SocketAddress, SocketHandle> socketHandles = new HashMap<SocketAddress, SocketHandle>();
    AsyncServerSocket.ConnectListener connectListener = new AsyncServerSocket.ConnectListener(){

        @Override
        public void onConnected(AsyncServerSocket asyncServerSocket, AsyncSocketImpl asyncSocketImpl) {
            logger.info("{}: {} connected", (Object)OpcTcpServer.this, (Object)asyncSocketImpl.socket().getRemoteSocketAddress());
            final OpcTcpServerConnection opcTcpServerConnection = new OpcTcpServerConnection(OpcTcpServer.this, asyncSocketImpl);
            OpcTcpServer.this.connections.addConnection(opcTcpServerConnection);
            opcTcpServerConnection.addConnectionListener(new IConnectionListener(){

                @Override
                public void onClosed(ServiceResultException serviceResultException) {
                    OpcTcpServer.this.connections.removeConnection(opcTcpServerConnection);
                }

                @Override
                public void onOpen() {
                }
            });
        }
    };
    ConnectionCollection connections = new ConnectionCollection(this);

    @Override
    public EncoderContext getEncoderContext() {
        return this.application.getEncoderContext();
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int n) throws ServiceResultException {
        this.receiveBufferSize = n;
        if (n > 0) {
            for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
                try {
                    AsyncServerSocket asyncServerSocket = socketHandle.socket;
                    if (asyncServerSocket == null) continue;
                    asyncServerSocket.socket().setReceiveBufferSize(n);
                }
                catch (SocketException socketException) {
                    throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)socketException);
                }
            }
        }
    }

    public OpcTcpServer(Application application) throws ServiceResultException {
        super(CloseableObjectState.Closed, CloseableObjectState.Closed);
        this.application = application;
        try {
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocketChannel.configureBlocking(false);
            this.discoveryServer = new Server(application);
            this.discoveryServer.setEndpointBindings(this.endpointBindings);
            this.discoveryEndpointBinding = new EndpointBinding(this, discoveryEndpoint, this.discoveryServer);
        }
        catch (IOException iOException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)iOException);
        }
    }

    @Override
    public EndpointServer.EndpointHandle bind(SocketAddress socketAddress, EndpointBinding endpointBinding) throws ServiceResultException {
        if (endpointBinding == null || socketAddress == null || endpointBinding.endpointServer != this) {
            throw new IllegalArgumentException();
        }
        String string = UriUtil.getTransportProtocol(endpointBinding.endpointAddress.getEndpointUrl());
        if (!"opc.tcp".equals(string)) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Cannot bind " + string + " to opc.tcp server");
        }
        SocketHandle socketHandle = this.getOrCreateSocketHandle(socketAddress);
        if (socketHandle.socket == null) {
            try {
                socketHandle.setChannel(ServerSocketChannel.open());
                socketHandle.getChannel().configureBlocking(false);
                socketHandle.socket = new AsyncServerSocket(socketHandle.getChannel(), StackUtils.getNonBlockingWorkExecutor(), StackUtils.getSelector());
                socketHandle.socket.bind(socketHandle.socketAddress, 0);
                socketHandle.socket.addListener(this.connectListener);
                logger.info("TCP/IP Socket bound to {}", (Object)socketAddress);
            }
            catch (IOException iOException) {
                logger.error("Failed to bind address " + socketHandle.socketAddress, (Throwable)iOException);
                socketHandle.close();
                throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)iOException);
            }
        }
        OpcTcpEndpointHandle opcTcpEndpointHandle = socketHandle.getOrCreate(endpointBinding);
        return opcTcpEndpointHandle;
    }

    @Override
    public List<SocketAddress> getBoundSocketAddresses() {
        ArrayList<SocketAddress> arrayList = new ArrayList<SocketAddress>();
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            arrayList.add(socketHandle.socketAddress);
        }
        return arrayList;
    }

    public SocketAddress getBoundAddress() {
        SocketHandle[] socketHandleArray;
        for (SocketHandle socketHandle : socketHandleArray = this.socketHandleSnapshot()) {
            if (socketHandle.socket == null) continue;
            return socketHandle.socketAddress;
        }
        return null;
    }

    public void disconnectAll() {
        ArrayList<ServerConnection> arrayList = new ArrayList<ServerConnection>();
        this.getConnections(arrayList);
        for (ServerConnection serverConnection : arrayList) {
            OpcTcpServerConnection opcTcpServerConnection = (OpcTcpServerConnection)serverConnection;
            opcTcpServerConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized OpcTcpServer close() {
        logger.info("{} closed", (Object)this.getBoundAddress());
        if (!((CloseableObjectState)((Object)this.getState())).isClosed()) {
            this.setState(CloseableObjectState.Closing);
        }
        try {
            for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
                socketHandle.close();
            }
        }
        finally {
            this.setState(CloseableObjectState.Closed);
        }
        return this;
    }

    @Override
    public void addConnectionListener(ConnectionMonitor.ConnectListener connectListener) {
        this.connections.addConnectionListener(connectListener);
    }

    @Override
    public void getConnections(Collection<ServerConnection> collection) {
        this.connections.getConnections(collection);
    }

    @Override
    public void removeConnectionListener(ConnectionMonitor.ConnectListener connectListener) {
        this.connections.removeConnectionListener(connectListener);
    }

    @Override
    public EndpointBindingCollection getEndpointBindings() {
        return this.endpointBindings;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OpcTcpServer");
        stringBuilder.append("(");
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            stringBuilder.append(socketHandle.toString());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    synchronized SocketHandle getOrCreateSocketHandle(SocketAddress socketAddress) throws ServiceResultException {
        SocketHandle socketHandle = this.socketHandles.get(socketAddress);
        if (socketHandle == null) {
            socketHandle = new SocketHandle(socketAddress);
            this.socketHandles.put(socketAddress, socketHandle);
        }
        return socketHandle;
    }

    public SocketHandle[] socketHandleSnapshot() {
        return this.socketHandles.values().toArray(new SocketHandle[this.socketHandles.size()]);
    }

    List<OpcTcpEndpointHandle> findEndpoints(String string) {
        ArrayList<OpcTcpEndpointHandle> arrayList = new ArrayList<OpcTcpEndpointHandle>();
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            socketHandle.endpointHandleSnapshot(arrayList);
        }
        return arrayList;
    }

    int countEndpoints(Endpoint endpoint) {
        int n = 0;
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            for (OpcTcpEndpointHandle opcTcpEndpointHandle : socketHandle.endpointHandleSnapshot()) {
                if (!opcTcpEndpointHandle.endpointBinding.endpointAddress.equals(endpoint)) continue;
                ++n;
            }
        }
        return n;
    }

    public class OpcTcpEndpointHandle
    implements EndpointServer.EndpointHandle {
        EndpointBinding endpointBinding;
        SocketHandle socketHandle;

        OpcTcpEndpointHandle(SocketHandle socketHandle, EndpointBinding endpointBinding) {
            this.socketHandle = socketHandle;
            this.endpointBinding = endpointBinding;
        }

        @Override
        public SocketAddress socketAddress() {
            return this.socketHandle.socketAddress;
        }

        @Override
        public EndpointBinding endpointBinding() {
            return this.endpointBinding;
        }

        @Override
        public void close() {
            this.close_();
            this.close__();
        }

        void close_() {
            this.socketHandle.endpoints.remove(this.endpointBinding.endpointAddress);
            if (this.socketHandle.endpoints.isEmpty()) {
                this.socketHandle.close();
            }
        }

        void close__() {
            int n = OpcTcpServer.this.countEndpoints(this.endpointBinding.endpointAddress);
            if (n == 0) {
                OpcTcpServer.this.endpointBindings.remove(this.endpointBinding);
                this.endpointBinding.serviceServer.getEndpointBindings().remove(this.endpointBinding);
            }
        }

        public String toString() {
            return "(" + this.endpointBinding.endpointAddress.toString() + ")";
        }
    }

    public class SocketHandle {
        SocketAddress socketAddress;
        AsyncServerSocket socket;
        private ServerSocketChannel channel;
        int port;
        Map<Endpoint, OpcTcpEndpointHandle> endpoints = new HashMap<Endpoint, OpcTcpEndpointHandle>();

        SocketHandle(SocketAddress socketAddress) {
            this.socketAddress = socketAddress;
        }

        public synchronized OpcTcpEndpointHandle[] endpointHandleSnapshot() {
            return this.endpoints.values().toArray(new OpcTcpEndpointHandle[this.endpoints.size()]);
        }

        synchronized void endpointHandleSnapshot(Collection<OpcTcpEndpointHandle> collection) {
            collection.addAll(this.endpoints.values());
        }

        synchronized OpcTcpEndpointHandle getOrCreate(EndpointBinding endpointBinding) throws ServiceResultException {
            OpcTcpEndpointHandle opcTcpEndpointHandle = this.endpoints.get(endpointBinding.endpointAddress);
            if (opcTcpEndpointHandle == null) {
                opcTcpEndpointHandle = new OpcTcpEndpointHandle(this, endpointBinding);
                this.endpoints.put(endpointBinding.endpointAddress, opcTcpEndpointHandle);
                OpcTcpServer.this.endpointBindings.add(endpointBinding);
                endpointBinding.serviceServer.getEndpointBindings().add(endpointBinding);
            } else if (!opcTcpEndpointHandle.endpointBinding.equals(endpointBinding)) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Cannot bind an endpoint address to two different servers.");
            }
            return opcTcpEndpointHandle;
        }

        int getPort() {
            return ((InetSocketAddress)this.socketAddress).getPort();
        }

        void close() {
            for (OpcTcpEndpointHandle opcTcpEndpointHandle : this.endpoints.values()) {
                opcTcpEndpointHandle.close__();
            }
            OpcTcpServer.this.socketHandles.remove(this.socketAddress);
            if (this.socket != null) {
                AsyncServerSocket asyncServerSocket = this.socket;
                this.socket = null;
                asyncServerSocket.close();
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("opc.tcp(" + this.socketAddress + ", ");
            for (OpcTcpEndpointHandle opcTcpEndpointHandle : this.endpoints.values()) {
                stringBuilder.append(opcTcpEndpointHandle.toString());
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        public ServerSocketChannel getChannel() {
            return this.channel;
        }

        public void setChannel(ServerSocketChannel serverSocketChannel) {
            this.channel = serverSocketChannel;
        }

        public SocketAddress getSocketAddress() {
            return this.socketAddress;
        }
    }
}

