/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.tcp.nio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.Callable;
import org.opcfoundation.ua.common.RuntimeServiceResultException;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.encoding.EncoderMode;
import org.opcfoundation.ua.encoding.IEncodeable;
import org.opcfoundation.ua.encoding.binary.BinaryEncoder;
import org.opcfoundation.ua.encoding.binary.EncoderCalc;
import org.opcfoundation.ua.transport.tcp.impl.ChunkFactory;
import org.opcfoundation.ua.transport.tcp.impl.TcpConnectionParameters;
import org.opcfoundation.ua.transport.tcp.nio.MessageType;
import org.opcfoundation.ua.utils.bytebuffer.ByteBufferArrayWriteable;
import org.opcfoundation.ua.utils.bytebuffer.ByteQueue;

public class MessageToChunks
implements Callable<ByteBuffer[]> {
    MessageType type;
    IEncodeable msg;
    TcpConnectionParameters ctx;
    EncoderContext encoderCtx;
    ChunkFactory chunkFactory;

    public MessageToChunks(IEncodeable iEncodeable, TcpConnectionParameters tcpConnectionParameters, EncoderContext encoderContext, ChunkFactory chunkFactory, MessageType messageType) {
        if (iEncodeable == null || tcpConnectionParameters == null || chunkFactory == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.msg = iEncodeable;
        this.ctx = tcpConnectionParameters;
        this.encoderCtx = encoderContext;
        this.chunkFactory = chunkFactory;
        this.type = messageType;
    }

    @Override
    public ByteBuffer[] call() throws RuntimeServiceResultException {
        try {
            EncoderCalc encoderCalc = new EncoderCalc();
            encoderCalc.setEncoderContext(this.encoderCtx);
            if (this.type == MessageType.Encodeable) {
                encoderCalc.putEncodeable(null, this.msg);
            } else {
                encoderCalc.putMessage(this.msg);
            }
            int n = encoderCalc.getLength();
            if (n > this.ctx.maxSendMessageSize && this.ctx.maxSendMessageSize != 0) {
                throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
            }
            ByteQueue byteQueue = new ByteQueue();
            byteQueue.order(ByteOrder.LITTLE_ENDIAN);
            byteQueue.setWriteLimit(n);
            byteQueue.setByteBufferFactory(this.chunkFactory);
            byteQueue.setChunkSize(this.chunkFactory.maxPlaintextSize);
            ByteBufferArrayWriteable byteBufferArrayWriteable = new ByteBufferArrayWriteable(byteQueue);
            byteBufferArrayWriteable.order(ByteOrder.LITTLE_ENDIAN);
            BinaryEncoder binaryEncoder = new BinaryEncoder(byteBufferArrayWriteable);
            binaryEncoder.setEncoderContext(this.encoderCtx);
            binaryEncoder.setEncoderMode(EncoderMode.NonStrict);
            if (this.type == MessageType.Message) {
                binaryEncoder.putMessage(this.msg);
            } else {
                binaryEncoder.putEncodeable(null, this.msg);
            }
            ByteBuffer[] byteBufferArray = byteQueue.getChunks(n);
            if (byteBufferArray.length > this.ctx.maxRecvChunkCount && this.ctx.maxRecvChunkCount != 0) {
                throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
            }
            return byteBufferArray;
        }
        catch (ServiceResultException serviceResultException) {
            throw new RuntimeServiceResultException(serviceResultException);
        }
    }
}

