/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.tcp.nio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.Callable;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.encoding.IEncodeable;
import org.opcfoundation.ua.encoding.binary.BinaryDecoder;
import org.opcfoundation.ua.transport.tcp.impl.TcpConnectionParameters;
import org.opcfoundation.ua.utils.bytebuffer.ByteBufferArrayReadable;

public class ChunksToMessage
implements Callable<IEncodeable> {
    Class<? extends IEncodeable> expectedType;
    TcpConnectionParameters ctx;
    EncoderContext encoderCtx;
    ByteBuffer[] plaintexts;

    public ChunksToMessage(TcpConnectionParameters tcpConnectionParameters, EncoderContext encoderContext, Class<? extends IEncodeable> clazz, ByteBuffer ... byteBufferArray) {
        this.expectedType = clazz;
        this.plaintexts = byteBufferArray;
        this.ctx = tcpConnectionParameters;
        this.encoderCtx = encoderContext;
    }

    @Override
    public IEncodeable call() throws Exception {
        ByteBufferArrayReadable byteBufferArrayReadable = new ByteBufferArrayReadable(this.plaintexts);
        byteBufferArrayReadable.order(ByteOrder.LITTLE_ENDIAN);
        BinaryDecoder binaryDecoder = new BinaryDecoder(byteBufferArrayReadable);
        binaryDecoder.setEncoderContext(this.encoderCtx);
        if (this.expectedType != null) {
            return binaryDecoder.getEncodeable(null, this.expectedType);
        }
        return binaryDecoder.getMessage();
    }
}

