/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.tcp.impl;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.StatusCodes;

public class ChunkUtils {
    private static Charset UTF8 = Charset.forName("UTF8");

    public static int getMessageType(ByteBuffer byteBuffer) {
        byteBuffer.position(0);
        return byteBuffer.getInt();
    }

    public static int getSecureChannelId(ByteBuffer byteBuffer) {
        byteBuffer.position(8);
        return byteBuffer.getInt();
    }

    public static int getTokenId(ByteBuffer byteBuffer) {
        byteBuffer.position(12);
        return byteBuffer.getInt();
    }

    public static int getSequenceNumber(ByteBuffer byteBuffer) {
        byteBuffer.position(16);
        return byteBuffer.getInt();
    }

    public static byte[] getRecvCertificateThumbprint(ByteBuffer byteBuffer) {
        int n;
        byteBuffer.position(12);
        int n2 = byteBuffer.getInt();
        if (n2 > 0) {
            byteBuffer.position(byteBuffer.position() + n2);
        }
        if ((n = byteBuffer.getInt()) > 0) {
            byteBuffer.position(byteBuffer.position() + n);
        }
        return ChunkUtils.getByteString(byteBuffer);
    }

    public static int getRequestId(ByteBuffer byteBuffer) {
        byteBuffer.position(20);
        return byteBuffer.getInt();
    }

    public static String getAbortMessage(ByteBuffer byteBuffer) throws ServiceResultException {
        byteBuffer.position(8);
        return ChunkUtils.getString(byteBuffer);
    }

    public static String getSecurityPolicyUri(ByteBuffer byteBuffer) throws ServiceResultException {
        byteBuffer.position(12);
        return ChunkUtils.getString(byteBuffer);
    }

    public static String getString(ByteBuffer byteBuffer) throws ServiceResultException {
        byte[] byArray = ChunkUtils.getByteString(byteBuffer);
        String string = new String(byArray, UTF8);
        return string;
    }

    public static byte[] getByteString(ByteBuffer byteBuffer) {
        int n = byteBuffer.getInt();
        if (n == -1) {
            return null;
        }
        if (n < -1 || n > byteBuffer.remaining()) {
            new ServiceResultException(StatusCodes.Bad_CommunicationError, "Unexpected length");
        }
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return byArray;
    }
}

