/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.tcp.impl;

import java.nio.ByteBuffer;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import org.opcfoundation.ua.common.RuntimeServiceResultException;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.MessageSecurityMode;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.transport.security.CryptoProvider;
import org.opcfoundation.ua.transport.security.SecurityAlgorithm;
import org.opcfoundation.ua.transport.security.SecurityConfiguration;
import org.opcfoundation.ua.transport.security.SecurityPolicy;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkAsymmEncryptSigner
implements Runnable {
    static Logger logger = LoggerFactory.getLogger(ChunkAsymmEncryptSigner.class);
    ByteBuffer chunk;
    ByteBuffer plaintext;
    SecurityConfiguration profile;
    private int signatureSize;

    public ChunkAsymmEncryptSigner(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, SecurityConfiguration securityConfiguration) {
        this.chunk = byteBuffer;
        this.plaintext = byteBuffer2;
        this.profile = securityConfiguration;
    }

    @Override
    public void run() throws RuntimeServiceResultException {
        try {
            int n = this.plaintext.limit();
            MessageSecurityMode messageSecurityMode = this.profile.getMessageSecurityMode();
            if (messageSecurityMode == MessageSecurityMode.Sign) {
                messageSecurityMode = MessageSecurityMode.SignAndEncrypt;
            }
            SecurityPolicy securityPolicy = this.profile.getSecurityPolicy();
            int n2 = 8;
            SecurityAlgorithm securityAlgorithm = securityPolicy.getAsymmetricSignatureAlgorithm();
            this.signatureSize = messageSecurityMode.hasSigning() ? CryptoUtil.getSignatureSize(securityAlgorithm, this.profile.getLocalPrivateKey()) : 0;
            logger.debug("SecurityMode in asymm enc: {}", (Object)messageSecurityMode.getValue());
            int n3 = 0;
            if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                int n4 = this.profile.getRemoteCertificate2().getKeySize();
                logger.trace("keySize={}", (Object)n4);
                n3 = this.getPaddingSize(n4);
                logger.trace("padding={}", (Object)n3);
            }
            if (messageSecurityMode == MessageSecurityMode.Sign || messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                byte[] byArray = new byte[this.plaintext.arrayOffset() + n + n3];
                this.chunk.rewind();
                this.chunk.get(byArray, 0, byArray.length);
                byte[] byArray2 = this.sign(byArray, this.profile.getLocalPrivateKey());
                this.chunk.put(byArray2);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("getPaddingSize: chunk={}", (Object)CryptoUtil.toHex(this.chunk.array(), 64));
            }
            if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                byte[] byArray = new byte[n2 + n + n3 + this.signatureSize];
                this.chunk.position(this.plaintext.arrayOffset() - n2);
                this.chunk.get(byArray, 0, byArray.length);
                this.encrypt(byArray, this.profile.getRemoteCertificate().getPublicKey(), this.chunk.array(), this.plaintext.arrayOffset() - n2);
            }
            this.chunk.position(this.plaintext.arrayOffset());
        }
        catch (ServiceResultException serviceResultException) {
            throw new RuntimeServiceResultException(serviceResultException);
        }
    }

    private int getPaddingSize(int n) {
        int n2 = this.chunk.limit() - 1;
        if (logger.isTraceEnabled()) {
            logger.trace("getPaddingSize: chunk={}", (Object)CryptoUtil.toHex(this.chunk.array(), 64));
            logger.trace("getPaddingSize: plaintext={}", (Object)CryptoUtil.toHex(this.plaintext.array(), 64));
            logger.trace("getPaddingSize: plaintext.arrayOffset()={}", (Object)this.plaintext.arrayOffset());
            logger.trace("getPaddingSize: plaintext.limit()={}", (Object)this.plaintext.limit());
            logger.trace("getPaddingSize: lastPaddingBytePosition={}", (Object)n2);
        }
        if (n > 2048) {
            int n3 = this.chunk.get(n2) & 0xFF;
            int n4 = this.chunk.get(n2 - 1) & 0xFF;
            logger.trace("getPaddingSize: paddingByte={}", (Object)n4);
            logger.trace("getPaddingSize: extraPaddingByte={}", (Object)n3);
            logger.trace("getPaddingSize: padding={}", (Object)(n4 | n3 << 8));
            return (n4 & 0xFF | (n3 & 0xFF) << 8) + 2;
        }
        int n5 = this.chunk.get(n2) & 0xFF;
        return (n5 & 0xFF) + 1;
    }

    private void encrypt(byte[] byArray, PublicKey publicKey, byte[] byArray2, int n) throws ServiceResultException {
        SecurityPolicy securityPolicy = this.profile.getSecurityPolicy();
        logger.debug("rsa_Encrypt: policy={}", (Object)securityPolicy);
        int n2 = 1;
        PublicKey publicKey2 = this.profile.getRemoteCertificate().getPublicKey();
        n2 = CryptoUtil.getPlainTextBlockSize(securityPolicy.getAsymmetricEncryptionAlgorithm(), publicKey2);
        logger.debug("encrypt: inputBlockSize={}", (Object)n2);
        if (byArray.length % n2 != 0) {
            logger.error("Wrong block size in asym encryption: length={} inputBlockSize={}", (Object)byArray.length, (Object)n2);
            throw new ServiceResultException(StatusCodes.Bad_InternalError, "Error in asymmetric encrypt: Input data is not an even number of encryption blocks.");
        }
        CryptoProvider cryptoProvider = CryptoUtil.getCryptoProvider();
        cryptoProvider.encryptAsymm(publicKey, this.profile.getSecurityPolicy().getAsymmetricEncryptionAlgorithm(), byArray, byArray2, n);
        if (logger.isTraceEnabled()) {
            logger.trace("encrypt: dataToEncrypt={}", (Object)CryptoUtil.toHex(byArray, 64));
            logger.trace("encrypt: output={}", (Object)CryptoUtil.toHex(byArray2, 64));
        }
    }

    private byte[] sign(byte[] byArray, RSAPrivateKey rSAPrivateKey) throws ServiceResultException {
        SecurityPolicy securityPolicy = this.profile.getSecurityPolicy();
        if (securityPolicy == SecurityPolicy.NONE) {
            return null;
        }
        byte[] byArray2 = CryptoUtil.getCryptoProvider().signAsymm(rSAPrivateKey, this.profile.getSecurityPolicy().getAsymmetricSignatureAlgorithm(), byArray);
        if (logger.isTraceEnabled()) {
            logger.trace("sign: dataToSign={}", (Object)CryptoUtil.toHex(byArray, 64));
            logger.trace("sign: signature={}", (Object)CryptoUtil.toHex(byArray2, 64));
        }
        return byArray2;
    }
}

