/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.security;

import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.transport.security.Cert;
import org.opcfoundation.ua.transport.security.SecurityAlgorithm;
import org.opcfoundation.ua.utils.ObjectUtils;

public final class SecurityPolicy {
    private static final Charset UTF8 = Charset.forName("utf-8");
    public static final String URI_BINARY_NONE = "http://opcfoundation.org/UA/SecurityPolicy#None";
    public static final String URI_BINARY_BASIC128RSA15 = "http://opcfoundation.org/UA/SecurityPolicy#Basic128Rsa15";
    public static final String URI_BINARY_BASIC256 = "http://opcfoundation.org/UA/SecurityPolicy#Basic256";
    public static final String URI_BINARY_BASIC256SHA256 = "http://opcfoundation.org/UA/SecurityPolicy#Basic256Sha256";
    public static final String URI_XML_NONE = "http://opcfoundation.org/UA-Profile/Securitypolicy/None";
    public static final String URI_XML_BASIC128RSA15 = "http://opcfoundation.org/UA-Profile/Securitypolicy/Basic128Rsa15";
    public static final String URI_XML_BASIC256 = "http://opcfoundation.org/UA-Profile/Securitypolicy/Basic256";
    public static final SecurityPolicy NONE = new SecurityPolicy("http://opcfoundation.org/UA/SecurityPolicy#None", null, null, null, null, null, null, 0, 0, 0, 1, 1024, 2048);
    public static final SecurityPolicy BASIC128RSA15 = new SecurityPolicy("http://opcfoundation.org/UA/SecurityPolicy#Basic128Rsa15", SecurityAlgorithm.HmacSha1, SecurityAlgorithm.Aes128, SecurityAlgorithm.RsaSha1, SecurityAlgorithm.KwRsa15, SecurityAlgorithm.Rsa15, SecurityAlgorithm.PSha1, 20, 16, 16, 16, 1024, 2048);
    public static final SecurityPolicy BASIC256 = new SecurityPolicy("http://opcfoundation.org/UA/SecurityPolicy#Basic256", SecurityAlgorithm.HmacSha1, SecurityAlgorithm.Aes256, SecurityAlgorithm.RsaSha1, SecurityAlgorithm.KwRsaOaep, SecurityAlgorithm.RsaOaep, SecurityAlgorithm.PSha1, 20, 24, 32, 16, 1024, 2048);
    public static final SecurityPolicy BASIC256SHA256 = new SecurityPolicy("http://opcfoundation.org/UA/SecurityPolicy#Basic256Sha256", SecurityAlgorithm.HmacSha256, SecurityAlgorithm.Aes256, SecurityAlgorithm.RsaSha256, SecurityAlgorithm.KwRsaOaep, SecurityAlgorithm.RsaOaep, SecurityAlgorithm.PSha256, 32, 32, 32, 16, 2048, 4096);
    private static Map<String, SecurityPolicy> policies = new ConcurrentHashMap<String, SecurityPolicy>();
    private final SecurityAlgorithm asymmetricEncryptionAlgorithm;
    private final SecurityAlgorithm asymmetricKeyWrapAlgorithm;
    private final SecurityAlgorithm asymmetricSignatureAlgorithm;
    private final byte[] encodedPolicyUri;
    private final int encryptionBlockSize;
    private final int encryptionKeySize;
    private final SecurityAlgorithm keyDerivationAlgorithm;
    private final int maxAsymmetricKeyLength;
    private final int minAsymmetricKeyLength;
    private final String policyUri;
    private final int signatureKeySize;
    private final SecurityAlgorithm symmetricEncryptionAlgorithm;
    private final SecurityAlgorithm symmetricSignatureAlgorithm;
    private final int symmetricSignatureSize;

    public static void addSecurityPolicy(SecurityPolicy securityPolicy) {
        policies.put(securityPolicy.policyUri, securityPolicy);
    }

    public static SecurityPolicy[] getAllSecurityPolicies() {
        return policies.values().toArray(new SecurityPolicy[policies.size()]);
    }

    public static SecurityPolicy getSecurityPolicy(String string) throws ServiceResultException {
        if (string == null) {
            return NONE;
        }
        SecurityPolicy securityPolicy = policies.get(string);
        if (securityPolicy == null) {
            throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected);
        }
        return securityPolicy;
    }

    SecurityPolicy(String string, SecurityAlgorithm securityAlgorithm, SecurityAlgorithm securityAlgorithm2, SecurityAlgorithm securityAlgorithm3, SecurityAlgorithm securityAlgorithm4, SecurityAlgorithm securityAlgorithm5, SecurityAlgorithm securityAlgorithm6, int n, int n2, int n3, int n4, int n5, int n6) {
        this.asymmetricEncryptionAlgorithm = securityAlgorithm5;
        this.asymmetricKeyWrapAlgorithm = securityAlgorithm4;
        this.asymmetricSignatureAlgorithm = securityAlgorithm3;
        this.keyDerivationAlgorithm = securityAlgorithm6;
        this.policyUri = string;
        this.symmetricEncryptionAlgorithm = securityAlgorithm2;
        this.symmetricSignatureAlgorithm = securityAlgorithm;
        this.encodedPolicyUri = string.getBytes(UTF8);
        this.symmetricSignatureSize = n;
        this.signatureKeySize = n2;
        this.encryptionKeySize = n3;
        this.encryptionBlockSize = n4;
        this.minAsymmetricKeyLength = n5;
        this.maxAsymmetricKeyLength = n6;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SecurityPolicy)) {
            return false;
        }
        SecurityPolicy securityPolicy = (SecurityPolicy)object;
        if (!ObjectUtils.objectEquals(this.policyUri, securityPolicy.policyUri)) {
            return false;
        }
        if (!ObjectUtils.objectEquals((Object)this.asymmetricEncryptionAlgorithm, (Object)securityPolicy.asymmetricEncryptionAlgorithm)) {
            return false;
        }
        if (!ObjectUtils.objectEquals((Object)this.asymmetricKeyWrapAlgorithm, (Object)securityPolicy.asymmetricKeyWrapAlgorithm)) {
            return false;
        }
        if (!ObjectUtils.objectEquals((Object)this.asymmetricSignatureAlgorithm, (Object)securityPolicy.asymmetricSignatureAlgorithm)) {
            return false;
        }
        if (!ObjectUtils.objectEquals((Object)this.keyDerivationAlgorithm, (Object)securityPolicy.keyDerivationAlgorithm)) {
            return false;
        }
        if (!ObjectUtils.objectEquals((Object)this.symmetricEncryptionAlgorithm, (Object)securityPolicy.symmetricEncryptionAlgorithm)) {
            return false;
        }
        return ObjectUtils.objectEquals((Object)this.symmetricSignatureAlgorithm, (Object)securityPolicy.symmetricSignatureAlgorithm);
    }

    public SecurityAlgorithm getAsymmetricEncryptionAlgorithm() {
        return this.asymmetricEncryptionAlgorithm;
    }

    public SecurityAlgorithm getAsymmetricKeyWrapAlgorithm() {
        return this.asymmetricKeyWrapAlgorithm;
    }

    public SecurityAlgorithm getAsymmetricSignatureAlgorithm() {
        return this.asymmetricSignatureAlgorithm;
    }

    public byte[] getEncodedPolicyUri() {
        return this.encodedPolicyUri;
    }

    public int getEncryptionBlockSize() {
        return this.encryptionBlockSize;
    }

    public int getEncryptionKeySize() {
        return this.encryptionKeySize;
    }

    public SecurityAlgorithm getKeyDerivationAlgorithm() {
        return this.keyDerivationAlgorithm;
    }

    public int getMaxAsymmetricKeyLength() {
        return this.maxAsymmetricKeyLength;
    }

    public int getMinAsymmetricKeyLength() {
        return this.minAsymmetricKeyLength;
    }

    public String getPolicyUri() {
        return this.policyUri;
    }

    public int getSignatureKeySize() {
        return this.signatureKeySize;
    }

    public SecurityAlgorithm getSymmetricEncryptionAlgorithm() {
        return this.symmetricEncryptionAlgorithm;
    }

    public SecurityAlgorithm getSymmetricSignatureAlgorithm() {
        return this.symmetricSignatureAlgorithm;
    }

    public int getSymmetricSignatureSize() {
        return this.symmetricSignatureSize;
    }

    public int hashCode() {
        return this.policyUri.hashCode();
    }

    public boolean isUsableWith(Cert cert) {
        int n = cert.getKeySize();
        return n >= this.minAsymmetricKeyLength && n <= this.maxAsymmetricKeyLength;
    }

    public String toString() {
        return this.policyUri;
    }

    static {
        SecurityPolicy.addSecurityPolicy(NONE);
        SecurityPolicy.addSecurityPolicy(BASIC128RSA15);
        SecurityPolicy.addSecurityPolicy(BASIC256);
        SecurityPolicy.addSecurityPolicy(BASIC256SHA256);
    }
}

