/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.security;

import org.opcfoundation.ua.core.MessageSecurityMode;
import org.opcfoundation.ua.transport.security.SecurityPolicy;

public final class SecurityMode {
    public static final SecurityMode BASIC128RSA15_SIGN_ENCRYPT = new SecurityMode(SecurityPolicy.BASIC128RSA15, MessageSecurityMode.SignAndEncrypt);
    public static final SecurityMode BASIC128RSA15_SIGN = new SecurityMode(SecurityPolicy.BASIC128RSA15, MessageSecurityMode.Sign);
    public static final SecurityMode BASIC256_SIGN_ENCRYPT = new SecurityMode(SecurityPolicy.BASIC256, MessageSecurityMode.SignAndEncrypt);
    public static final SecurityMode BASIC256_SIGN = new SecurityMode(SecurityPolicy.BASIC256, MessageSecurityMode.Sign);
    public static final SecurityMode BASIC256SHA256_SIGN_ENCRYPT = new SecurityMode(SecurityPolicy.BASIC256SHA256, MessageSecurityMode.SignAndEncrypt);
    public static final SecurityMode BASIC256SHA256_SIGN = new SecurityMode(SecurityPolicy.BASIC256SHA256, MessageSecurityMode.Sign);
    public static final SecurityMode NONE = new SecurityMode(SecurityPolicy.NONE, MessageSecurityMode.None);
    public static final SecurityMode[] ALL_102 = new SecurityMode[]{NONE, BASIC128RSA15_SIGN, BASIC128RSA15_SIGN_ENCRYPT, BASIC256_SIGN, BASIC256_SIGN_ENCRYPT, BASIC256SHA256_SIGN, BASIC256SHA256_SIGN_ENCRYPT};
    public static final SecurityMode[] ALL_101 = new SecurityMode[]{NONE, BASIC128RSA15_SIGN, BASIC128RSA15_SIGN_ENCRYPT, BASIC256_SIGN, BASIC256_SIGN_ENCRYPT};
    public static final SecurityMode[] ALL = ALL_101;
    public static final SecurityMode[] SECURE_102 = new SecurityMode[]{BASIC128RSA15_SIGN, BASIC128RSA15_SIGN_ENCRYPT, BASIC256_SIGN, BASIC256_SIGN_ENCRYPT, BASIC256SHA256_SIGN, BASIC256SHA256_SIGN_ENCRYPT};
    public static final SecurityMode[] SECURE_101 = new SecurityMode[]{BASIC128RSA15_SIGN, BASIC128RSA15_SIGN_ENCRYPT, BASIC256_SIGN, BASIC256_SIGN_ENCRYPT};
    public static final SecurityMode[] SECURE = SECURE_101;
    public static final SecurityMode[] NON_SECURE = new SecurityMode[]{NONE};
    private final SecurityPolicy securityPolicy;
    private final MessageSecurityMode messageSecurityMode;

    public static SecurityMode[] create(SecurityPolicy[] securityPolicyArray, MessageSecurityMode[] messageSecurityModeArray) {
        SecurityMode[] securityModeArray = new SecurityMode[securityPolicyArray.length * messageSecurityModeArray.length];
        for (int i = 0; i < securityPolicyArray.length; ++i) {
            for (int j = 0; j < messageSecurityModeArray.length; ++j) {
                int n = i * messageSecurityModeArray.length + j;
                securityModeArray[n] = new SecurityMode(securityPolicyArray[i], messageSecurityModeArray[j]);
            }
        }
        return securityModeArray;
    }

    public SecurityMode(SecurityPolicy securityPolicy, MessageSecurityMode messageSecurityMode) {
        if (securityPolicy == null || messageSecurityMode == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.securityPolicy = securityPolicy;
        this.messageSecurityMode = messageSecurityMode;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.securityPolicy;
    }

    public MessageSecurityMode getMessageSecurityMode() {
        return this.messageSecurityMode;
    }

    public int hashCode() {
        return this.securityPolicy.hashCode() ^ this.messageSecurityMode.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SecurityMode)) {
            return false;
        }
        SecurityMode securityMode = (SecurityMode)object;
        return securityMode.securityPolicy == this.securityPolicy && securityMode.messageSecurityMode == this.messageSecurityMode;
    }

    public String toString() {
        return "[" + this.securityPolicy.getPolicyUri() + "," + this.messageSecurityMode + "]";
    }

    public static SecurityMode[] join(SecurityMode[] securityModeArray, SecurityMode[] securityModeArray2) {
        int n;
        SecurityMode[] securityModeArray3 = new SecurityMode[securityModeArray.length + securityModeArray2.length];
        for (n = 0; n < securityModeArray.length; ++n) {
            securityModeArray3[n] = securityModeArray[n];
        }
        for (n = 0; n < securityModeArray2.length; ++n) {
            securityModeArray3[n + securityModeArray.length] = securityModeArray2[n];
        }
        return securityModeArray3;
    }
}

