/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opcfoundation.ua.transport.ConnectionMonitor;
import org.opcfoundation.ua.transport.ServerConnection;

public class ConnectionCollection
implements ConnectionMonitor {
    Set<ServerConnection> connections = new HashSet<ServerConnection>();
    CopyOnWriteArrayList<ConnectionMonitor.ConnectListener> listeners = new CopyOnWriteArrayList();
    Object sender;

    public void addConnection(ServerConnection serverConnection) {
        if (!this.connections.add(serverConnection)) {
            return;
        }
        for (ConnectionMonitor.ConnectListener connectListener : this.listeners) {
            connectListener.onConnect(this.sender, serverConnection);
        }
    }

    public void removeConnection(ServerConnection serverConnection) {
        this.connections.remove(serverConnection);
        for (ConnectionMonitor.ConnectListener connectListener : this.listeners) {
            connectListener.onClose(this.sender, serverConnection);
        }
    }

    public Iterator<ConnectionMonitor.ConnectListener> getConnectionListeners() {
        return this.listeners.iterator();
    }

    public ConnectionCollection(Object object) {
        this.sender = object;
    }

    @Override
    public void addConnectionListener(ConnectionMonitor.ConnectListener connectListener) {
        this.listeners.add(connectListener);
    }

    @Override
    public void removeConnectionListener(ConnectionMonitor.ConnectListener connectListener) {
        this.listeners.remove(connectListener);
    }

    @Override
    public synchronized void getConnections(Collection<ServerConnection> collection) {
        collection.addAll(this.connections);
    }
}

