/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.https;

import java.util.HashMap;
import java.util.concurrent.Executor;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.builtintypes.ServiceResponse;
import org.opcfoundation.ua.common.ServiceFaultException;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.EndpointConfiguration;
import org.opcfoundation.ua.core.EndpointDescription;
import org.opcfoundation.ua.core.MessageSecurityMode;
import org.opcfoundation.ua.core.ResponseHeader;
import org.opcfoundation.ua.core.ServiceFault;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.transport.AsyncResult;
import org.opcfoundation.ua.transport.SecureChannel;
import org.opcfoundation.ua.transport.ServerConnection;
import org.opcfoundation.ua.transport.TransportChannelSettings;
import org.opcfoundation.ua.transport.https.HttpsClient;
import org.opcfoundation.ua.transport.https.HttpsClientPendingRequest;
import org.opcfoundation.ua.transport.impl.AsyncResultImpl;
import org.opcfoundation.ua.transport.security.SecurityPolicy;
import org.opcfoundation.ua.utils.StackUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsClientSecureChannel
implements SecureChannel {
    static Logger logger = LoggerFactory.getLogger(HttpsClientSecureChannel.class);
    private EncoderContext ctx;
    int secureChannelId = -1;
    HttpsClient client;
    Executor executor = StackUtils.getBlockingWorkExecutor();

    public HttpsClientSecureChannel(HttpsClient httpsClient) {
        this.client = httpsClient;
    }

    @Override
    public void initialize(String string, TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        this.ctx = encoderContext;
        this.client.initialize(string, transportChannelSettings, encoderContext);
    }

    @Override
    public void initialize(TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        this.ctx = encoderContext;
        this.client.initialize(transportChannelSettings.getDescription().getEndpointUrl(), transportChannelSettings, encoderContext);
    }

    @Override
    public void open() throws ServiceResultException {
        logger.debug("open");
        if (this.secureChannelId == -1) {
            this.secureChannelId = this.client.secureChannelIdCounter.incrementAndGet();
        }
    }

    @Override
    public AsyncResult<SecureChannel> openAsync() {
        final AsyncResultImpl<SecureChannel> asyncResultImpl = new AsyncResultImpl<SecureChannel>();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    HttpsClientSecureChannel.this.open();
                    asyncResultImpl.setResult(HttpsClientSecureChannel.this);
                }
                catch (ServiceResultException serviceResultException) {
                    asyncResultImpl.setError(serviceResultException);
                }
            }
        });
        return asyncResultImpl;
    }

    @Override
    public ServiceResponse serviceRequest(ServiceRequest serviceRequest) throws ServiceResultException {
        AsyncResult<ServiceResponse> asyncResult = this.client.serviceRequestAsync(serviceRequest, this.client.getTimeout(serviceRequest), this.secureChannelId);
        ServiceResponse serviceResponse = asyncResult.waitForResult();
        if (serviceResponse instanceof ServiceFault) {
            throw new ServiceFaultException((ServiceFault)((Object)serviceResponse));
        }
        ServiceResponse serviceResponse2 = serviceResponse;
        logger.trace("Response: {}", (Object)serviceResponse2);
        logger.debug("Response: {}", (Object)serviceResponse2.getClass().getSimpleName());
        ResponseHeader responseHeader = serviceResponse2.getResponseHeader();
        if (responseHeader.getServiceResult().isBad()) {
            logger.debug("BAD response: {}", (Object)responseHeader.getServiceResult());
            throw new ServiceFaultException(new ServiceFault(responseHeader));
        }
        return serviceResponse2;
    }

    @Override
    public AsyncResult<ServiceResponse> serviceRequestAsync(ServiceRequest serviceRequest) {
        return this.client.serviceRequestAsync(serviceRequest, this.client.getTimeout(serviceRequest), this.secureChannelId);
    }

    @Override
    public int getSecureChannelId() {
        return this.secureChannelId;
    }

    @Override
    public ServerConnection getConnection() {
        return null;
    }

    @Override
    public MessageSecurityMode getMessageSecurityMode() {
        return this.client.transportChannelSettings.getDescription().getSecurityMode();
    }

    @Override
    public SecurityPolicy getSecurityPolicy() {
        try {
            return SecurityPolicy.getSecurityPolicy(this.getEndpointDescription().getSecurityPolicyUri());
        }
        catch (ServiceResultException serviceResultException) {
            return null;
        }
    }

    @Override
    public String getConnectURL() {
        return this.client.connectUrl;
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public void close() {
        if (this.secureChannelId == -1) {
            return;
        }
        int n = this.secureChannelId;
        this.secureChannelId = -1;
        HashMap<Integer, HttpsClientPendingRequest> hashMap = new HashMap<Integer, HttpsClientPendingRequest>(this.client.requests);
        for (HttpsClientPendingRequest httpsClientPendingRequest : hashMap.values()) {
            if (httpsClientPendingRequest.secureChannelId != n) continue;
            httpsClientPendingRequest.cancel();
        }
    }

    @Override
    public AsyncResult<SecureChannel> closeAsync() {
        final AsyncResultImpl<SecureChannel> asyncResultImpl = new AsyncResultImpl<SecureChannel>();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                HttpsClientSecureChannel.this.close();
                asyncResultImpl.setResult(HttpsClientSecureChannel.this);
            }
        });
        return asyncResultImpl;
    }

    @Override
    public void dispose() {
        this.close();
        this.executor = null;
        this.client = null;
    }

    @Override
    public EndpointDescription getEndpointDescription() {
        return this.client.transportChannelSettings.getDescription();
    }

    @Override
    public EndpointConfiguration getEndpointConfiguration() {
        return this.client.transportChannelSettings.getConfiguration();
    }

    @Override
    public EncoderContext getMessageContext() {
        return this.ctx;
    }

    @Override
    public void setOperationTimeout(int n) {
        EndpointConfiguration endpointConfiguration = this.client.transportChannelSettings.getConfiguration();
        if (endpointConfiguration == null) {
            endpointConfiguration = new EndpointConfiguration();
            this.client.transportChannelSettings.setConfiguration(endpointConfiguration);
        }
        endpointConfiguration.setOperationTimeout(n);
    }

    @Override
    public int getOperationTimeout() {
        Integer n = this.client.transportChannelSettings.getConfiguration().getOperationTimeout();
        return n == null ? 0 : n;
    }
}

