/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.endpoint;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opcfoundation.ua.application.Server;
import org.opcfoundation.ua.transport.Endpoint;
import org.opcfoundation.ua.transport.EndpointBinding;
import org.opcfoundation.ua.transport.EndpointServer;
import org.opcfoundation.ua.utils.EndpointUtil;

public class EndpointBindingCollection {
    List<EndpointBinding> bindings;
    CopyOnWriteArrayList<EndpointBindingListener> listeners = new CopyOnWriteArrayList();

    public EndpointBindingCollection() {
        this.bindings = new CopyOnWriteArrayList<EndpointBinding>();
    }

    public EndpointBindingCollection(List<EndpointBinding> list) {
        this.bindings = Collections.synchronizedList(list);
    }

    public void add(EndpointBinding endpointBinding) {
        if (this.bindings.contains(endpointBinding)) {
            return;
        }
        this.bindings.add(endpointBinding);
    }

    public void remove(EndpointBinding endpointBinding) {
        this.bindings.remove(endpointBinding);
    }

    public boolean contains(EndpointBinding endpointBinding) {
        return this.bindings.contains(endpointBinding);
    }

    public boolean isEmpty() {
        return this.bindings.isEmpty();
    }

    public int size() {
        return this.bindings.size();
    }

    public EndpointBinding getDefault(String string) {
        if (string == null) {
            throw new NullPointerException("url must be defined");
        }
        try {
            URI uRI = new URI(string);
            for (EndpointBinding endpointBinding : this.bindings) {
                try {
                    URI uRI2 = new URI(endpointBinding.endpointAddress.getEndpointUrl());
                    if (!EndpointUtil.urlEqualsHostIgnoreCase(uRI2, uRI)) continue;
                    return endpointBinding;
                }
                catch (URISyntaxException uRISyntaxException) {
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    public List<EndpointBinding> getAll() {
        return this.bindings;
    }

    public List<EndpointBinding> get(Endpoint endpoint) {
        ArrayList<EndpointBinding> arrayList = new ArrayList<EndpointBinding>();
        for (EndpointBinding endpointBinding : this.bindings) {
            if (!endpointBinding.endpointAddress.equals(endpoint)) continue;
            arrayList.add(endpointBinding);
        }
        return arrayList;
    }

    public List<EndpointBinding> get(String string) {
        ArrayList<EndpointBinding> arrayList = new ArrayList<EndpointBinding>();
        for (EndpointBinding endpointBinding : this.bindings) {
            if (!endpointBinding.endpointAddress.getEndpointUrl().equals(string)) continue;
            arrayList.add(endpointBinding);
        }
        return arrayList;
    }

    public List<EndpointBinding> get(EndpointServer endpointServer) {
        ArrayList<EndpointBinding> arrayList = new ArrayList<EndpointBinding>();
        for (EndpointBinding endpointBinding : this.bindings) {
            if (!endpointBinding.endpointServer.equals(endpointServer)) continue;
            arrayList.add(endpointBinding);
        }
        return arrayList;
    }

    public List<EndpointBinding> get(Server server) {
        ArrayList<EndpointBinding> arrayList = new ArrayList<EndpointBinding>();
        for (EndpointBinding endpointBinding : this.bindings) {
            if (!endpointBinding.serviceServer.equals(server)) continue;
            arrayList.add(endpointBinding);
        }
        return arrayList;
    }

    public List<EndpointBinding> get(EndpointServer endpointServer, Endpoint endpoint) {
        ArrayList<EndpointBinding> arrayList = new ArrayList<EndpointBinding>();
        for (EndpointBinding endpointBinding : this.bindings) {
            if (!endpointBinding.endpointAddress.equals(endpoint) || !endpointBinding.endpointServer.equals(endpointServer)) continue;
            arrayList.add(endpointBinding);
        }
        return arrayList;
    }

    public EndpointBinding getSingle(EndpointServer endpointServer, Endpoint endpoint) {
        for (EndpointBinding endpointBinding : this.bindings) {
            if (!endpointBinding.endpointAddress.equals(endpoint) || !endpointBinding.endpointServer.equals(endpointServer)) continue;
            return endpointBinding;
        }
        return null;
    }

    public List<EndpointBinding> get(Endpoint endpoint, Server server) {
        ArrayList<EndpointBinding> arrayList = new ArrayList<EndpointBinding>();
        for (EndpointBinding endpointBinding : this.bindings) {
            if (!endpointBinding.endpointAddress.equals(endpoint) || !endpointBinding.serviceServer.equals(server)) continue;
            arrayList.add(endpointBinding);
        }
        return arrayList;
    }

    public List<EndpointBinding> get(EndpointServer endpointServer, Server server) {
        ArrayList<EndpointBinding> arrayList = new ArrayList<EndpointBinding>();
        for (EndpointBinding endpointBinding : this.bindings) {
            if (!endpointBinding.endpointServer.equals(endpointServer) || !endpointBinding.serviceServer.equals(server)) continue;
            arrayList.add(endpointBinding);
        }
        return arrayList;
    }

    public List<Endpoint> getEndpointAddresses() {
        return EndpointBindingCollection.getEndpointAddresses(this.bindings);
    }

    public List<Server> getServiceServers() {
        return EndpointBindingCollection.getServiceServers(this.bindings);
    }

    public List<EndpointServer> getEndpointServers() {
        return EndpointBindingCollection.getEndpointServers(this.bindings);
    }

    public static List<Server> getServiceServers(List<EndpointBinding> list) {
        ArrayList<Server> arrayList = new ArrayList<Server>();
        for (EndpointBinding endpointBinding : list) {
            if (arrayList.contains(endpointBinding.serviceServer)) continue;
            arrayList.add(endpointBinding.serviceServer);
        }
        return arrayList;
    }

    public static List<EndpointServer> getEndpointServers(List<EndpointBinding> list) {
        ArrayList<EndpointServer> arrayList = new ArrayList<EndpointServer>();
        for (EndpointBinding endpointBinding : list) {
            if (arrayList.contains(endpointBinding.endpointServer)) continue;
            arrayList.add(endpointBinding.endpointServer);
        }
        return arrayList;
    }

    public static List<Endpoint> getEndpointAddresses(List<EndpointBinding> list) {
        ArrayList<Endpoint> arrayList = new ArrayList<Endpoint>();
        for (EndpointBinding endpointBinding : list) {
            if (arrayList.contains(endpointBinding.endpointAddress)) continue;
            arrayList.add(endpointBinding.endpointAddress);
        }
        return arrayList;
    }

    public void clear() {
        this.bindings.clear();
    }

    public void addListener(EndpointBindingListener endpointBindingListener) {
        this.listeners.add(endpointBindingListener);
    }

    public void removeListener(EndpointBindingListener endpointBindingListener) {
        this.listeners.remove(endpointBindingListener);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (EndpointBinding endpointBinding : this.bindings) {
            stringBuilder.append(endpointBinding.toString());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static interface EndpointBindingListener {
        public void onAddingEndpoint(EndpointBinding var1);
    }
}

