/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opcfoundation.ua.transport.EndpointBinding;
import org.opcfoundation.ua.transport.EndpointServer;

public class EndpointServerCollection {
    List<EndpointServer> servers = Collections.synchronizedList(new ArrayList());

    public void add(EndpointServer endpointServer) {
        this.servers.add(endpointServer);
    }

    public void remove(EndpointServer endpointServer) {
        this.servers.remove(endpointServer);
    }

    public List<EndpointServer> getList() {
        return new ArrayList<EndpointServer>(this.servers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EndpointBinding> getEndpointBindings() {
        ArrayList<EndpointBinding> arrayList = new ArrayList<EndpointBinding>();
        List<EndpointServer> list = this.servers;
        synchronized (list) {
            for (EndpointServer endpointServer : this.servers) {
                arrayList.addAll(endpointServer.getEndpointBindings().getAll());
            }
        }
        return arrayList;
    }

    public void closeAll() {
        for (EndpointServer endpointServer : this.getList()) {
            endpointServer.close();
        }
    }

    public EndpointServer getEndpointServer(SocketAddress socketAddress) {
        for (EndpointServer endpointServer : this.servers) {
            for (SocketAddress socketAddress2 : endpointServer.getBoundSocketAddresses()) {
                if (!socketAddress2.equals(socketAddress)) continue;
                return endpointServer;
            }
        }
        return null;
    }
}

