/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.encoding.xml;

import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.Enumeration;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ExtensionObject;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedLong;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.builtintypes.XmlElement;
import org.opcfoundation.ua.common.NamespaceTable;
import org.opcfoundation.ua.common.ServerTable;
import org.opcfoundation.ua.common.UriTable;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.encoding.DecodingException;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.encoding.IDecoder;
import org.opcfoundation.ua.encoding.IEncodeable;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.opcfoundation.ua.utils.XMLFactoryCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlDecoder
implements IDecoder {
    private static final String XML_SCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String EMPTY_STRING = "";
    private static final String OPC_UA_XSD_NAMESPACE = "http://opcfoundation.org/UA/2008/02/Types.xsd";
    static Logger logger = LoggerFactory.getLogger(XmlDecoder.class);
    private XMLStreamReader reader;
    private NamespaceTable namespaceTable;
    private ServerTable serverTable;
    private EncoderContext encoderContext;
    private UnsignedShort[] namespaceMappings;
    private UnsignedShort[] serverMappings;

    public XmlDecoder(XmlElement xmlElement, EncoderContext encoderContext) throws DecodingException {
        if (encoderContext == null) {
            throw new NullPointerException("context");
        }
        this.initialize();
        try {
            this.reader = XMLFactoryCache.getXMLInputFactory().createXMLStreamReader(new StringReader(xmlElement.toString()));
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DecodingException(xMLStreamException);
        }
        this.encoderContext = encoderContext;
    }

    public XmlDecoder(XMLStreamReader xMLStreamReader, EncoderContext encoderContext) throws DecodingException {
        if (encoderContext == null) {
            throw new NullPointerException("context");
        }
        this.initialize();
        this.reader = xMLStreamReader;
        this.encoderContext = encoderContext;
    }

    public void close() throws DecodingException {
        try {
            this.reader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DecodingException(xMLStreamException);
        }
    }

    public void close(boolean bl) throws DecodingException {
        if (bl && this.reader.getEventType() != 8) {
            this.getEndElement();
        }
        try {
            this.reader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DecodingException(xMLStreamException);
        }
    }

    @Override
    public <T> T get(String string, Class<T> clazz) throws DecodingException {
        return null;
    }

    @Override
    public Object getArrayObject(String string, int n) throws DecodingException {
        switch (n) {
            case 1: {
                return this.getBooleanArray(null);
            }
            case 2: {
                return this.getSByteArray(null);
            }
            case 3: {
                return this.getByteArray(null);
            }
            case 4: {
                return this.getInt16Array(null);
            }
            case 5: {
                return this.getUInt16Array(null);
            }
            case 6: {
                return this.getInt32Array(null);
            }
            case 7: {
                return this.getUInt32Array(null);
            }
            case 8: {
                return this.getInt64Array(null);
            }
            case 9: {
                return this.getUInt64Array(null);
            }
            case 10: {
                return this.getFloatArray(null);
            }
            case 11: {
                return this.getDoubleArray(null);
            }
            case 12: {
                return this.getStringArray(null);
            }
            case 13: {
                return this.getDateTimeArray(null);
            }
            case 14: {
                return this.getGuidArray(null);
            }
            case 15: {
                return this.getByteStringArray(null);
            }
            case 16: {
                return this.getXmlElementArray(null);
            }
            case 17: {
                return this.getNodeIdArray(null);
            }
            case 18: {
                return this.getExpandedNodeIdArray(null);
            }
            case 19: {
                return this.getStatusCodeArray(null);
            }
            case 20: {
                return this.getQualifiedNameArray(null);
            }
            case 21: {
                return this.getLocalizedTextArray(null);
            }
            case 22: {
                return this.getExtensionObjectArray(null);
            }
            case 23: {
                return this.getDataValueArray(null);
            }
            case 24: {
                return this.getVariantArray(null);
            }
            case 25: {
                return this.getDiagnosticInfoArray(null);
            }
        }
        throw new DecodingException("Cannot decode builtin type id " + n);
    }

    @Override
    public Boolean getBoolean(String string) throws DecodingException {
        String string2;
        if (this.beginFieldSafe(string, true) && !this.isNullOrEmpty(string2 = this.getString())) {
            boolean bl = Boolean.parseBoolean(string2.toLowerCase());
            this.endField(string);
            return bl;
        }
        return false;
    }

    @Override
    public Boolean[] getBooleanArray(String string) throws DecodingException {
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("Boolean")) {
                arrayList.add(this.getBoolean("Boolean"));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new Boolean[0]);
    }

    @Override
    public UnsignedByte getByte(String string) throws DecodingException {
        String string2;
        if (this.beginFieldSafe(string, true) && !this.isNullOrEmpty(string2 = this.getString())) {
            UnsignedByte unsignedByte = UnsignedByte.parseUnsignedByte(string2);
            this.endField(string);
            return unsignedByte;
        }
        return UnsignedByte.ZERO;
    }

    @Override
    public UnsignedByte[] getByteArray(String string) throws DecodingException {
        ArrayList<UnsignedByte> arrayList = new ArrayList<UnsignedByte>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("Byte")) {
                arrayList.add(this.getByte("Byte"));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new UnsignedByte[0]);
    }

    @Override
    public byte[] getByteString(String string) throws DecodingException {
        if (this.beginFieldSafe(string, true)) {
            byte[] byArray = null;
            String string2 = this.getContentAsString();
            byArray = !this.isNullOrEmpty(string2) ? CryptoUtil.base64Decode(string2) : new byte[]{};
            if (this.encoderContext.getMaxByteStringLength() > 0 && this.encoderContext.getMaxByteStringLength() < byArray.length) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
            return byArray;
        }
        return null;
    }

    @Override
    public byte[][] getByteStringArray(String string) throws DecodingException {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("ByteString")) {
                arrayList.add(this.getByteString("ByteString"));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return (byte[][])arrayList.toArray((T[])new byte[0][]);
    }

    @Override
    public DataValue getDataValue(String string) throws DecodingException {
        DataValue dataValue = new DataValue();
        if (this.beginFieldSafe(string, true)) {
            dataValue.setValue(this.getVariant("Value"));
            dataValue.setStatusCode(this.getStatusCode("StatusCode"));
            dataValue.setSourceTimestamp(this.getDateTime("SourceTimestamp"));
            dataValue.setSourcePicoseconds(this.getUInt16("SourcePicoseconds"));
            dataValue.setServerTimestamp(this.getDateTime("ServerTimestamp"));
            dataValue.setServerPicoseconds(this.getUInt16("ServerPicoseconds"));
            this.endField(string);
        }
        return dataValue;
    }

    @Override
    public DataValue[] getDataValueArray(String string) throws DecodingException {
        ArrayList<DataValue> arrayList = new ArrayList<DataValue>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("DataValue")) {
                arrayList.add(this.getDataValue("DataValue"));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new DataValue[0]);
    }

    @Override
    public DateTime getDateTime(String string) throws DecodingException {
        if (this.beginFieldSafe(string, true)) {
            String string2 = this.getString();
            if (this.encoderContext.getMaxStringLength() > 0 && this.encoderContext.getMaxStringLength() < string2.length()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            if (!this.isNullOrEmpty(string2)) {
                DateTime dateTime;
                try {
                    dateTime = DateTime.parseDateTime(string2);
                }
                catch (ParseException parseException) {
                    throw new DecodingException(parseException);
                }
                this.endField(string);
                return dateTime;
            }
        }
        return DateTime.MIN_VALUE;
    }

    @Override
    public DateTime[] getDateTimeArray(String string) throws DecodingException {
        ArrayList<DateTime> arrayList = new ArrayList<DateTime>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("DateTime")) {
                arrayList.add(this.getDateTime("DateTime"));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new DateTime[0]);
    }

    public DiagnosticInfo getDiagnosticInfo() throws DecodingException {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo();
        if (this.beginFieldSafe("SymbolicId", true)) {
            diagnosticInfo.setSymbolicId(this.getInt32(null));
            this.endField("SymbolicId");
        }
        if (this.beginFieldSafe("NamespaceUri", true)) {
            diagnosticInfo.setNamespaceUri(this.getInt32(null));
            this.endField("NamespaceUri");
        }
        if (this.beginFieldSafe("Locale", true)) {
            diagnosticInfo.setLocale(this.getInt32(null));
            this.endField("Locale");
        }
        if (this.beginFieldSafe("LocalizedText", true)) {
            diagnosticInfo.setLocalizedText(this.getInt32(null));
            this.endField("LocalizedText");
        }
        diagnosticInfo.setAdditionalInfo(this.getString("AdditionalInfo"));
        diagnosticInfo.setInnerStatusCode(this.getStatusCode("InnerStatusCode"));
        if (this.beginFieldSafe("InnerDiagnosticInfo", true)) {
            diagnosticInfo.setInnerDiagnosticInfo(this.getDiagnosticInfo());
            this.endField("InnerDiagnosticInfo");
        }
        return diagnosticInfo;
    }

    @Override
    public DiagnosticInfo getDiagnosticInfo(String string) throws DecodingException {
        DiagnosticInfo diagnosticInfo = null;
        if (this.beginFieldSafe(string, true)) {
            diagnosticInfo = this.getDiagnosticInfo();
            this.endField(string);
            return diagnosticInfo;
        }
        return diagnosticInfo;
    }

    @Override
    public DiagnosticInfo[] getDiagnosticInfoArray(String string) throws DecodingException {
        ArrayList<DiagnosticInfo> arrayList = new ArrayList<DiagnosticInfo>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("DiagnosticInfo")) {
                arrayList.add(this.getDiagnosticInfo("DiagnosticInfo"));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new DiagnosticInfo[0]);
    }

    @Override
    public Double getDouble(String string) throws DecodingException {
        String string2;
        if (this.beginFieldSafe(string, true) && !this.isNullOrEmpty(string2 = this.getString())) {
            double d = 0.0;
            if (string2.length() == 3) {
                if (string2 == "NaN") {
                    d = Double.NaN;
                }
                if (string2 == "INF") {
                    d = Double.POSITIVE_INFINITY;
                }
            }
            if (string2.length() == 4 && string2 == "-INF") {
                d = Double.NEGATIVE_INFINITY;
            }
            if (d == 0.0) {
                d = Double.parseDouble(string2);
            }
            this.endField(string);
            return d;
        }
        return 0.0;
    }

    @Override
    public Double[] getDoubleArray(String string) throws DecodingException {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("Double")) {
                arrayList.add(this.getDouble("Double"));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new Double[0]);
    }

    @Override
    public <T extends IEncodeable> T getEncodeable(String string, Class<? extends T> clazz) throws DecodingException {
        IEncodeable iEncodeable = this.encoderContext.getEncodeableSerializer().getEncodeable(clazz, this);
        this.endField(string);
        return (T)iEncodeable;
    }

    @Override
    public <T extends IEncodeable> T[] getEncodeableArray(String string, Class<? extends T> clazz) throws DecodingException {
        if (clazz == null) {
            throw new IllegalArgumentException("encodeableClass");
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        if (this.beginFieldSafe(string, true)) {
            String string2 = clazz.getName();
            while (this.moveToElement(string2)) {
                arrayList.add(this.getEncodeable(string2, clazz));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new IEncodeable[0]);
    }

    public EncoderContext getEncoderContext() {
        return this.encoderContext;
    }

    public void getEndElement() throws DecodingException {
        this.moveToTag();
        if (this.reader.isEndElement()) {
            try {
                this.reader.next();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new DecodingException(xMLStreamException);
            }
        } else {
            throw new DecodingException("Not an end element");
        }
    }

    @Override
    public <T extends Enumeration> T getEnumeration(String string, Class<T> clazz) throws DecodingException {
        Enumeration enumeration = ((Enumeration[])clazz.getEnumConstants())[0];
        if (this.beginFieldSafe(string, true)) {
            String string2 = this.getString();
            if (!this.isNullOrEmpty(string2)) {
                int n = string2.lastIndexOf(95);
                if (n != -1) {
                    int n2 = Integer.parseInt(string2.substring(n + 1));
                    try {
                        Method method = clazz.getMethod("valueOf", Integer.TYPE);
                        enumeration = (Enumeration)method.invoke(null, n2);
                    }
                    catch (SecurityException securityException) {
                        throw new DecodingException(securityException);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new DecodingException(noSuchMethodException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new DecodingException(illegalArgumentException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new DecodingException(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new DecodingException(invocationTargetException);
                    }
                }
                int n3 = Integer.parseInt(string2);
                try {
                    Method method = clazz.getMethod("valueOf", Integer.TYPE);
                    enumeration = (Enumeration)method.invoke(null, n3);
                }
                catch (SecurityException securityException) {
                    throw new DecodingException(securityException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new DecodingException(noSuchMethodException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new DecodingException(illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new DecodingException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new DecodingException(invocationTargetException);
                }
            }
            this.endField(string);
        }
        return (T)enumeration;
    }

    @Override
    public <T extends Enumeration> T[] getEnumerationArray(String string, Class<T> clazz) throws DecodingException {
        if (clazz == null) {
            throw new IllegalArgumentException("enumerationClass");
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        if (this.beginFieldSafe(string, true)) {
            String string2 = clazz.toString();
            while (this.moveToElement(string2)) {
            }
            arrayList.add(this.getEnumeration(string2, clazz));
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new Enumeration[0]);
    }

    @Override
    public ExpandedNodeId getExpandedNodeId(String string) throws DecodingException {
        ExpandedNodeId expandedNodeId = ExpandedNodeId.NULL;
        if (this.beginFieldSafe(string, true)) {
            expandedNodeId = ExpandedNodeId.parseExpandedNodeId(this.getString("Identifier"));
            this.endField(string);
        }
        int n = expandedNodeId.getNamespaceIndex();
        int n2 = expandedNodeId.getServerIndex().intValue();
        boolean bl = false;
        if (this.namespaceMappings != null && this.namespaceMappings.length > expandedNodeId.getNamespaceIndex()) {
            n = this.namespaceMappings[expandedNodeId.getNamespaceIndex()].intValue();
            bl = true;
        }
        if (this.serverMappings != null && this.serverMappings.length > expandedNodeId.getServerIndex().intValue()) {
            n2 = this.serverMappings[expandedNodeId.getServerIndex().intValue()].intValue();
            bl = true;
        }
        if (bl) {
            expandedNodeId = new ExpandedNodeId(UnsignedInteger.valueOf(n2), n, expandedNodeId.getValue());
        }
        return expandedNodeId;
    }

    @Override
    public ExpandedNodeId[] getExpandedNodeIdArray(String string) throws DecodingException {
        ArrayList<ExpandedNodeId> arrayList = new ArrayList<ExpandedNodeId>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("ExpandedNodeId")) {
                arrayList.add(this.getExpandedNodeId("ExpandedNodeId"));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new ExpandedNodeId[0]);
    }

    @Override
    public ExtensionObject getExtensionObject(String string) throws IllegalArgumentException, DecodingException {
        if (!this.beginFieldSafe(string, true)) {
            return null;
        }
        NodeId nodeId = this.getNodeId("TypeId");
        ExpandedNodeId expandedNodeId = this.encoderContext.getNamespaceTable().toExpandedNodeId(nodeId);
        if (!NodeId.isNull(nodeId) && ExpandedNodeId.isNull(expandedNodeId)) {
            logger.error("Cannot de-serialized extension objects if the NamespaceUri is not in the NamespaceTable: Type = {}", (Object)nodeId);
        }
        if (!this.beginFieldSafe("Body", true)) {
            this.endField(string);
            return new ExtensionObject(expandedNodeId, new XmlElement(EMPTY_STRING));
        }
        Object object = this.getExtensionObjectBody(expandedNodeId);
        this.endField("Body");
        this.endField(string);
        if (object instanceof XmlElement) {
            return new ExtensionObject(expandedNodeId, (XmlElement)object);
        }
        return new ExtensionObject(expandedNodeId, (byte[])object);
    }

    @Override
    public ExtensionObject[] getExtensionObjectArray(String string) throws DecodingException {
        ArrayList<ExtensionObject> arrayList = new ArrayList<ExtensionObject>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("ExtensionObject")) {
                arrayList.add(this.getExtensionObject("ExtensionObject"));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new ExtensionObject[0]);
    }

    public Object getExtensionObjectBody(ExpandedNodeId expandedNodeId) throws DecodingException {
        this.moveToTag();
        if (this.reader.getLocalName() == "ByteString" && this.reader.getNamespaceURI() == OPC_UA_XSD_NAMESPACE) {
            byte[] byArray = this.getByteString("ByteString");
            return byArray;
        }
        return this.getXmlElement(EMPTY_STRING);
    }

    @Override
    public Float getFloat(String string) throws DecodingException {
        String string2;
        if (this.beginFieldSafe(string, true) && !this.isNullOrEmpty(string2 = this.getString())) {
            float f = 0.0f;
            if (string2.length() == 3) {
                if (string2 == "NaN") {
                    f = Float.NaN;
                }
                if (string2 == "INF") {
                    f = Float.POSITIVE_INFINITY;
                }
            }
            if (string2.length() == 4 && string2 == "-INF") {
                f = Float.NEGATIVE_INFINITY;
            }
            if (f == 0.0f) {
                f = Float.parseFloat(string2);
            }
            this.endField(string);
            return Float.valueOf(f);
        }
        return Float.valueOf(0.0f);
    }

    @Override
    public Float[] getFloatArray(String string) throws DecodingException {
        ArrayList<Float> arrayList = new ArrayList<Float>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("Float")) {
                arrayList.add(this.getFloat("Float"));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new Float[0]);
    }

    @Override
    public UUID getGuid(String string) throws DecodingException {
        String string2 = null;
        if (this.beginFieldSafe(string, true)) {
            string2 = this.getString("String");
            this.endField(string);
        }
        return UUID.fromString(string2);
    }

    @Override
    public UUID[] getGuidArray(String string) throws DecodingException {
        ArrayList<UUID> arrayList = new ArrayList<UUID>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("Guid")) {
                arrayList.add(this.getGuid("Guid"));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new UUID[0]);
    }

    @Override
    public Short getInt16(String string) throws DecodingException {
        String string2;
        if (this.beginFieldSafe(string, true) && !this.isNullOrEmpty(string2 = this.getString())) {
            short s = Short.parseShort(string2);
            this.endField(string);
            return s;
        }
        return (short)0;
    }

    @Override
    public Short[] getInt16Array(String string) throws DecodingException {
        ArrayList<Short> arrayList = new ArrayList<Short>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("Int16")) {
                arrayList.add(this.getInt16("Int16"));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new Short[0]);
    }

    @Override
    public Integer getInt32(String string) throws DecodingException {
        String string2;
        if (this.beginFieldSafe(string, true) && !this.isNullOrEmpty(string2 = this.getString())) {
            int n = Integer.parseInt(string2);
            this.endField(string);
            return n;
        }
        return 0;
    }

    @Override
    public Integer[] getInt32Array(String string) throws DecodingException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("Int32")) {
                arrayList.add(this.getInt32("Int32"));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new Integer[0]);
    }

    @Override
    public int[] getInt32Array_(String string) throws DecodingException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("Int32")) {
                arrayList.add(this.getInt32("Int32"));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
            int[] nArray = new int[arrayList.size()];
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                nArray[n] = (Integer)arrayList.get(n);
            }
            return nArray;
        }
        return new int[0];
    }

    @Override
    public Long getInt64(String string) throws DecodingException {
        String string2;
        if (this.beginFieldSafe(string, true) && !this.isNullOrEmpty(string2 = this.getString())) {
            long l = Long.parseLong(string2);
            this.endField(string);
            return l;
        }
        return 0L;
    }

    @Override
    public Long[] getInt64Array(String string) throws DecodingException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("Int64")) {
                arrayList.add(this.getInt64("Int64"));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new Long[0]);
    }

    @Override
    public LocalizedText getLocalizedText(String string) throws DecodingException {
        if (this.beginFieldSafe(string, true)) {
            boolean bl = false;
            String string2 = null;
            String string3 = null;
            if (this.beginFieldSafe("Locale", true)) {
                string3 = this.getString(null);
                this.endField("Locale");
            } else if (!bl) {
                string3 = EMPTY_STRING;
            }
            if (this.beginFieldSafe("Text", true)) {
                string2 = this.getString(null);
                this.endField("Text");
            } else if (!bl) {
                string2 = EMPTY_STRING;
            }
            LocalizedText localizedText = new LocalizedText(string2, string3);
            this.endField(string);
            return localizedText;
        }
        return LocalizedText.NULL;
    }

    @Override
    public LocalizedText[] getLocalizedTextArray(String string) throws DecodingException {
        ArrayList<LocalizedText> arrayList = new ArrayList<LocalizedText>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("LocalizedText")) {
                arrayList.add(this.getLocalizedText("LocalizedText"));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new LocalizedText[0]);
    }

    @Override
    public <T extends IEncodeable> T getMessage() throws DecodingException {
        NodeId nodeId = this.getNodeId(null);
        if (nodeId == null) {
            throw new DecodingException("Cannot decode " + nodeId);
        }
        Class<? extends IEncodeable> clazz = this.encoderContext.getEncodeableClass(nodeId);
        if (clazz == null) {
            throw new DecodingException("Cannot decode " + nodeId);
        }
        return (T)this.encoderContext.getEncodeableSerializer().getEncodeable(clazz, this);
    }

    public NamespaceTable getNamespaceTable() {
        return this.namespaceTable;
    }

    @Override
    public NodeId getNodeId(String string) throws IllegalArgumentException, DecodingException {
        NodeId nodeId = null;
        if (this.beginFieldSafe(string, true)) {
            nodeId = NodeId.parseNodeId(this.getString("Identifier"));
            this.endField(string);
        }
        if (this.namespaceMappings != null && this.namespaceMappings.length > nodeId.getNamespaceIndex()) {
            nodeId = NodeId.get(nodeId.getIdType(), this.namespaceMappings[nodeId.getNamespaceIndex()].intValue(), nodeId.getValue());
        }
        return nodeId;
    }

    @Override
    public NodeId[] getNodeIdArray(String string) throws DecodingException {
        ArrayList<NodeId> arrayList = new ArrayList<NodeId>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("NodeId")) {
                arrayList.add(this.getNodeId("NodeId"));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new NodeId[0]);
    }

    @Override
    public QualifiedName getQualifiedName(String string) throws DecodingException {
        if (this.beginFieldSafe(string, true)) {
            UnsignedShort unsignedShort = UnsignedShort.ZERO;
            if (this.beginFieldSafe("NamespaceIndex", true)) {
                unsignedShort = this.getUInt16(null);
                this.endField("NamespaceIndex");
            }
            String string2 = null;
            if (this.beginFieldSafe("Name", true)) {
                string2 = this.getString(null);
                this.endField("Name");
            }
            this.endField(string);
            if (this.namespaceMappings != null && this.namespaceMappings.length > unsignedShort.getValue()) {
                unsignedShort = this.namespaceMappings[unsignedShort.getValue()];
            }
            return new QualifiedName(unsignedShort, string2);
        }
        return QualifiedName.NULL;
    }

    @Override
    public QualifiedName[] getQualifiedNameArray(String string) throws DecodingException {
        ArrayList<QualifiedName> arrayList = new ArrayList<QualifiedName>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("QualifiedName")) {
                arrayList.add(this.getQualifiedName("QualifiedName"));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new QualifiedName[0]);
    }

    @Override
    public Byte getSByte(String string) throws DecodingException {
        String string2;
        if (this.beginFieldSafe(string, true) && !this.isNullOrEmpty(string2 = this.getString())) {
            byte by = Byte.parseByte(string2);
            this.endField(string);
            return by;
        }
        return (byte)0;
    }

    @Override
    public Byte[] getSByteArray(String string) throws DecodingException {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("SByte")) {
                arrayList.add(this.getSByte("SByte"));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new Byte[0]);
    }

    @Override
    public Object getScalarObject(String string, int n) throws DecodingException {
        switch (n) {
            case 1: {
                return this.getBoolean(null);
            }
            case 2: {
                return this.getSByte(null);
            }
            case 3: {
                return this.getByte(null);
            }
            case 4: {
                return this.getInt16(null);
            }
            case 5: {
                return this.getUInt16(null);
            }
            case 6: {
                return this.getInt32(null);
            }
            case 7: {
                return this.getUInt32(null);
            }
            case 8: {
                return this.getInt64(null);
            }
            case 9: {
                return this.getUInt64(null);
            }
            case 10: {
                return this.getFloat(null);
            }
            case 11: {
                return this.getDouble(null);
            }
            case 12: {
                return this.getString(null);
            }
            case 13: {
                return this.getDateTime(null);
            }
            case 14: {
                return this.getGuid(null);
            }
            case 15: {
                return this.getByteString(null);
            }
            case 16: {
                return this.getXmlElement(null);
            }
            case 17: {
                return this.getNodeId(null);
            }
            case 18: {
                return this.getExpandedNodeId(null);
            }
            case 19: {
                return this.getStatusCode(null);
            }
            case 20: {
                return this.getQualifiedName(null);
            }
            case 21: {
                return this.getLocalizedText(null);
            }
            case 22: {
                return this.getExtensionObject(null);
            }
            case 23: {
                return this.getDataValue(null);
            }
            case 24: {
                return this.getVariant(null);
            }
            case 25: {
                return this.getDiagnosticInfo(null);
            }
        }
        throw new DecodingException("Cannot decode builtin type id " + n);
    }

    public ServerTable getServerTable() {
        return this.serverTable;
    }

    public void getStartElement() throws DecodingException {
        if (this.reader.isStartElement()) {
            try {
                this.reader.next();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new DecodingException(xMLStreamException);
            }
        }
    }

    @Override
    public StatusCode getStatusCode(String string) throws DecodingException {
        StatusCode statusCode = StatusCode.getFromBits(0);
        if (this.beginFieldSafe(string, true)) {
            statusCode = new StatusCode(this.getUInt32("Code"));
            this.endField(string);
        }
        return statusCode;
    }

    @Override
    public StatusCode[] getStatusCodeArray(String string) throws DecodingException {
        ArrayList<StatusCode> arrayList = new ArrayList<StatusCode>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("StatusCode")) {
                arrayList.add(this.getStatusCode("StatusCode"));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new StatusCode[0]);
    }

    @Override
    public String getString(String string) throws DecodingException {
        if (this.beginFieldSafe(string, true)) {
            String string2 = this.getString();
            if (string2 != null) {
                string2 = string2.trim();
            }
            this.endField(string);
            return string2;
        }
        return null;
    }

    @Override
    public String[] getStringArray(String string) throws DecodingException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("String")) {
                arrayList.add(this.getString("String"));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public Structure getStructure(String string) throws DecodingException {
        NodeId nodeId = this.getNodeId(null);
        Class<? extends IEncodeable> clazz = this.encoderContext.getEncodeableClass(nodeId);
        return (Structure)this.getEncodeable(string, clazz);
    }

    @Override
    public Structure[] getStructureArray(String string) throws DecodingException {
        ArrayList<Structure> arrayList = new ArrayList<Structure>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("Structure")) {
                arrayList.add(this.getStructure(null));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new Structure[0]);
    }

    @Override
    public UnsignedShort getUInt16(String string) throws DecodingException {
        String string2;
        if (this.beginFieldSafe(string, true) && !this.isNullOrEmpty(string2 = this.getString())) {
            UnsignedShort unsignedShort = UnsignedShort.parseUnsignedShort(string2);
            this.endField(string);
            return unsignedShort;
        }
        return UnsignedShort.ZERO;
    }

    @Override
    public UnsignedShort[] getUInt16Array(String string) throws DecodingException {
        ArrayList<UnsignedShort> arrayList = new ArrayList<UnsignedShort>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("UInt16")) {
                arrayList.add(this.getUInt16("UInt16"));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new UnsignedShort[0]);
    }

    @Override
    public UnsignedInteger getUInt32(String string) throws DecodingException {
        String string2;
        if (this.beginFieldSafe(string, true) && !this.isNullOrEmpty(string2 = this.getString())) {
            UnsignedInteger unsignedInteger = UnsignedInteger.parseUnsignedInteger(string2);
            this.endField(string);
            return unsignedInteger;
        }
        return UnsignedInteger.ZERO;
    }

    @Override
    public UnsignedInteger[] getUInt32Array(String string) throws DecodingException {
        ArrayList<UnsignedInteger> arrayList = new ArrayList<UnsignedInteger>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("UInt32")) {
                arrayList.add(this.getUInt32("UInt32"));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new UnsignedInteger[0]);
    }

    @Override
    public UnsignedLong getUInt64(String string) throws DecodingException {
        String string2;
        if (this.beginFieldSafe(string, true) && !this.isNullOrEmpty(string2 = this.getString())) {
            UnsignedLong unsignedLong = UnsignedLong.parseUnsignedLong(string2);
            this.endField(string);
            return unsignedLong;
        }
        return UnsignedLong.valueOf(0L);
    }

    @Override
    public UnsignedLong[] getUInt64Array(String string) throws DecodingException {
        ArrayList<UnsignedLong> arrayList = new ArrayList<UnsignedLong>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("UInt64")) {
                arrayList.add(this.getUInt64("UInt64"));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new UnsignedLong[0]);
    }

    @Override
    public Variant getVariant(String string) throws DecodingException {
        Variant variant = new Variant(null);
        if (this.beginFieldSafe(string, true)) {
            if (this.beginFieldSafe("Value", true)) {
                Object object = this.getVariantContents();
                variant = new Variant(object);
                this.endField("Value");
            }
            if (!this.isNullOrEmpty(string)) {
                this.endField(string);
            }
        }
        return variant;
    }

    @Override
    public Variant[] getVariantArray(String string) throws DecodingException {
        ArrayList<Variant> arrayList = new ArrayList<Variant>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("Variant")) {
                arrayList.add(this.getVariant("Variant"));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new Variant[0]);
    }

    public Object getVariantContents() throws DecodingException {
        while (this.reader.getEventType() != 1) {
            try {
                this.reader.next();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new DecodingException(xMLStreamException);
            }
        }
        String string = this.reader.getLocalName();
        if (string.startsWith("ListOf")) {
            String string2 = string.substring("ListOf".length());
            if (string2.equals("Boolean")) {
                return this.getBooleanArray(string);
            }
            if (string2.equals("SByte")) {
                return this.getSByteArray(string);
            }
            if (string2.equals("Byte")) {
                return this.getByteArray(string);
            }
            if (string2.equals("Int16")) {
                return this.getInt16Array(string);
            }
            if (string2.equals("UInt16")) {
                return this.getUInt16Array(string);
            }
            if (string2.equals("Int32")) {
                return this.getInt32Array(string);
            }
            if (string2.equals("UInt32")) {
                return this.getUInt32Array(string);
            }
            if (string2.equals("Int64")) {
                return this.getInt64Array(string);
            }
            if (string2.equals("UInt64")) {
                return this.getUInt64Array(string);
            }
            if (string2.equals("Float")) {
                return this.getFloatArray(string);
            }
            if (string2.equals("Double")) {
                return this.getDoubleArray(string);
            }
            if (string2.equals("String")) {
                return this.getStringArray(string);
            }
            if (string2.equals("DateTime")) {
                return this.getDateTimeArray(string);
            }
            if (string2.equals("Guid")) {
                return this.getGuidArray(string);
            }
            if (string2.equals("ByteString")) {
                return this.getByteStringArray(string);
            }
            if (string2.equals("XmlElement")) {
                return this.getXmlElementArray(string);
            }
            if (string2.equals("NodeId")) {
                return this.getNodeIdArray(string);
            }
            if (string2.equals("ExpandedNodeId")) {
                return this.getExpandedNodeIdArray(string);
            }
            if (string2.equals("StatusCode")) {
                return this.getStatusCodeArray(string);
            }
            if (string2.equals("DiagnosticInfo")) {
                return this.getDiagnosticInfoArray(string);
            }
            if (string2.equals("QualifiedName")) {
                return this.getQualifiedNameArray(string);
            }
            if (string2.equals("LocalizedText")) {
                return this.getLocalizedTextArray(string);
            }
            if (string2.equals("ExtensionObject")) {
                return this.decode(this.getExtensionObjectArray(string));
            }
            if (string2.equals("DataValue")) {
                return this.getDataValueArray(string);
            }
            if (string2.equals("Variant")) {
                return this.getVariantArray(string);
            }
        } else {
            if (string.equals("Null")) {
                if (this.beginFieldSafe(string, true)) {
                    this.endField(string);
                }
                return null;
            }
            if (string.equals("Boolean")) {
                return this.getBoolean(string);
            }
            if (string.equals("SByte")) {
                return this.getSByte(string);
            }
            if (string.equals("Byte")) {
                return this.getByte(string);
            }
            if (string.equals("Int16")) {
                return this.getInt16(string);
            }
            if (string.equals("UInt16")) {
                return this.getUInt16(string);
            }
            if (string.equals("Int32")) {
                return this.getInt32(string);
            }
            if (string.equals("UInt32")) {
                return this.getUInt32(string);
            }
            if (string.equals("Int64")) {
                return this.getInt64(string);
            }
            if (string.equals("UInt64")) {
                return this.getUInt64(string);
            }
            if (string.equals("Float")) {
                return this.getFloat(string);
            }
            if (string.equals("Double")) {
                return this.getDouble(string);
            }
            if (string.equals("String")) {
                return this.getString(string);
            }
            if (string.equals("DateTime")) {
                return this.getDateTime(string);
            }
            if (string.equals("Guid")) {
                return this.getGuid(string);
            }
            if (string.equals("ByteString")) {
                return this.getByteString(string);
            }
            if (string.equals("XmlElement")) {
                return this.getXmlElement(string);
            }
            if (string.equals("NodeId")) {
                return this.getNodeId(string);
            }
            if (string.equals("ExpandedNodeId")) {
                return this.getExpandedNodeId(string);
            }
            if (string.equals("StatusCode")) {
                return this.getStatusCode(string);
            }
            if (string.equals("DiagnosticInfo")) {
                return this.getDiagnosticInfo(string);
            }
            if (string.equals("QualifiedName")) {
                return this.getQualifiedName(string);
            }
            if (string.equals("LocalizedText")) {
                return this.getLocalizedText(string);
            }
            if (string.equals("ExtensionObject")) {
                ExtensionObject extensionObject = this.getExtensionObject(string);
                try {
                    return this.decode(extensionObject);
                }
                catch (DecodingException decodingException) {
                    logger.info("Failed to decode ExtensionObject: " + decodingException.getMessage());
                    return extensionObject;
                }
            }
            if (string.equals("DataValue")) {
                return this.getDataValue(string);
            }
        }
        throw new DecodingException(StatusCodes.Bad_DecodingError, "Element '" + this.reader.getNamespaceURI() + ":" + this.reader.getLocalName() + "' is not allowed in an Variant.");
    }

    @Override
    public XmlElement getXmlElement(String string) throws DecodingException {
        if (this.beginFieldSafe(string, true)) {
            return new XmlElement(this.getInnerXml(EMPTY_STRING));
        }
        return null;
    }

    @Override
    public XmlElement[] getXmlElementArray(String string) throws DecodingException {
        ArrayList<XmlElement> arrayList = new ArrayList<XmlElement>();
        if (this.beginFieldSafe(string, true)) {
            while (this.moveToElement("XmlElement")) {
                arrayList.add(this.getXmlElement("XmlElement"));
            }
            if (this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.endField(string);
        }
        return arrayList.toArray(new XmlElement[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadStringTable(String string, String string2, List<String> list) throws DecodingException {
        block4: {
            if (this.peek(string)) break block4;
            boolean bl = false;
            return bl;
        }
        this.getStartElement();
        while (this.peek(string2)) {
            String string3 = this.getString(string2);
            list.add(string3);
        }
        this.skip(new QName(string, OPC_UA_XSD_NAMESPACE));
        boolean bl = true;
        return bl;
    }

    public QName peek(int n) {
        this.moveToContent();
        if (n != this.reader.getEventType()) {
            return null;
        }
        return new QName(this.reader.getLocalName(), this.reader.getNamespaceURI());
    }

    public boolean peek(String string) {
        this.moveToContent();
        if (1 != this.reader.getEventType()) {
            return false;
        }
        String string2 = this.reader.getLocalName();
        return string.equals(string2);
    }

    public void setEncoderContext(EncoderContext encoderContext) {
        this.encoderContext = encoderContext;
    }

    public void setNamespaceTable(NamespaceTable namespaceTable) {
        this.namespaceTable = namespaceTable;
        this.namespaceMappings = null;
        if (namespaceTable != null && this.encoderContext.getNamespaceTable() != null) {
            this.namespaceMappings = this.createMapping(namespaceTable, this.encoderContext.getNamespaceTable(), false);
        }
    }

    public void setServerTable(ServerTable serverTable) {
        this.serverTable = serverTable;
        this.serverMappings = null;
        if (serverTable != null && this.encoderContext.getServerTable() != null) {
            this.serverMappings = this.createMapping(serverTable, this.encoderContext.getServerTable(), false);
        }
    }

    private boolean beginField(String string, boolean bl) throws DecodingException {
        String string2;
        if (this.isNullOrEmpty(string)) {
            return true;
        }
        this.moveToTag();
        if (!this.isStartElement(string)) {
            if (!bl) {
                throw new DecodingException(StatusCodes.Bad_DecodingError, String.format("Encountered element: '{1}:{0}' when expecting element: '{2}'.", this.reader.getLocalName(), this.reader.getNamespaceURI(), string));
            }
            return false;
        }
        if (this.reader.getAttributeCount() != 0 && !this.isNullOrEmpty(string2 = this.reader.getAttributeValue("nil", XML_SCHEMA_INSTANCE)) && Boolean.parseBoolean(string2)) {
            return false;
        }
        this.getStartElement();
        this.moveToContent();
        if (this.reader.getEventType() == 2 && this.reader.getLocalName() == string) {
            this.getEndElement();
            return false;
        }
        return true;
    }

    private boolean beginFieldSafe(String string, boolean bl) throws DecodingException {
        return this.beginField(string, bl);
    }

    private UnsignedShort[] createMapping(UriTable uriTable, UriTable uriTable2, boolean bl) {
        if (uriTable == null) {
            return null;
        }
        UnsignedShort[] unsignedShortArray = new UnsignedShort[uriTable.size()];
        for (int i = 0; i < uriTable.size(); ++i) {
            String string = uriTable.getUri(i);
            int n = uriTable2.getIndex(string);
            if (n < 0) {
                if (!bl) {
                    unsignedShortArray[i] = UnsignedShort.MAX_VALUE;
                    continue;
                }
                n = uriTable2.add(-1, string);
            }
            unsignedShortArray[i] = UnsignedShort.valueOf(n);
        }
        return unsignedShortArray;
    }

    private Object decode(ExtensionObject extensionObject) throws DecodingException {
        return extensionObject.decode(this.getEncoderContext(), this.namespaceTable);
    }

    private Object decode(ExtensionObject[] extensionObjectArray) throws DecodingException {
        return this.getEncoderContext().decode(extensionObjectArray, this.namespaceTable);
    }

    private void endField(String string) throws DecodingException {
        if (!this.isNullOrEmpty(string)) {
            this.moveToEnd();
            int n = this.reader.getEventType();
            String string2 = this.reader.getLocalName();
            if (n != 2) {
                throw new DecodingException(StatusCodes.Bad_DecodingError, "No end element found: '" + string2 + ":" + this.reader.getNamespaceURI() + "' eventType=" + n);
            }
            if (!string2.equals(string)) {
                throw new DecodingException(StatusCodes.Bad_DecodingError, "Encountered end element: '" + string2 + ":" + this.reader.getNamespaceURI() + "' when expecting element: '" + string + "'.");
            }
            this.getEndElement();
        }
    }

    private String getContentAsString() throws DecodingException {
        String string = this.reader.getText();
        try {
            this.reader.next();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
        return string;
    }

    private String getInnerXml(String string) throws DecodingException {
        String string2 = EMPTY_STRING;
        boolean bl = true;
        int n = 0;
        try {
            do {
                int n2 = this.reader.getEventType();
                switch (n2) {
                    case 1: {
                        if (this.reader.getLocalName().equals(string)) {
                            bl = true;
                        }
                        if (bl) {
                            string2 = string2 + "<" + this.reader.getLocalName() + ">";
                        }
                        ++n;
                        break;
                    }
                    case 4: {
                        if (!bl) break;
                        string2 = string2 + this.reader.getText();
                        break;
                    }
                    case 2: {
                        if (--n < 0) {
                            return string2;
                        }
                        if (this.reader.getLocalName().equals(string)) {
                            string2 = string2 + "</" + this.reader.getLocalName() + ">";
                            bl = false;
                        }
                        if (!bl || this.reader.getLocalName().equals(string)) break;
                        string2 = string2 + "</" + this.reader.getLocalName() + ">";
                        break;
                    }
                }
                this.reader.next();
            } while (this.reader.hasNext());
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DecodingException(xMLStreamException);
        }
        return string2;
    }

    private String getString() throws DecodingException {
        String string = this.getContentAsString();
        if (string != null && this.encoderContext.getMaxArrayLength() > 0 && this.encoderContext.getMaxArrayLength() < string.length()) {
            throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
        }
        return string;
    }

    private void initialize() {
        this.reader = null;
    }

    private boolean isNullOrEmpty(String string) {
        if (string == null) {
            return true;
        }
        return string.trim().length() == 0;
    }

    private boolean isStartElement(String string) {
        this.moveToContent();
        return this.peek(string);
    }

    private void moveToContent() {
        while (this.reader.getEventType() != 12 && this.reader.getEventType() != 1 && this.reader.getEventType() != 2 && this.reader.getEventType() != 9 && this.reader.getEventType() != 4 && this.reader.getEventType() != 8) {
            try {
                this.reader.next();
            }
            catch (XMLStreamException xMLStreamException) {
                return;
            }
        }
    }

    private boolean moveToElement(String string) throws DecodingException {
        while (!this.reader.isStartElement()) {
            if (this.reader.getEventType() == 2) {
                return false;
            }
            try {
                this.reader.next();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new DecodingException(xMLStreamException);
            }
        }
        if (this.isNullOrEmpty(string)) {
            return true;
        }
        return this.reader.getLocalName() == string;
    }

    private void moveToEnd() {
        while (this.reader.getEventType() != 2 && this.reader.getEventType() != 8) {
            try {
                this.reader.next();
            }
            catch (XMLStreamException xMLStreamException) {
                return;
            }
        }
    }

    private void moveToTag() throws DecodingException {
        while (this.reader.getEventType() != 1 && this.reader.getEventType() != 2 && this.reader.getEventType() != 9 && this.reader.getEventType() != 8) {
            try {
                this.reader.nextTag();
            }
            catch (XMLStreamException xMLStreamException) {
                return;
            }
        }
    }

    private void skip() throws XMLStreamException {
        int n = 0;
        this.reader.next();
        if (this.reader.getEventType() != 2) {
            ++n;
            while (n != 0) {
                this.reader.next();
                if (this.reader.getEventType() != 1) {
                    ++n;
                    continue;
                }
                if (this.reader.getEventType() == 1) continue;
                --n;
            }
        }
        this.reader.next();
    }

    private void skip(QName qName) throws DecodingException {
        this.moveToContent();
        int n = 1;
        while (n > 0) {
            if (this.reader.getEventType() == 2) {
                if (this.reader.getLocalName().equals(qName.getLocalPart()) && this.reader.getNamespaceURI().equals(qName.getNamespaceURI())) {
                    --n;
                }
            } else if (this.reader.getEventType() == 1 && this.reader.getLocalName().equals(qName.getLocalPart()) && this.reader.getNamespaceURI().equals(qName.getNamespaceURI())) {
                ++n;
            }
            try {
                this.skip();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new DecodingException(xMLStreamException);
            }
            this.moveToContent();
        }
    }
}

