/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.encoding.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.encoding.IEncodeable;
import org.opcfoundation.ua.encoding.utils.EncodeableDesc;

public class EncodeableDescTable {
    private Map<Class<? extends IEncodeable>, EncodeableDesc> classMap = new HashMap<Class<? extends IEncodeable>, EncodeableDesc>();
    private Map<ExpandedNodeId, EncodeableDesc> idMap = new HashMap<ExpandedNodeId, EncodeableDesc>();
    private Map<ExpandedNodeId, EncodeableDesc> binIdMap = new HashMap<ExpandedNodeId, EncodeableDesc>();
    private Map<ExpandedNodeId, EncodeableDesc> xmlIdMap = new HashMap<ExpandedNodeId, EncodeableDesc>();
    private Map<Class<? extends IEncodeable>, EncodeableDesc> _classMap = Collections.unmodifiableMap(this.classMap);
    private Map<ExpandedNodeId, EncodeableDesc> _idMap = Collections.unmodifiableMap(this.idMap);
    private Map<ExpandedNodeId, EncodeableDesc> _binIdMap = Collections.unmodifiableMap(this.binIdMap);
    private Map<ExpandedNodeId, EncodeableDesc> _xmlIdMap = Collections.unmodifiableMap(this.xmlIdMap);

    public EncodeableDesc get(Class<?> clazz) {
        return this.classMap.get(clazz);
    }

    public EncodeableDesc get(ExpandedNodeId expandedNodeId) {
        return this.idMap.get(expandedNodeId);
    }

    public void addStructureInfo(EncodeableDesc encodeableDesc) {
        this.classMap.put(encodeableDesc.clazz, encodeableDesc);
        this.idMap.put(encodeableDesc.binaryId, encodeableDesc);
        this.idMap.put(encodeableDesc.xmlId, encodeableDesc);
        this.idMap.put(encodeableDesc.id, encodeableDesc);
        this.binIdMap.put(encodeableDesc.binaryId, encodeableDesc);
        this.xmlIdMap.put(encodeableDesc.binaryId, encodeableDesc);
    }

    public Map<ExpandedNodeId, EncodeableDesc> getIdMap() {
        return this._idMap;
    }

    public Map<ExpandedNodeId, EncodeableDesc> getBinIdMap() {
        return this._binIdMap;
    }

    public Map<ExpandedNodeId, EncodeableDesc> getXmlIdMap() {
        return this._xmlIdMap;
    }

    public Map<Class<? extends IEncodeable>, EncodeableDesc> getClassMap() {
        return this._classMap;
    }
}

