/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.encoding.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opcfoundation.ua.builtintypes.BuiltinsMap;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.encoding.IEncodeable;

public final class EncodeableDesc {
    public final Class<? extends IEncodeable> clazz;
    public final FieldInfo[] fields;
    public final ExpandedNodeId binaryId;
    public final ExpandedNodeId xmlId;
    public final ExpandedNodeId id;
    public final String url;
    public final int length;
    public final Map<String, FieldInfo> fieldNameMap = new HashMap<String, FieldInfo>();

    public EncodeableDesc(Class<? extends IEncodeable> clazz, FieldInfo[] fieldInfoArray, ExpandedNodeId expandedNodeId, String string, ExpandedNodeId expandedNodeId2, ExpandedNodeId expandedNodeId3) {
        if (clazz == null || fieldInfoArray == null) {
            throw new IllegalArgumentException("null");
        }
        this.binaryId = expandedNodeId2;
        this.clazz = clazz;
        this.fields = fieldInfoArray;
        this.id = expandedNodeId;
        this.url = string;
        this.xmlId = expandedNodeId3;
        this.length = fieldInfoArray.length;
        for (FieldInfo fieldInfo : fieldInfoArray) {
            this.fieldNameMap.put(fieldInfo.field.getName(), fieldInfo);
        }
    }

    static FieldInfo readFieldInfoFromClass(Field field) {
        field.setAccessible(true);
        Class<?> clazz = field.getType();
        Integer n = BuiltinsMap.ID_MAP.get(clazz);
        int n2 = n == null ? -1 : n;
        boolean bl = clazz.isArray() && !clazz.equals(byte[].class);
        return new FieldInfo(n2, field, bl, clazz);
    }

    public static EncodeableDesc readFromClass(Class<? extends IEncodeable> clazz, Field[] fieldArray) {
        ExpandedNodeId expandedNodeId = null;
        ExpandedNodeId expandedNodeId2 = null;
        ExpandedNodeId expandedNodeId3 = null;
        String string = null;
        ArrayList<FieldInfo> arrayList = new ArrayList<FieldInfo>();
        for (Field field : fieldArray) {
            FieldInfo fieldInfo = EncodeableDesc.readFieldInfoFromClass(field);
            arrayList.add(fieldInfo);
        }
        return new EncodeableDesc(clazz, arrayList.toArray(new FieldInfo[arrayList.size()]), expandedNodeId2, string, expandedNodeId, expandedNodeId3);
    }

    public static class FieldInfo {
        public final Field field;
        public final Class<?> type;
        public final int builtinType;
        public final boolean isArray;

        public FieldInfo(int n, Field field, boolean bl, Class<?> clazz) {
            this.builtinType = n;
            this.field = field;
            this.isArray = bl;
            this.type = clazz;
        }
    }
}

