/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.encoding.utils;

import java.util.Collection;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.encoding.DecodingException;
import org.opcfoundation.ua.encoding.EncodeType;
import org.opcfoundation.ua.encoding.EncodingException;
import org.opcfoundation.ua.encoding.IDecoder;
import org.opcfoundation.ua.encoding.IEncodeable;
import org.opcfoundation.ua.encoding.IEncoder;
import org.opcfoundation.ua.encoding.binary.IEncodeableSerializer;

public abstract class AbstractSerializer
implements IEncodeableSerializer {
    Class<? extends IEncodeable> clazz;
    ExpandedNodeId binaryId;
    ExpandedNodeId xmlId;
    ExpandedNodeId nodeId;

    public AbstractSerializer(Class<? extends IEncodeable> clazz, ExpandedNodeId expandedNodeId, ExpandedNodeId expandedNodeId2) {
        this(clazz, expandedNodeId, expandedNodeId2, null);
    }

    public AbstractSerializer(Class<? extends IEncodeable> clazz, ExpandedNodeId expandedNodeId, ExpandedNodeId expandedNodeId2, ExpandedNodeId expandedNodeId3) {
        if (clazz == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.clazz = clazz;
        this.binaryId = expandedNodeId;
        this.xmlId = expandedNodeId2;
        this.nodeId = expandedNodeId3;
    }

    public abstract void calcEncodeable(IEncodeable var1, IEncoder var2) throws EncodingException;

    public abstract void putEncodeable(IEncodeable var1, IEncoder var2) throws EncodingException;

    public abstract IEncodeable getEncodeable(IDecoder var1) throws DecodingException;

    @Override
    public void calcEncodeable(Class<? extends IEncodeable> clazz, IEncodeable iEncodeable, IEncoder iEncoder) throws EncodingException {
        if (!clazz.equals(this.clazz)) {
            throw new EncodingException("Cannot encode " + clazz);
        }
        this.calcEncodeable(iEncodeable, iEncoder);
    }

    @Override
    public void putEncodeable(Class<? extends IEncodeable> clazz, IEncodeable iEncodeable, IEncoder iEncoder) throws EncodingException {
        if (!clazz.equals(this.clazz)) {
            throw new EncodingException("Cannot encode " + clazz);
        }
        this.putEncodeable(iEncodeable, iEncoder);
    }

    @Override
    public Class<? extends IEncodeable> getClass(ExpandedNodeId expandedNodeId) {
        return expandedNodeId.equals(this.binaryId) || expandedNodeId.equals(this.xmlId) || this.nodeId != null && expandedNodeId.equals(this.nodeId) ? this.clazz : null;
    }

    @Override
    public ExpandedNodeId getNodeId(Class<? extends IEncodeable> clazz, EncodeType encodeType) {
        if (encodeType == null) {
            return this.nodeId;
        }
        if (encodeType == EncodeType.Binary) {
            return this.binaryId;
        }
        if (encodeType == EncodeType.Xml) {
            return this.xmlId;
        }
        return null;
    }

    @Override
    public IEncodeable getEncodeable(Class<? extends IEncodeable> clazz, IDecoder iDecoder) throws DecodingException {
        if (!clazz.equals(this.clazz)) {
            throw new DecodingException("Cannot decode " + clazz);
        }
        return this.getEncodeable(iDecoder);
    }

    @Override
    public void getSupportedClasses(Collection<Class<? extends IEncodeable>> collection) {
        collection.add(this.clazz);
    }

    @Override
    public void getSupportedNodeIds(Collection<ExpandedNodeId> collection) {
        if (this.binaryId != null) {
            collection.add(this.binaryId);
        }
        if (this.xmlId != null) {
            collection.add(this.xmlId);
        }
    }
}

