/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.UserIdentityToken;
import org.opcfoundation.ua.utils.ObjectUtils;

public class X509IdentityToken
extends UserIdentityToken
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.X509IdentityToken);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.X509IdentityToken_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.X509IdentityToken_Encoding_DefaultXml);
    protected byte[] CertificateData;

    public X509IdentityToken() {
    }

    public X509IdentityToken(String string, byte[] byArray) {
        super(string);
        this.CertificateData = byArray;
    }

    public byte[] getCertificateData() {
        return this.CertificateData;
    }

    public void setCertificateData(byte[] byArray) {
        this.CertificateData = byArray;
    }

    @Override
    public X509IdentityToken clone() {
        X509IdentityToken x509IdentityToken = new X509IdentityToken();
        x509IdentityToken.PolicyId = this.PolicyId;
        x509IdentityToken.CertificateData = this.CertificateData;
        return x509IdentityToken;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        X509IdentityToken x509IdentityToken = (X509IdentityToken)object;
        if (this.PolicyId == null ? x509IdentityToken.PolicyId != null : !this.PolicyId.equals(x509IdentityToken.PolicyId)) {
            return false;
        }
        return !(this.CertificateData == null ? x509IdentityToken.CertificateData != null : !this.CertificateData.equals(x509IdentityToken.CertificateData));
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.PolicyId == null ? 0 : this.PolicyId.hashCode());
        n = 31 * n + (this.CertificateData == null ? 0 : this.CertificateData.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    public String toString() {
        return "X509IdentityToken: " + ObjectUtils.printFieldsDeep(this);
    }
}

