/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.ServiceResult;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.utils.AttributesUtil;
import org.opcfoundation.ua.utils.NumericRange;

public class WriteValue
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.WriteValue);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.WriteValue_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.WriteValue_Encoding_DefaultXml);
    NumericRange ParsedIndexRange = NumericRange.getEmpty();
    protected NodeId NodeId;
    protected UnsignedInteger AttributeId;
    protected String IndexRange;
    protected DataValue Value;

    public WriteValue() {
    }

    public WriteValue(NodeId nodeId, UnsignedInteger unsignedInteger, String string, DataValue dataValue) {
        this.NodeId = nodeId;
        this.AttributeId = unsignedInteger;
        this.IndexRange = string;
        this.Value = dataValue;
    }

    public NodeId getNodeId() {
        return this.NodeId;
    }

    public void setNodeId(NodeId nodeId) {
        this.NodeId = nodeId;
    }

    public UnsignedInteger getAttributeId() {
        return this.AttributeId;
    }

    public void setAttributeId(UnsignedInteger unsignedInteger) {
        this.AttributeId = unsignedInteger;
    }

    public String getIndexRange() {
        return this.IndexRange;
    }

    public void setIndexRange(String string) {
        this.IndexRange = string;
    }

    public DataValue getValue() {
        return this.Value;
    }

    public void setValue(DataValue dataValue) {
        this.Value = dataValue;
    }

    public WriteValue clone() {
        WriteValue writeValue = new WriteValue();
        writeValue.NodeId = this.NodeId;
        writeValue.AttributeId = this.AttributeId;
        writeValue.IndexRange = this.IndexRange;
        writeValue.Value = this.Value;
        return writeValue;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        WriteValue writeValue = (WriteValue)object;
        if (this.NodeId == null ? writeValue.NodeId != null : !this.NodeId.equals(writeValue.NodeId)) {
            return false;
        }
        if (this.AttributeId == null ? writeValue.AttributeId != null : !this.AttributeId.equals(writeValue.AttributeId)) {
            return false;
        }
        if (this.IndexRange == null ? writeValue.IndexRange != null : !this.IndexRange.equals(writeValue.IndexRange)) {
            return false;
        }
        return !(this.Value == null ? writeValue.Value != null : !this.Value.equals(writeValue.Value));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.NodeId == null ? 0 : this.NodeId.hashCode());
        n = 31 * n + (this.AttributeId == null ? 0 : this.AttributeId.hashCode());
        n = 31 * n + (this.IndexRange == null ? 0 : this.IndexRange.hashCode());
        n = 31 * n + (this.Value == null ? 0 : this.Value.hashCode());
        return n;
    }

    public NumericRange getParsedIndexRange() {
        return this.ParsedIndexRange;
    }

    public static ServiceResult validate(WriteValue writeValue) {
        if (writeValue == null) {
            return new ServiceResult(StatusCodes.Bad_StructureMissing);
        }
        if (writeValue.getNodeId() == null) {
            return new ServiceResult(StatusCodes.Bad_NodeIdInvalid);
        }
        if (!AttributesUtil.isValid(writeValue.AttributeId)) {
            return new ServiceResult(StatusCodes.Bad_AttributeIdInvalid);
        }
        writeValue.ParsedIndexRange = NumericRange.getEmpty();
        if (writeValue.IndexRange != null && !writeValue.IndexRange.isEmpty()) {
            try {
                writeValue.ParsedIndexRange = NumericRange.parse(writeValue.IndexRange);
            }
            catch (Exception exception) {
                return new ServiceResult(StatusCodes.Bad_IndexRangeInvalid, (Throwable)exception);
            }
        } else {
            writeValue.ParsedIndexRange = NumericRange.getEmpty();
        }
        return null;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }
}

