/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.UserIdentityToken;
import org.opcfoundation.ua.utils.ObjectUtils;

public class UserNameIdentityToken
extends UserIdentityToken
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.UserNameIdentityToken);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.UserNameIdentityToken_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.UserNameIdentityToken_Encoding_DefaultXml);
    protected String UserName;
    protected byte[] Password;
    protected String EncryptionAlgorithm;

    public UserNameIdentityToken() {
    }

    public UserNameIdentityToken(String string, String string2, byte[] byArray, String string3) {
        super(string);
        this.UserName = string2;
        this.Password = byArray;
        this.EncryptionAlgorithm = string3;
    }

    public String getUserName() {
        return this.UserName;
    }

    public void setUserName(String string) {
        this.UserName = string;
    }

    public byte[] getPassword() {
        return this.Password;
    }

    public void setPassword(byte[] byArray) {
        this.Password = byArray;
    }

    public String getEncryptionAlgorithm() {
        return this.EncryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(String string) {
        this.EncryptionAlgorithm = string;
    }

    @Override
    public UserNameIdentityToken clone() {
        UserNameIdentityToken userNameIdentityToken = new UserNameIdentityToken();
        userNameIdentityToken.PolicyId = this.PolicyId;
        userNameIdentityToken.UserName = this.UserName;
        userNameIdentityToken.Password = this.Password;
        userNameIdentityToken.EncryptionAlgorithm = this.EncryptionAlgorithm;
        return userNameIdentityToken;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UserNameIdentityToken userNameIdentityToken = (UserNameIdentityToken)object;
        if (this.PolicyId == null ? userNameIdentityToken.PolicyId != null : !this.PolicyId.equals(userNameIdentityToken.PolicyId)) {
            return false;
        }
        if (this.UserName == null ? userNameIdentityToken.UserName != null : !this.UserName.equals(userNameIdentityToken.UserName)) {
            return false;
        }
        if (this.Password == null ? userNameIdentityToken.Password != null : !this.Password.equals(userNameIdentityToken.Password)) {
            return false;
        }
        return !(this.EncryptionAlgorithm == null ? userNameIdentityToken.EncryptionAlgorithm != null : !this.EncryptionAlgorithm.equals(userNameIdentityToken.EncryptionAlgorithm));
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.PolicyId == null ? 0 : this.PolicyId.hashCode());
        n = 31 * n + (this.UserName == null ? 0 : this.UserName.hashCode());
        n = 31 * n + (this.Password == null ? 0 : this.Password.hashCode());
        n = 31 * n + (this.EncryptionAlgorithm == null ? 0 : this.EncryptionAlgorithm.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    public String toString() {
        return "UserNameIdentityToken: " + ObjectUtils.printFieldsDeep(this);
    }
}

