/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.Node;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.ReferenceNode;
import org.opcfoundation.ua.utils.ObjectUtils;

public class TypeNode
extends Node
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.TypeNode);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.TypeNode_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.TypeNode_Encoding_DefaultXml);

    public TypeNode() {
    }

    public TypeNode(NodeId nodeId, NodeClass nodeClass, QualifiedName qualifiedName, LocalizedText localizedText, LocalizedText localizedText2, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, ReferenceNode[] referenceNodeArray) {
        super(nodeId, nodeClass, qualifiedName, localizedText, localizedText2, unsignedInteger, unsignedInteger2, referenceNodeArray);
    }

    @Override
    public TypeNode clone() {
        TypeNode typeNode = new TypeNode();
        typeNode.NodeId = this.NodeId;
        typeNode.NodeClass = this.NodeClass;
        typeNode.BrowseName = this.BrowseName;
        typeNode.DisplayName = this.DisplayName;
        typeNode.Description = this.Description;
        typeNode.WriteMask = this.WriteMask;
        typeNode.UserWriteMask = this.UserWriteMask;
        if (this.References != null) {
            typeNode.References = new ReferenceNode[this.References.length];
            for (int i = 0; i < this.References.length; ++i) {
                typeNode.References[i] = this.References[i].clone();
            }
        }
        return typeNode;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TypeNode typeNode = (TypeNode)object;
        if (this.NodeId == null ? typeNode.NodeId != null : !this.NodeId.equals(typeNode.NodeId)) {
            return false;
        }
        if (this.NodeClass == null ? typeNode.NodeClass != null : !this.NodeClass.equals(typeNode.NodeClass)) {
            return false;
        }
        if (this.BrowseName == null ? typeNode.BrowseName != null : !this.BrowseName.equals(typeNode.BrowseName)) {
            return false;
        }
        if (this.DisplayName == null ? typeNode.DisplayName != null : !this.DisplayName.equals(typeNode.DisplayName)) {
            return false;
        }
        if (this.Description == null ? typeNode.Description != null : !this.Description.equals(typeNode.Description)) {
            return false;
        }
        if (this.WriteMask == null ? typeNode.WriteMask != null : !this.WriteMask.equals(typeNode.WriteMask)) {
            return false;
        }
        if (this.UserWriteMask == null ? typeNode.UserWriteMask != null : !this.UserWriteMask.equals(typeNode.UserWriteMask)) {
            return false;
        }
        return !(this.References == null ? typeNode.References != null : !Arrays.equals(this.References, typeNode.References));
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.NodeId == null ? 0 : this.NodeId.hashCode());
        n = 31 * n + (this.NodeClass == null ? 0 : this.NodeClass.hashCode());
        n = 31 * n + (this.BrowseName == null ? 0 : this.BrowseName.hashCode());
        n = 31 * n + (this.DisplayName == null ? 0 : this.DisplayName.hashCode());
        n = 31 * n + (this.Description == null ? 0 : this.Description.hashCode());
        n = 31 * n + (this.WriteMask == null ? 0 : this.WriteMask.hashCode());
        n = 31 * n + (this.UserWriteMask == null ? 0 : this.UserWriteMask.hashCode());
        n = 31 * n + (this.References == null ? 0 : Arrays.hashCode(this.References));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    public String toString() {
        return "TypeNode: " + ObjectUtils.printFieldsDeep(this);
    }
}

