/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ServiceResponse;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.ResponseHeader;
import org.opcfoundation.ua.core.TransferResult;
import org.opcfoundation.ua.utils.ObjectUtils;

public class TransferSubscriptionsResponse
implements ServiceResponse {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.TransferSubscriptionsResponse);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.TransferSubscriptionsResponse_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.TransferSubscriptionsResponse_Encoding_DefaultXml);
    protected ResponseHeader ResponseHeader;
    protected TransferResult[] Results;
    protected DiagnosticInfo[] DiagnosticInfos;

    public TransferSubscriptionsResponse() {
    }

    public TransferSubscriptionsResponse(ResponseHeader responseHeader, TransferResult[] transferResultArray, DiagnosticInfo[] diagnosticInfoArray) {
        this.ResponseHeader = responseHeader;
        this.Results = transferResultArray;
        this.DiagnosticInfos = diagnosticInfoArray;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.ResponseHeader;
    }

    @Override
    public void setResponseHeader(ResponseHeader responseHeader) {
        this.ResponseHeader = responseHeader;
    }

    public TransferResult[] getResults() {
        return this.Results;
    }

    public void setResults(TransferResult[] transferResultArray) {
        this.Results = transferResultArray;
    }

    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.DiagnosticInfos;
    }

    public void setDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
        this.DiagnosticInfos = diagnosticInfoArray;
    }

    public TransferSubscriptionsResponse clone() {
        TransferSubscriptionsResponse transferSubscriptionsResponse = new TransferSubscriptionsResponse();
        ResponseHeader responseHeader = transferSubscriptionsResponse.ResponseHeader = this.ResponseHeader == null ? null : this.ResponseHeader.clone();
        if (this.Results != null) {
            transferSubscriptionsResponse.Results = new TransferResult[this.Results.length];
            for (int i = 0; i < this.Results.length; ++i) {
                transferSubscriptionsResponse.Results[i] = this.Results[i].clone();
            }
        }
        transferSubscriptionsResponse.DiagnosticInfos = this.DiagnosticInfos == null ? null : (DiagnosticInfo[])this.DiagnosticInfos.clone();
        return transferSubscriptionsResponse;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TransferSubscriptionsResponse transferSubscriptionsResponse = (TransferSubscriptionsResponse)object;
        if (this.ResponseHeader == null ? transferSubscriptionsResponse.ResponseHeader != null : !this.ResponseHeader.equals(transferSubscriptionsResponse.ResponseHeader)) {
            return false;
        }
        if (this.Results == null ? transferSubscriptionsResponse.Results != null : !Arrays.equals(this.Results, transferSubscriptionsResponse.Results)) {
            return false;
        }
        return !(this.DiagnosticInfos == null ? transferSubscriptionsResponse.DiagnosticInfos != null : !Arrays.equals(this.DiagnosticInfos, transferSubscriptionsResponse.DiagnosticInfos));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.ResponseHeader == null ? 0 : this.ResponseHeader.hashCode());
        n = 31 * n + (this.Results == null ? 0 : Arrays.hashCode(this.Results));
        n = 31 * n + (this.DiagnosticInfos == null ? 0 : Arrays.hashCode(this.DiagnosticInfos));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return ObjectUtils.printFieldsDeep(this);
    }
}

