/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.utils.ObjectUtils;

public class TransferResult
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.TransferResult);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.TransferResult_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.TransferResult_Encoding_DefaultXml);
    protected StatusCode StatusCode;
    protected UnsignedInteger[] AvailableSequenceNumbers;

    public TransferResult() {
    }

    public TransferResult(StatusCode statusCode, UnsignedInteger[] unsignedIntegerArray) {
        this.StatusCode = statusCode;
        this.AvailableSequenceNumbers = unsignedIntegerArray;
    }

    public StatusCode getStatusCode() {
        return this.StatusCode;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.StatusCode = statusCode;
    }

    public UnsignedInteger[] getAvailableSequenceNumbers() {
        return this.AvailableSequenceNumbers;
    }

    public void setAvailableSequenceNumbers(UnsignedInteger[] unsignedIntegerArray) {
        this.AvailableSequenceNumbers = unsignedIntegerArray;
    }

    public TransferResult clone() {
        TransferResult transferResult = new TransferResult();
        transferResult.StatusCode = this.StatusCode;
        transferResult.AvailableSequenceNumbers = this.AvailableSequenceNumbers == null ? null : (UnsignedInteger[])this.AvailableSequenceNumbers.clone();
        return transferResult;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TransferResult transferResult = (TransferResult)object;
        if (this.StatusCode == null ? transferResult.StatusCode != null : !this.StatusCode.equals(transferResult.StatusCode)) {
            return false;
        }
        return !(this.AvailableSequenceNumbers == null ? transferResult.AvailableSequenceNumbers != null : !Arrays.equals(this.AvailableSequenceNumbers, transferResult.AvailableSequenceNumbers));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.StatusCode == null ? 0 : this.StatusCode.hashCode());
        n = 31 * n + (this.AvailableSequenceNumbers == null ? 0 : Arrays.hashCode(this.AvailableSequenceNumbers));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return "TransferResult: " + ObjectUtils.printFieldsDeep(this);
    }
}

