/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.RequestHeader;
import org.opcfoundation.ua.utils.ObjectUtils;

public class TestStackRequest
implements ServiceRequest {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.TestStackRequest);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.TestStackRequest_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.TestStackRequest_Encoding_DefaultXml);
    protected RequestHeader RequestHeader;
    protected UnsignedInteger TestId;
    protected Integer Iteration;
    protected Variant Input;

    public TestStackRequest() {
    }

    public TestStackRequest(RequestHeader requestHeader, UnsignedInteger unsignedInteger, Integer n, Variant variant) {
        this.RequestHeader = requestHeader;
        this.TestId = unsignedInteger;
        this.Iteration = n;
        this.Input = variant;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.RequestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.RequestHeader = requestHeader;
    }

    public UnsignedInteger getTestId() {
        return this.TestId;
    }

    public void setTestId(UnsignedInteger unsignedInteger) {
        this.TestId = unsignedInteger;
    }

    public Integer getIteration() {
        return this.Iteration;
    }

    public void setIteration(Integer n) {
        this.Iteration = n;
    }

    public Variant getInput() {
        return this.Input;
    }

    public void setInput(Variant variant) {
        this.Input = variant;
    }

    public TestStackRequest clone() {
        TestStackRequest testStackRequest = new TestStackRequest();
        testStackRequest.RequestHeader = this.RequestHeader == null ? null : this.RequestHeader.clone();
        testStackRequest.TestId = this.TestId;
        testStackRequest.Iteration = this.Iteration;
        testStackRequest.Input = this.Input;
        return testStackRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TestStackRequest testStackRequest = (TestStackRequest)object;
        if (this.RequestHeader == null ? testStackRequest.RequestHeader != null : !this.RequestHeader.equals(testStackRequest.RequestHeader)) {
            return false;
        }
        if (this.TestId == null ? testStackRequest.TestId != null : !this.TestId.equals(testStackRequest.TestId)) {
            return false;
        }
        if (this.Iteration == null ? testStackRequest.Iteration != null : !this.Iteration.equals(testStackRequest.Iteration)) {
            return false;
        }
        return !(this.Input == null ? testStackRequest.Input != null : !this.Input.equals(testStackRequest.Input));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.RequestHeader == null ? 0 : this.RequestHeader.hashCode());
        n = 31 * n + (this.TestId == null ? 0 : this.TestId.hashCode());
        n = 31 * n + (this.Iteration == null ? 0 : this.Iteration.hashCode());
        n = 31 * n + (this.Input == null ? 0 : this.Input.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return ObjectUtils.printFieldsDeep(this);
    }
}

