/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.RelativePathElement;
import org.opcfoundation.ua.utils.ObjectUtils;

public class RelativePath
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.RelativePath);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.RelativePath_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.RelativePath_Encoding_DefaultXml);
    protected RelativePathElement[] Elements;

    public RelativePath() {
    }

    public RelativePath(RelativePathElement[] relativePathElementArray) {
        this.Elements = relativePathElementArray;
    }

    public RelativePathElement[] getElements() {
        return this.Elements;
    }

    public void setElements(RelativePathElement[] relativePathElementArray) {
        this.Elements = relativePathElementArray;
    }

    public RelativePath clone() {
        RelativePath relativePath = new RelativePath();
        if (this.Elements != null) {
            relativePath.Elements = new RelativePathElement[this.Elements.length];
            for (int i = 0; i < this.Elements.length; ++i) {
                relativePath.Elements[i] = this.Elements[i].clone();
            }
        }
        return relativePath;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RelativePath relativePath = (RelativePath)object;
        return !(this.Elements == null ? relativePath.Elements != null : !Arrays.equals(this.Elements, relativePath.Elements));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.Elements == null ? 0 : Arrays.hashCode(this.Elements));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return "RelativePath: " + ObjectUtils.printFieldsDeep(this);
    }
}

