/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ServiceResponse;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.ResponseHeader;
import org.opcfoundation.ua.utils.ObjectUtils;

public class ReadResponse
implements ServiceResponse {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.ReadResponse);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.ReadResponse_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.ReadResponse_Encoding_DefaultXml);
    protected ResponseHeader ResponseHeader;
    protected DataValue[] Results;
    protected DiagnosticInfo[] DiagnosticInfos;

    public ReadResponse() {
    }

    public ReadResponse(ResponseHeader responseHeader, DataValue[] dataValueArray, DiagnosticInfo[] diagnosticInfoArray) {
        this.ResponseHeader = responseHeader;
        this.Results = dataValueArray;
        this.DiagnosticInfos = diagnosticInfoArray;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.ResponseHeader;
    }

    @Override
    public void setResponseHeader(ResponseHeader responseHeader) {
        this.ResponseHeader = responseHeader;
    }

    public DataValue[] getResults() {
        return this.Results;
    }

    public void setResults(DataValue[] dataValueArray) {
        this.Results = dataValueArray;
    }

    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.DiagnosticInfos;
    }

    public void setDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
        this.DiagnosticInfos = diagnosticInfoArray;
    }

    public ReadResponse clone() {
        ReadResponse readResponse = new ReadResponse();
        readResponse.ResponseHeader = this.ResponseHeader == null ? null : this.ResponseHeader.clone();
        readResponse.Results = this.Results == null ? null : (DataValue[])this.Results.clone();
        readResponse.DiagnosticInfos = this.DiagnosticInfos == null ? null : (DiagnosticInfo[])this.DiagnosticInfos.clone();
        return readResponse;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ReadResponse readResponse = (ReadResponse)object;
        if (this.ResponseHeader == null ? readResponse.ResponseHeader != null : !this.ResponseHeader.equals(readResponse.ResponseHeader)) {
            return false;
        }
        if (this.Results == null ? readResponse.Results != null : !Arrays.equals(this.Results, readResponse.Results)) {
            return false;
        }
        return !(this.DiagnosticInfos == null ? readResponse.DiagnosticInfos != null : !Arrays.equals(this.DiagnosticInfos, readResponse.DiagnosticInfos));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.ResponseHeader == null ? 0 : this.ResponseHeader.hashCode());
        n = 31 * n + (this.Results == null ? 0 : Arrays.hashCode(this.Results));
        n = 31 * n + (this.DiagnosticInfos == null ? 0 : Arrays.hashCode(this.DiagnosticInfos));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return ObjectUtils.printFieldsDeep(this);
    }
}

