/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.EventFilter;
import org.opcfoundation.ua.core.HistoryReadDetails;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.utils.ObjectUtils;

public class ReadEventDetails
extends HistoryReadDetails
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.ReadEventDetails);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.ReadEventDetails_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.ReadEventDetails_Encoding_DefaultXml);
    protected UnsignedInteger NumValuesPerNode;
    protected DateTime StartTime;
    protected DateTime EndTime;
    protected EventFilter Filter;

    public ReadEventDetails() {
    }

    public ReadEventDetails(UnsignedInteger unsignedInteger, DateTime dateTime, DateTime dateTime2, EventFilter eventFilter) {
        this.NumValuesPerNode = unsignedInteger;
        this.StartTime = dateTime;
        this.EndTime = dateTime2;
        this.Filter = eventFilter;
    }

    public UnsignedInteger getNumValuesPerNode() {
        return this.NumValuesPerNode;
    }

    public void setNumValuesPerNode(UnsignedInteger unsignedInteger) {
        this.NumValuesPerNode = unsignedInteger;
    }

    public DateTime getStartTime() {
        return this.StartTime;
    }

    public void setStartTime(DateTime dateTime) {
        this.StartTime = dateTime;
    }

    public DateTime getEndTime() {
        return this.EndTime;
    }

    public void setEndTime(DateTime dateTime) {
        this.EndTime = dateTime;
    }

    public EventFilter getFilter() {
        return this.Filter;
    }

    public void setFilter(EventFilter eventFilter) {
        this.Filter = eventFilter;
    }

    @Override
    public ReadEventDetails clone() {
        ReadEventDetails readEventDetails = new ReadEventDetails();
        readEventDetails.NumValuesPerNode = this.NumValuesPerNode;
        readEventDetails.StartTime = this.StartTime;
        readEventDetails.EndTime = this.EndTime;
        readEventDetails.Filter = this.Filter == null ? null : this.Filter.clone();
        return readEventDetails;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ReadEventDetails readEventDetails = (ReadEventDetails)object;
        if (this.NumValuesPerNode == null ? readEventDetails.NumValuesPerNode != null : !this.NumValuesPerNode.equals(readEventDetails.NumValuesPerNode)) {
            return false;
        }
        if (this.StartTime == null ? readEventDetails.StartTime != null : !this.StartTime.equals(readEventDetails.StartTime)) {
            return false;
        }
        if (this.EndTime == null ? readEventDetails.EndTime != null : !this.EndTime.equals(readEventDetails.EndTime)) {
            return false;
        }
        return !(this.Filter == null ? readEventDetails.Filter != null : !this.Filter.equals(readEventDetails.Filter));
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.NumValuesPerNode == null ? 0 : this.NumValuesPerNode.hashCode());
        n = 31 * n + (this.StartTime == null ? 0 : this.StartTime.hashCode());
        n = 31 * n + (this.EndTime == null ? 0 : this.EndTime.hashCode());
        n = 31 * n + (this.Filter == null ? 0 : this.Filter.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    public String toString() {
        return "ReadEventDetails: " + ObjectUtils.printFieldsDeep(this);
    }
}

