/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.ReferenceNode;
import org.opcfoundation.ua.core.TypeNode;
import org.opcfoundation.ua.utils.ObjectUtils;

public class ObjectTypeNode
extends TypeNode
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.ObjectTypeNode);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.ObjectTypeNode_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.ObjectTypeNode_Encoding_DefaultXml);
    protected Boolean IsAbstract;

    public ObjectTypeNode() {
    }

    public ObjectTypeNode(NodeId nodeId, NodeClass nodeClass, QualifiedName qualifiedName, LocalizedText localizedText, LocalizedText localizedText2, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, ReferenceNode[] referenceNodeArray, Boolean bl) {
        super(nodeId, nodeClass, qualifiedName, localizedText, localizedText2, unsignedInteger, unsignedInteger2, referenceNodeArray);
        this.IsAbstract = bl;
    }

    public Boolean getIsAbstract() {
        return this.IsAbstract;
    }

    public void setIsAbstract(Boolean bl) {
        this.IsAbstract = bl;
    }

    @Override
    public ObjectTypeNode clone() {
        ObjectTypeNode objectTypeNode = new ObjectTypeNode();
        objectTypeNode.NodeId = this.NodeId;
        objectTypeNode.NodeClass = this.NodeClass;
        objectTypeNode.BrowseName = this.BrowseName;
        objectTypeNode.DisplayName = this.DisplayName;
        objectTypeNode.Description = this.Description;
        objectTypeNode.WriteMask = this.WriteMask;
        objectTypeNode.UserWriteMask = this.UserWriteMask;
        if (this.References != null) {
            objectTypeNode.References = new ReferenceNode[this.References.length];
            for (int i = 0; i < this.References.length; ++i) {
                objectTypeNode.References[i] = this.References[i].clone();
            }
        }
        objectTypeNode.IsAbstract = this.IsAbstract;
        return objectTypeNode;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ObjectTypeNode objectTypeNode = (ObjectTypeNode)object;
        if (this.NodeId == null ? objectTypeNode.NodeId != null : !this.NodeId.equals(objectTypeNode.NodeId)) {
            return false;
        }
        if (this.NodeClass == null ? objectTypeNode.NodeClass != null : !this.NodeClass.equals(objectTypeNode.NodeClass)) {
            return false;
        }
        if (this.BrowseName == null ? objectTypeNode.BrowseName != null : !this.BrowseName.equals(objectTypeNode.BrowseName)) {
            return false;
        }
        if (this.DisplayName == null ? objectTypeNode.DisplayName != null : !this.DisplayName.equals(objectTypeNode.DisplayName)) {
            return false;
        }
        if (this.Description == null ? objectTypeNode.Description != null : !this.Description.equals(objectTypeNode.Description)) {
            return false;
        }
        if (this.WriteMask == null ? objectTypeNode.WriteMask != null : !this.WriteMask.equals(objectTypeNode.WriteMask)) {
            return false;
        }
        if (this.UserWriteMask == null ? objectTypeNode.UserWriteMask != null : !this.UserWriteMask.equals(objectTypeNode.UserWriteMask)) {
            return false;
        }
        if (this.References == null ? objectTypeNode.References != null : !Arrays.equals(this.References, objectTypeNode.References)) {
            return false;
        }
        return !(this.IsAbstract == null ? objectTypeNode.IsAbstract != null : !this.IsAbstract.equals(objectTypeNode.IsAbstract));
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.NodeId == null ? 0 : this.NodeId.hashCode());
        n = 31 * n + (this.NodeClass == null ? 0 : this.NodeClass.hashCode());
        n = 31 * n + (this.BrowseName == null ? 0 : this.BrowseName.hashCode());
        n = 31 * n + (this.DisplayName == null ? 0 : this.DisplayName.hashCode());
        n = 31 * n + (this.Description == null ? 0 : this.Description.hashCode());
        n = 31 * n + (this.WriteMask == null ? 0 : this.WriteMask.hashCode());
        n = 31 * n + (this.UserWriteMask == null ? 0 : this.UserWriteMask.hashCode());
        n = 31 * n + (this.References == null ? 0 : Arrays.hashCode(this.References));
        n = 31 * n + (this.IsAbstract == null ? 0 : this.IsAbstract.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    public String toString() {
        return "ObjectTypeNode: " + ObjectUtils.printFieldsDeep(this);
    }
}

