/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.opcfoundation.ua.builtintypes.Enumeration;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Identifiers;

public enum NodeClass implements Enumeration
{
    Unspecified(0),
    Object(1),
    Variable(2),
    Method(4),
    ObjectType(8),
    VariableType(16),
    ReferenceType(32),
    DataType(64),
    View(128);

    public static final NodeId ID;
    public static EnumSet<NodeClass> NONE;
    public static EnumSet<NodeClass> ALL;
    private final int value;
    private static final Map<Integer, NodeClass> map;

    private NodeClass(int n2) {
        this.value = n2;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static NodeClass valueOf(int n) {
        return map.get(n);
    }

    public static NodeClass valueOf(Integer n) {
        return n == null ? null : NodeClass.valueOf((int)n);
    }

    public static NodeClass valueOf(UnsignedInteger unsignedInteger) {
        return unsignedInteger == null ? null : NodeClass.valueOf(unsignedInteger.intValue());
    }

    public static NodeClass[] valueOf(int[] nArray) {
        NodeClass[] nodeClassArray = new NodeClass[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nodeClassArray[i] = NodeClass.valueOf(nArray[i]);
        }
        return nodeClassArray;
    }

    public static NodeClass[] valueOf(Integer[] integerArray) {
        NodeClass[] nodeClassArray = new NodeClass[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            nodeClassArray[i] = NodeClass.valueOf(integerArray[i]);
        }
        return nodeClassArray;
    }

    public static NodeClass[] valueOf(UnsignedInteger[] unsignedIntegerArray) {
        NodeClass[] nodeClassArray = new NodeClass[unsignedIntegerArray.length];
        for (int i = 0; i < unsignedIntegerArray.length; ++i) {
            nodeClassArray[i] = NodeClass.valueOf(unsignedIntegerArray[i]);
        }
        return nodeClassArray;
    }

    public static UnsignedInteger getMask(NodeClass ... nodeClassArray) {
        int n = 0;
        for (NodeClass nodeClass : nodeClassArray) {
            n |= nodeClass.value;
        }
        return UnsignedInteger.getFromBits(n);
    }

    public static UnsignedInteger getMask(Collection<NodeClass> collection) {
        int n = 0;
        for (NodeClass nodeClass : collection) {
            n |= nodeClass.value;
        }
        return UnsignedInteger.getFromBits(n);
    }

    public static EnumSet<NodeClass> getSet(UnsignedInteger unsignedInteger) {
        return NodeClass.getSet(unsignedInteger.intValue());
    }

    public static EnumSet<NodeClass> getSet(int n) {
        ArrayList<NodeClass> arrayList = new ArrayList<NodeClass>();
        for (NodeClass nodeClass : NodeClass.values()) {
            if ((n & nodeClass.value) != nodeClass.value) continue;
            arrayList.add(nodeClass);
        }
        return EnumSet.copyOf(arrayList);
    }

    static {
        ID = Identifiers.NodeClass;
        NONE = EnumSet.noneOf(NodeClass.class);
        ALL = EnumSet.allOf(NodeClass.class);
        map = new HashMap<Integer, NodeClass>();
        for (NodeClass nodeClass : NodeClass.values()) {
            map.put(nodeClass.value, nodeClass);
        }
    }
}

