/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.opcfoundation.ua.builtintypes.Enumeration;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Identifiers;

public enum NodeAttributesMask implements Enumeration
{
    None(0),
    AccessLevel(1),
    ArrayDimensions(2),
    BrowseName(4),
    ContainsNoLoops(8),
    DataType(16),
    Description(32),
    DisplayName(64),
    EventNotifier(128),
    Executable(256),
    Historizing(512),
    InverseName(1024),
    IsAbstract(2048),
    MinimumSamplingInterval(4096),
    NodeClass(8192),
    NodeId(16384),
    Symmetric(32768),
    UserAccessLevel(65536),
    UserExecutable(131072),
    UserWriteMask(262144),
    ValueRank(524288),
    WriteMask(0x100000),
    Value(0x200000),
    All(0x3FFFFF),
    BaseNode(1335396),
    Object(1335524),
    ObjectTypeOrDataType(1337444),
    Variable(4026999),
    VariableType(3958902),
    Method(0x166164),
    ReferenceType(1371236),
    View(1335532);

    public static final NodeId ID;
    public static EnumSet<NodeAttributesMask> NONE;
    public static EnumSet<NodeAttributesMask> ALL;
    private final int value;
    private static final Map<Integer, NodeAttributesMask> map;

    private NodeAttributesMask(int n2) {
        this.value = n2;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static NodeAttributesMask valueOf(int n) {
        return map.get(n);
    }

    public static NodeAttributesMask valueOf(Integer n) {
        return n == null ? null : NodeAttributesMask.valueOf((int)n);
    }

    public static NodeAttributesMask valueOf(UnsignedInteger unsignedInteger) {
        return unsignedInteger == null ? null : NodeAttributesMask.valueOf(unsignedInteger.intValue());
    }

    public static NodeAttributesMask[] valueOf(int[] nArray) {
        NodeAttributesMask[] nodeAttributesMaskArray = new NodeAttributesMask[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nodeAttributesMaskArray[i] = NodeAttributesMask.valueOf(nArray[i]);
        }
        return nodeAttributesMaskArray;
    }

    public static NodeAttributesMask[] valueOf(Integer[] integerArray) {
        NodeAttributesMask[] nodeAttributesMaskArray = new NodeAttributesMask[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            nodeAttributesMaskArray[i] = NodeAttributesMask.valueOf(integerArray[i]);
        }
        return nodeAttributesMaskArray;
    }

    public static NodeAttributesMask[] valueOf(UnsignedInteger[] unsignedIntegerArray) {
        NodeAttributesMask[] nodeAttributesMaskArray = new NodeAttributesMask[unsignedIntegerArray.length];
        for (int i = 0; i < unsignedIntegerArray.length; ++i) {
            nodeAttributesMaskArray[i] = NodeAttributesMask.valueOf(unsignedIntegerArray[i]);
        }
        return nodeAttributesMaskArray;
    }

    public static UnsignedInteger getMask(NodeAttributesMask ... nodeAttributesMaskArray) {
        int n = 0;
        for (NodeAttributesMask nodeAttributesMask : nodeAttributesMaskArray) {
            n |= nodeAttributesMask.value;
        }
        return UnsignedInteger.getFromBits(n);
    }

    public static UnsignedInteger getMask(Collection<NodeAttributesMask> collection) {
        int n = 0;
        for (NodeAttributesMask nodeAttributesMask : collection) {
            n |= nodeAttributesMask.value;
        }
        return UnsignedInteger.getFromBits(n);
    }

    public static EnumSet<NodeAttributesMask> getSet(UnsignedInteger unsignedInteger) {
        return NodeAttributesMask.getSet(unsignedInteger.intValue());
    }

    public static EnumSet<NodeAttributesMask> getSet(int n) {
        ArrayList<NodeAttributesMask> arrayList = new ArrayList<NodeAttributesMask>();
        for (NodeAttributesMask nodeAttributesMask : NodeAttributesMask.values()) {
            if ((n & nodeAttributesMask.value) != nodeAttributesMask.value) continue;
            arrayList.add(nodeAttributesMask);
        }
        return EnumSet.copyOf(arrayList);
    }

    static {
        ID = Identifiers.NodeAttributesMask;
        NONE = EnumSet.noneOf(NodeAttributesMask.class);
        ALL = EnumSet.allOf(NodeAttributesMask.class);
        map = new HashMap<Integer, NodeAttributesMask>();
        for (NodeAttributesMask nodeAttributesMask : NodeAttributesMask.values()) {
            map.put(nodeAttributesMask.value, nodeAttributesMask);
        }
    }
}

