/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.core.EndpointUrlListDataType;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.utils.ObjectUtils;

public class NetworkGroupDataType
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.NetworkGroupDataType);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.NetworkGroupDataType_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.NetworkGroupDataType_Encoding_DefaultXml);
    protected String ServerUri;
    protected EndpointUrlListDataType[] NetworkPaths;

    public NetworkGroupDataType() {
    }

    public NetworkGroupDataType(String string, EndpointUrlListDataType[] endpointUrlListDataTypeArray) {
        this.ServerUri = string;
        this.NetworkPaths = endpointUrlListDataTypeArray;
    }

    public String getServerUri() {
        return this.ServerUri;
    }

    public void setServerUri(String string) {
        this.ServerUri = string;
    }

    public EndpointUrlListDataType[] getNetworkPaths() {
        return this.NetworkPaths;
    }

    public void setNetworkPaths(EndpointUrlListDataType[] endpointUrlListDataTypeArray) {
        this.NetworkPaths = endpointUrlListDataTypeArray;
    }

    public NetworkGroupDataType clone() {
        NetworkGroupDataType networkGroupDataType = new NetworkGroupDataType();
        networkGroupDataType.ServerUri = this.ServerUri;
        if (this.NetworkPaths != null) {
            networkGroupDataType.NetworkPaths = new EndpointUrlListDataType[this.NetworkPaths.length];
            for (int i = 0; i < this.NetworkPaths.length; ++i) {
                networkGroupDataType.NetworkPaths[i] = this.NetworkPaths[i].clone();
            }
        }
        return networkGroupDataType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NetworkGroupDataType networkGroupDataType = (NetworkGroupDataType)object;
        if (this.ServerUri == null ? networkGroupDataType.ServerUri != null : !this.ServerUri.equals(networkGroupDataType.ServerUri)) {
            return false;
        }
        return !(this.NetworkPaths == null ? networkGroupDataType.NetworkPaths != null : !Arrays.equals(this.NetworkPaths, networkGroupDataType.NetworkPaths));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.ServerUri == null ? 0 : this.ServerUri.hashCode());
        n = 31 * n + (this.NetworkPaths == null ? 0 : Arrays.hashCode(this.NetworkPaths));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return "NetworkGroupDataType: " + ObjectUtils.printFieldsDeep(this);
    }
}

