/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.InstanceNode;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.ReferenceNode;
import org.opcfoundation.ua.utils.ObjectUtils;

public class MethodNode
extends InstanceNode
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.MethodNode);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.MethodNode_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.MethodNode_Encoding_DefaultXml);
    protected Boolean Executable;
    protected Boolean UserExecutable;

    public MethodNode() {
    }

    public MethodNode(NodeId nodeId, NodeClass nodeClass, QualifiedName qualifiedName, LocalizedText localizedText, LocalizedText localizedText2, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, ReferenceNode[] referenceNodeArray, Boolean bl, Boolean bl2) {
        super(nodeId, nodeClass, qualifiedName, localizedText, localizedText2, unsignedInteger, unsignedInteger2, referenceNodeArray);
        this.Executable = bl;
        this.UserExecutable = bl2;
    }

    public Boolean getExecutable() {
        return this.Executable;
    }

    public void setExecutable(Boolean bl) {
        this.Executable = bl;
    }

    public Boolean getUserExecutable() {
        return this.UserExecutable;
    }

    public void setUserExecutable(Boolean bl) {
        this.UserExecutable = bl;
    }

    @Override
    public MethodNode clone() {
        MethodNode methodNode = new MethodNode();
        methodNode.NodeId = this.NodeId;
        methodNode.NodeClass = this.NodeClass;
        methodNode.BrowseName = this.BrowseName;
        methodNode.DisplayName = this.DisplayName;
        methodNode.Description = this.Description;
        methodNode.WriteMask = this.WriteMask;
        methodNode.UserWriteMask = this.UserWriteMask;
        if (this.References != null) {
            methodNode.References = new ReferenceNode[this.References.length];
            for (int i = 0; i < this.References.length; ++i) {
                methodNode.References[i] = this.References[i].clone();
            }
        }
        methodNode.Executable = this.Executable;
        methodNode.UserExecutable = this.UserExecutable;
        return methodNode;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MethodNode methodNode = (MethodNode)object;
        if (this.NodeId == null ? methodNode.NodeId != null : !this.NodeId.equals(methodNode.NodeId)) {
            return false;
        }
        if (this.NodeClass == null ? methodNode.NodeClass != null : !this.NodeClass.equals(methodNode.NodeClass)) {
            return false;
        }
        if (this.BrowseName == null ? methodNode.BrowseName != null : !this.BrowseName.equals(methodNode.BrowseName)) {
            return false;
        }
        if (this.DisplayName == null ? methodNode.DisplayName != null : !this.DisplayName.equals(methodNode.DisplayName)) {
            return false;
        }
        if (this.Description == null ? methodNode.Description != null : !this.Description.equals(methodNode.Description)) {
            return false;
        }
        if (this.WriteMask == null ? methodNode.WriteMask != null : !this.WriteMask.equals(methodNode.WriteMask)) {
            return false;
        }
        if (this.UserWriteMask == null ? methodNode.UserWriteMask != null : !this.UserWriteMask.equals(methodNode.UserWriteMask)) {
            return false;
        }
        if (this.References == null ? methodNode.References != null : !Arrays.equals(this.References, methodNode.References)) {
            return false;
        }
        if (this.Executable == null ? methodNode.Executable != null : !this.Executable.equals(methodNode.Executable)) {
            return false;
        }
        return !(this.UserExecutable == null ? methodNode.UserExecutable != null : !this.UserExecutable.equals(methodNode.UserExecutable));
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.NodeId == null ? 0 : this.NodeId.hashCode());
        n = 31 * n + (this.NodeClass == null ? 0 : this.NodeClass.hashCode());
        n = 31 * n + (this.BrowseName == null ? 0 : this.BrowseName.hashCode());
        n = 31 * n + (this.DisplayName == null ? 0 : this.DisplayName.hashCode());
        n = 31 * n + (this.Description == null ? 0 : this.Description.hashCode());
        n = 31 * n + (this.WriteMask == null ? 0 : this.WriteMask.hashCode());
        n = 31 * n + (this.UserWriteMask == null ? 0 : this.UserWriteMask.hashCode());
        n = 31 * n + (this.References == null ? 0 : Arrays.hashCode(this.References));
        n = 31 * n + (this.Executable == null ? 0 : this.Executable.hashCode());
        n = 31 * n + (this.UserExecutable == null ? 0 : this.UserExecutable.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    public String toString() {
        return "MethodNode: " + ObjectUtils.printFieldsDeep(this);
    }
}

