/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.ServiceResult;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.utils.NumericRange;
import org.opcfoundation.ua.utils.ObjectUtils;

public class HistoryReadValueId
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.HistoryReadValueId);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.HistoryReadValueId_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.HistoryReadValueId_Encoding_DefaultXml);
    NumericRange ParsedIndexRange;
    protected NodeId NodeId;
    protected String IndexRange;
    protected QualifiedName DataEncoding;
    protected byte[] ContinuationPoint;

    public HistoryReadValueId() {
    }

    public HistoryReadValueId(NodeId nodeId, String string, QualifiedName qualifiedName, byte[] byArray) {
        this.NodeId = nodeId;
        this.IndexRange = string;
        this.DataEncoding = qualifiedName;
        this.ContinuationPoint = byArray;
    }

    public NodeId getNodeId() {
        return this.NodeId;
    }

    public void setNodeId(NodeId nodeId) {
        this.NodeId = nodeId;
    }

    public String getIndexRange() {
        return this.IndexRange;
    }

    public void setIndexRange(String string) {
        this.IndexRange = string;
    }

    public QualifiedName getDataEncoding() {
        return this.DataEncoding;
    }

    public void setDataEncoding(QualifiedName qualifiedName) {
        this.DataEncoding = qualifiedName;
    }

    public byte[] getContinuationPoint() {
        return this.ContinuationPoint;
    }

    public void setContinuationPoint(byte[] byArray) {
        this.ContinuationPoint = byArray;
    }

    public HistoryReadValueId clone() {
        HistoryReadValueId historyReadValueId = new HistoryReadValueId();
        historyReadValueId.NodeId = this.NodeId;
        historyReadValueId.IndexRange = this.IndexRange;
        historyReadValueId.DataEncoding = this.DataEncoding;
        historyReadValueId.ContinuationPoint = this.ContinuationPoint;
        return historyReadValueId;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HistoryReadValueId historyReadValueId = (HistoryReadValueId)object;
        if (this.NodeId == null ? historyReadValueId.NodeId != null : !this.NodeId.equals(historyReadValueId.NodeId)) {
            return false;
        }
        if (this.IndexRange == null ? historyReadValueId.IndexRange != null : !this.IndexRange.equals(historyReadValueId.IndexRange)) {
            return false;
        }
        if (this.DataEncoding == null ? historyReadValueId.DataEncoding != null : !this.DataEncoding.equals(historyReadValueId.DataEncoding)) {
            return false;
        }
        return !(this.ContinuationPoint == null ? historyReadValueId.ContinuationPoint != null : !this.ContinuationPoint.equals(historyReadValueId.ContinuationPoint));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.NodeId == null ? 0 : this.NodeId.hashCode());
        n = 31 * n + (this.IndexRange == null ? 0 : this.IndexRange.hashCode());
        n = 31 * n + (this.DataEncoding == null ? 0 : this.DataEncoding.hashCode());
        n = 31 * n + (this.ContinuationPoint == null ? 0 : this.ContinuationPoint.hashCode());
        return n;
    }

    public static ServiceResult validate(HistoryReadValueId historyReadValueId) {
        if (historyReadValueId == null) {
            return new ServiceResult(StatusCodes.Bad_StructureMissing);
        }
        if (historyReadValueId.getNodeId() == null) {
            return new ServiceResult(StatusCodes.Bad_NodeIdInvalid);
        }
        NumericRange numericRange = NumericRange.getEmpty();
        if (historyReadValueId.getIndexRange() != null && !historyReadValueId.getIndexRange().isEmpty()) {
            try {
                numericRange = NumericRange.parse(historyReadValueId.getIndexRange());
                historyReadValueId.setParsedIndexRange(numericRange);
            }
            catch (Exception exception) {
                return new ServiceResult(StatusCodes.Bad_IndexRangeInvalid, (Throwable)exception);
            }
        } else {
            historyReadValueId.setParsedIndexRange(NumericRange.getEmpty());
        }
        return null;
    }

    public NumericRange getParsedIndexRange() {
        return this.ParsedIndexRange;
    }

    public void setParsedIndexRange(NumericRange numericRange) {
        this.ParsedIndexRange = numericRange;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return "HistoryReadValueId: " + ObjectUtils.printFieldsDeep(this);
    }
}

