/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ExtensionObject;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.core.HistoryReadValueId;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.RequestHeader;
import org.opcfoundation.ua.core.TimestampsToReturn;
import org.opcfoundation.ua.utils.ObjectUtils;

public class HistoryReadRequest
implements ServiceRequest {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.HistoryReadRequest);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.HistoryReadRequest_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.HistoryReadRequest_Encoding_DefaultXml);
    protected RequestHeader RequestHeader;
    protected ExtensionObject HistoryReadDetails;
    protected TimestampsToReturn TimestampsToReturn;
    protected Boolean ReleaseContinuationPoints;
    protected HistoryReadValueId[] NodesToRead;

    public HistoryReadRequest() {
    }

    public HistoryReadRequest(RequestHeader requestHeader, ExtensionObject extensionObject, TimestampsToReturn timestampsToReturn, Boolean bl, HistoryReadValueId[] historyReadValueIdArray) {
        this.RequestHeader = requestHeader;
        this.HistoryReadDetails = extensionObject;
        this.TimestampsToReturn = timestampsToReturn;
        this.ReleaseContinuationPoints = bl;
        this.NodesToRead = historyReadValueIdArray;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.RequestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.RequestHeader = requestHeader;
    }

    public ExtensionObject getHistoryReadDetails() {
        return this.HistoryReadDetails;
    }

    public void setHistoryReadDetails(ExtensionObject extensionObject) {
        this.HistoryReadDetails = extensionObject;
    }

    public TimestampsToReturn getTimestampsToReturn() {
        return this.TimestampsToReturn;
    }

    public void setTimestampsToReturn(TimestampsToReturn timestampsToReturn) {
        this.TimestampsToReturn = timestampsToReturn;
    }

    public Boolean getReleaseContinuationPoints() {
        return this.ReleaseContinuationPoints;
    }

    public void setReleaseContinuationPoints(Boolean bl) {
        this.ReleaseContinuationPoints = bl;
    }

    public HistoryReadValueId[] getNodesToRead() {
        return this.NodesToRead;
    }

    public void setNodesToRead(HistoryReadValueId[] historyReadValueIdArray) {
        this.NodesToRead = historyReadValueIdArray;
    }

    public HistoryReadRequest clone() {
        HistoryReadRequest historyReadRequest = new HistoryReadRequest();
        historyReadRequest.RequestHeader = this.RequestHeader == null ? null : this.RequestHeader.clone();
        historyReadRequest.HistoryReadDetails = this.HistoryReadDetails;
        historyReadRequest.TimestampsToReturn = this.TimestampsToReturn;
        historyReadRequest.ReleaseContinuationPoints = this.ReleaseContinuationPoints;
        if (this.NodesToRead != null) {
            historyReadRequest.NodesToRead = new HistoryReadValueId[this.NodesToRead.length];
            for (int i = 0; i < this.NodesToRead.length; ++i) {
                historyReadRequest.NodesToRead[i] = this.NodesToRead[i].clone();
            }
        }
        return historyReadRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HistoryReadRequest historyReadRequest = (HistoryReadRequest)object;
        if (this.RequestHeader == null ? historyReadRequest.RequestHeader != null : !this.RequestHeader.equals(historyReadRequest.RequestHeader)) {
            return false;
        }
        if (this.HistoryReadDetails == null ? historyReadRequest.HistoryReadDetails != null : !this.HistoryReadDetails.equals(historyReadRequest.HistoryReadDetails)) {
            return false;
        }
        if (this.TimestampsToReturn == null ? historyReadRequest.TimestampsToReturn != null : !this.TimestampsToReturn.equals(historyReadRequest.TimestampsToReturn)) {
            return false;
        }
        if (this.ReleaseContinuationPoints == null ? historyReadRequest.ReleaseContinuationPoints != null : !this.ReleaseContinuationPoints.equals(historyReadRequest.ReleaseContinuationPoints)) {
            return false;
        }
        return !(this.NodesToRead == null ? historyReadRequest.NodesToRead != null : !Arrays.equals(this.NodesToRead, historyReadRequest.NodesToRead));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.RequestHeader == null ? 0 : this.RequestHeader.hashCode());
        n = 31 * n + (this.HistoryReadDetails == null ? 0 : this.HistoryReadDetails.hashCode());
        n = 31 * n + (this.TimestampsToReturn == null ? 0 : this.TimestampsToReturn.hashCode());
        n = 31 * n + (this.ReleaseContinuationPoints == null ? 0 : this.ReleaseContinuationPoints.hashCode());
        n = 31 * n + (this.NodesToRead == null ? 0 : Arrays.hashCode(this.NodesToRead));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return ObjectUtils.printFieldsDeep(this);
    }
}

