/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.core.EventFieldList;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NotificationData;
import org.opcfoundation.ua.utils.ObjectUtils;

public class EventNotificationList
extends NotificationData
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.EventNotificationList);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.EventNotificationList_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.EventNotificationList_Encoding_DefaultXml);
    protected EventFieldList[] Events;

    public EventNotificationList() {
    }

    public EventNotificationList(EventFieldList[] eventFieldListArray) {
        this.Events = eventFieldListArray;
    }

    public EventFieldList[] getEvents() {
        return this.Events;
    }

    public void setEvents(EventFieldList[] eventFieldListArray) {
        this.Events = eventFieldListArray;
    }

    @Override
    public EventNotificationList clone() {
        EventNotificationList eventNotificationList = new EventNotificationList();
        if (this.Events != null) {
            eventNotificationList.Events = new EventFieldList[this.Events.length];
            for (int i = 0; i < this.Events.length; ++i) {
                eventNotificationList.Events[i] = this.Events[i].clone();
            }
        }
        return eventNotificationList;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EventNotificationList eventNotificationList = (EventNotificationList)object;
        return !(this.Events == null ? eventNotificationList.Events != null : !Arrays.equals(this.Events, eventNotificationList.Events));
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.Events == null ? 0 : Arrays.hashCode(this.Events));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    public String toString() {
        return "EventNotificationList: " + ObjectUtils.printFieldsDeep(this);
    }
}

