/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.core.ContentFilterResult;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.MonitoringFilterResult;
import org.opcfoundation.ua.utils.ObjectUtils;

public class EventFilterResult
extends MonitoringFilterResult
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.EventFilterResult);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.EventFilterResult_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.EventFilterResult_Encoding_DefaultXml);
    protected StatusCode[] SelectClauseResults;
    protected DiagnosticInfo[] SelectClauseDiagnosticInfos;
    protected ContentFilterResult WhereClauseResult;

    public EventFilterResult() {
    }

    public EventFilterResult(StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray, ContentFilterResult contentFilterResult) {
        this.SelectClauseResults = statusCodeArray;
        this.SelectClauseDiagnosticInfos = diagnosticInfoArray;
        this.WhereClauseResult = contentFilterResult;
    }

    public StatusCode[] getSelectClauseResults() {
        return this.SelectClauseResults;
    }

    public void setSelectClauseResults(StatusCode[] statusCodeArray) {
        this.SelectClauseResults = statusCodeArray;
    }

    public DiagnosticInfo[] getSelectClauseDiagnosticInfos() {
        return this.SelectClauseDiagnosticInfos;
    }

    public void setSelectClauseDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
        this.SelectClauseDiagnosticInfos = diagnosticInfoArray;
    }

    public ContentFilterResult getWhereClauseResult() {
        return this.WhereClauseResult;
    }

    public void setWhereClauseResult(ContentFilterResult contentFilterResult) {
        this.WhereClauseResult = contentFilterResult;
    }

    @Override
    public EventFilterResult clone() {
        EventFilterResult eventFilterResult = new EventFilterResult();
        eventFilterResult.SelectClauseResults = this.SelectClauseResults == null ? null : (StatusCode[])this.SelectClauseResults.clone();
        eventFilterResult.SelectClauseDiagnosticInfos = this.SelectClauseDiagnosticInfos == null ? null : (DiagnosticInfo[])this.SelectClauseDiagnosticInfos.clone();
        eventFilterResult.WhereClauseResult = this.WhereClauseResult == null ? null : this.WhereClauseResult.clone();
        return eventFilterResult;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EventFilterResult eventFilterResult = (EventFilterResult)object;
        if (this.SelectClauseResults == null ? eventFilterResult.SelectClauseResults != null : !Arrays.equals(this.SelectClauseResults, eventFilterResult.SelectClauseResults)) {
            return false;
        }
        if (this.SelectClauseDiagnosticInfos == null ? eventFilterResult.SelectClauseDiagnosticInfos != null : !Arrays.equals(this.SelectClauseDiagnosticInfos, eventFilterResult.SelectClauseDiagnosticInfos)) {
            return false;
        }
        return !(this.WhereClauseResult == null ? eventFilterResult.WhereClauseResult != null : !this.WhereClauseResult.equals(eventFilterResult.WhereClauseResult));
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.SelectClauseResults == null ? 0 : Arrays.hashCode(this.SelectClauseResults));
        n = 31 * n + (this.SelectClauseDiagnosticInfos == null ? 0 : Arrays.hashCode(this.SelectClauseDiagnosticInfos));
        n = 31 * n + (this.WhereClauseResult == null ? 0 : this.WhereClauseResult.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    public String toString() {
        return "EventFilterResult: " + ObjectUtils.printFieldsDeep(this);
    }
}

