/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.ApplicationDescription;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.MessageSecurityMode;
import org.opcfoundation.ua.core.UserTokenPolicy;
import org.opcfoundation.ua.core.UserTokenType;
import org.opcfoundation.ua.transport.security.SecurityPolicy;
import org.opcfoundation.ua.utils.EndpointUtil;
import org.opcfoundation.ua.utils.ObjectUtils;

public class EndpointDescription
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.EndpointDescription);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.EndpointDescription_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.EndpointDescription_Encoding_DefaultXml);
    protected String EndpointUrl;
    protected ApplicationDescription Server;
    protected byte[] ServerCertificate;
    protected MessageSecurityMode SecurityMode;
    protected String SecurityPolicyUri;
    protected UserTokenPolicy[] UserIdentityTokens;
    protected String TransportProfileUri;
    protected UnsignedByte SecurityLevel;

    public EndpointDescription() {
    }

    public EndpointDescription(String string, ApplicationDescription applicationDescription, byte[] byArray, MessageSecurityMode messageSecurityMode, String string2, UserTokenPolicy[] userTokenPolicyArray, String string3, UnsignedByte unsignedByte) {
        this.EndpointUrl = string;
        this.Server = applicationDescription;
        this.ServerCertificate = byArray;
        this.SecurityMode = messageSecurityMode;
        this.SecurityPolicyUri = string2;
        this.UserIdentityTokens = userTokenPolicyArray;
        this.TransportProfileUri = string3;
        this.SecurityLevel = unsignedByte;
    }

    public String getEndpointUrl() {
        return this.EndpointUrl;
    }

    public void setEndpointUrl(String string) {
        this.EndpointUrl = string;
    }

    public ApplicationDescription getServer() {
        return this.Server;
    }

    public void setServer(ApplicationDescription applicationDescription) {
        this.Server = applicationDescription;
    }

    public byte[] getServerCertificate() {
        return this.ServerCertificate;
    }

    public void setServerCertificate(byte[] byArray) {
        this.ServerCertificate = byArray;
    }

    public MessageSecurityMode getSecurityMode() {
        return this.SecurityMode;
    }

    public void setSecurityMode(MessageSecurityMode messageSecurityMode) {
        this.SecurityMode = messageSecurityMode;
    }

    public String getSecurityPolicyUri() {
        return this.SecurityPolicyUri;
    }

    public void setSecurityPolicyUri(String string) {
        this.SecurityPolicyUri = string;
    }

    public UserTokenPolicy[] getUserIdentityTokens() {
        return this.UserIdentityTokens;
    }

    public void setUserIdentityTokens(UserTokenPolicy[] userTokenPolicyArray) {
        this.UserIdentityTokens = userTokenPolicyArray;
    }

    public String getTransportProfileUri() {
        return this.TransportProfileUri;
    }

    public void setTransportProfileUri(String string) {
        this.TransportProfileUri = string;
    }

    public UnsignedByte getSecurityLevel() {
        return this.SecurityLevel;
    }

    public void setSecurityLevel(UnsignedByte unsignedByte) {
        this.SecurityLevel = unsignedByte;
    }

    public EndpointDescription clone() {
        EndpointDescription endpointDescription = new EndpointDescription();
        endpointDescription.EndpointUrl = this.EndpointUrl;
        endpointDescription.Server = this.Server == null ? null : this.Server.clone();
        endpointDescription.ServerCertificate = this.ServerCertificate;
        endpointDescription.SecurityMode = this.SecurityMode;
        endpointDescription.SecurityPolicyUri = this.SecurityPolicyUri;
        if (this.UserIdentityTokens != null) {
            endpointDescription.UserIdentityTokens = new UserTokenPolicy[this.UserIdentityTokens.length];
            for (int i = 0; i < this.UserIdentityTokens.length; ++i) {
                endpointDescription.UserIdentityTokens[i] = this.UserIdentityTokens[i].clone();
            }
        }
        endpointDescription.TransportProfileUri = this.TransportProfileUri;
        endpointDescription.SecurityLevel = this.SecurityLevel;
        return endpointDescription;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EndpointDescription endpointDescription = (EndpointDescription)object;
        if (this.EndpointUrl == null ? endpointDescription.EndpointUrl != null : !this.EndpointUrl.equals(endpointDescription.EndpointUrl)) {
            return false;
        }
        if (this.Server == null ? endpointDescription.Server != null : !this.Server.equals(endpointDescription.Server)) {
            return false;
        }
        if (this.ServerCertificate == null ? endpointDescription.ServerCertificate != null : !this.ServerCertificate.equals(endpointDescription.ServerCertificate)) {
            return false;
        }
        if (this.SecurityMode == null ? endpointDescription.SecurityMode != null : !this.SecurityMode.equals(endpointDescription.SecurityMode)) {
            return false;
        }
        if (this.SecurityPolicyUri == null ? endpointDescription.SecurityPolicyUri != null : !this.SecurityPolicyUri.equals(endpointDescription.SecurityPolicyUri)) {
            return false;
        }
        if (this.UserIdentityTokens == null ? endpointDescription.UserIdentityTokens != null : !Arrays.equals(this.UserIdentityTokens, endpointDescription.UserIdentityTokens)) {
            return false;
        }
        if (this.TransportProfileUri == null ? endpointDescription.TransportProfileUri != null : !this.TransportProfileUri.equals(endpointDescription.TransportProfileUri)) {
            return false;
        }
        return !(this.SecurityLevel == null ? endpointDescription.SecurityLevel != null : !this.SecurityLevel.equals(endpointDescription.SecurityLevel));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.EndpointUrl == null ? 0 : this.EndpointUrl.hashCode());
        n = 31 * n + (this.Server == null ? 0 : this.Server.hashCode());
        n = 31 * n + (this.ServerCertificate == null ? 0 : this.ServerCertificate.hashCode());
        n = 31 * n + (this.SecurityMode == null ? 0 : this.SecurityMode.hashCode());
        n = 31 * n + (this.SecurityPolicyUri == null ? 0 : this.SecurityPolicyUri.hashCode());
        n = 31 * n + (this.UserIdentityTokens == null ? 0 : Arrays.hashCode(this.UserIdentityTokens));
        n = 31 * n + (this.TransportProfileUri == null ? 0 : this.TransportProfileUri.hashCode());
        n = 31 * n + (this.SecurityLevel == null ? 0 : this.SecurityLevel.hashCode());
        return n;
    }

    public boolean supportsUserTokenType(EndpointDescription endpointDescription, UserTokenType userTokenType) {
        return this.findUserTokenPolicy(userTokenType) != null;
    }

    public UserTokenPolicy findUserTokenPolicy(UserTokenType userTokenType) {
        if (this.UserIdentityTokens == null) {
            return null;
        }
        for (UserTokenPolicy userTokenPolicy : this.UserIdentityTokens) {
            try {
                String string = userTokenPolicy.getSecurityPolicyUri();
                SecurityPolicy.getSecurityPolicy(string);
            }
            catch (ServiceResultException serviceResultException) {
                continue;
            }
            if (userTokenPolicy.getTokenType() != userTokenType) continue;
            return userTokenPolicy;
        }
        return null;
    }

    public UserTokenPolicy findUserTokenPolicy(String string) {
        if (this.UserIdentityTokens == null) {
            return null;
        }
        for (UserTokenPolicy userTokenPolicy : this.UserIdentityTokens) {
            String string2;
            if (userTokenPolicy == null || (string2 = userTokenPolicy.getPolicyId()) == null || !string2.equals(string)) continue;
            return userTokenPolicy;
        }
        return null;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return "EndpointDescription: " + ObjectUtils.printFieldsDeep(this);
    }

    public boolean needsCertificate() {
        return this.getSecurityMode().hasSigning() || EndpointUtil.containsSecureUserTokenPolicy(this.getUserIdentityTokens());
    }
}

