/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.utils.ObjectUtils;

public class EndpointConfiguration
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.EndpointConfiguration);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.EndpointConfiguration_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.EndpointConfiguration_Encoding_DefaultXml);
    protected Integer OperationTimeout;
    protected Boolean UseBinaryEncoding;
    protected Integer MaxStringLength;
    protected Integer MaxByteStringLength;
    protected Integer MaxArrayLength;
    protected Integer MaxMessageSize;
    protected Integer MaxBufferSize;
    protected Integer ChannelLifetime;
    protected Integer SecurityTokenLifetime;

    public static EndpointConfiguration defaults() {
        EndpointConfiguration endpointConfiguration = new EndpointConfiguration();
        endpointConfiguration.OperationTimeout = 120000;
        endpointConfiguration.UseBinaryEncoding = true;
        endpointConfiguration.MaxArrayLength = UnsignedShort.MAX_VALUE.intValue();
        endpointConfiguration.MaxByteStringLength = UnsignedShort.MAX_VALUE.intValue() * 16;
        endpointConfiguration.MaxMessageSize = UnsignedShort.MAX_VALUE.intValue() * 64;
        endpointConfiguration.MaxStringLength = UnsignedShort.MAX_VALUE.intValue();
        endpointConfiguration.MaxBufferSize = UnsignedShort.MAX_VALUE.intValue();
        endpointConfiguration.ChannelLifetime = 120000;
        endpointConfiguration.SecurityTokenLifetime = 3600000;
        return endpointConfiguration;
    }

    public EndpointConfiguration() {
    }

    public EndpointConfiguration(Integer n, Boolean bl, Integer n2, Integer n3, Integer n4, Integer n5, Integer n6, Integer n7, Integer n8) {
        this.OperationTimeout = n;
        this.UseBinaryEncoding = bl;
        this.MaxStringLength = n2;
        this.MaxByteStringLength = n3;
        this.MaxArrayLength = n4;
        this.MaxMessageSize = n5;
        this.MaxBufferSize = n6;
        this.ChannelLifetime = n7;
        this.SecurityTokenLifetime = n8;
    }

    public Integer getOperationTimeout() {
        return this.OperationTimeout;
    }

    public void setOperationTimeout(Integer n) {
        this.OperationTimeout = n;
    }

    public Boolean getUseBinaryEncoding() {
        return this.UseBinaryEncoding;
    }

    public void setUseBinaryEncoding(Boolean bl) {
        this.UseBinaryEncoding = bl;
    }

    public Integer getMaxStringLength() {
        return this.MaxStringLength;
    }

    public void setMaxStringLength(Integer n) {
        this.MaxStringLength = n;
    }

    public Integer getMaxByteStringLength() {
        return this.MaxByteStringLength;
    }

    public void setMaxByteStringLength(Integer n) {
        this.MaxByteStringLength = n;
    }

    public Integer getMaxArrayLength() {
        return this.MaxArrayLength;
    }

    public void setMaxArrayLength(Integer n) {
        this.MaxArrayLength = n;
    }

    public Integer getMaxMessageSize() {
        return this.MaxMessageSize;
    }

    public void setMaxMessageSize(Integer n) {
        this.MaxMessageSize = n;
    }

    public Integer getMaxBufferSize() {
        return this.MaxBufferSize;
    }

    public void setMaxBufferSize(Integer n) {
        this.MaxBufferSize = n;
    }

    public Integer getChannelLifetime() {
        return this.ChannelLifetime;
    }

    public void setChannelLifetime(Integer n) {
        this.ChannelLifetime = n;
    }

    public Integer getSecurityTokenLifetime() {
        return this.SecurityTokenLifetime;
    }

    public void setSecurityTokenLifetime(Integer n) {
        this.SecurityTokenLifetime = n;
    }

    public EndpointConfiguration clone() {
        EndpointConfiguration endpointConfiguration = new EndpointConfiguration();
        endpointConfiguration.OperationTimeout = this.OperationTimeout;
        endpointConfiguration.UseBinaryEncoding = this.UseBinaryEncoding;
        endpointConfiguration.MaxStringLength = this.MaxStringLength;
        endpointConfiguration.MaxByteStringLength = this.MaxByteStringLength;
        endpointConfiguration.MaxArrayLength = this.MaxArrayLength;
        endpointConfiguration.MaxMessageSize = this.MaxMessageSize;
        endpointConfiguration.MaxBufferSize = this.MaxBufferSize;
        endpointConfiguration.ChannelLifetime = this.ChannelLifetime;
        endpointConfiguration.SecurityTokenLifetime = this.SecurityTokenLifetime;
        return endpointConfiguration;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EndpointConfiguration endpointConfiguration = (EndpointConfiguration)object;
        if (this.OperationTimeout == null ? endpointConfiguration.OperationTimeout != null : !this.OperationTimeout.equals(endpointConfiguration.OperationTimeout)) {
            return false;
        }
        if (this.UseBinaryEncoding == null ? endpointConfiguration.UseBinaryEncoding != null : !this.UseBinaryEncoding.equals(endpointConfiguration.UseBinaryEncoding)) {
            return false;
        }
        if (this.MaxStringLength == null ? endpointConfiguration.MaxStringLength != null : !this.MaxStringLength.equals(endpointConfiguration.MaxStringLength)) {
            return false;
        }
        if (this.MaxByteStringLength == null ? endpointConfiguration.MaxByteStringLength != null : !this.MaxByteStringLength.equals(endpointConfiguration.MaxByteStringLength)) {
            return false;
        }
        if (this.MaxArrayLength == null ? endpointConfiguration.MaxArrayLength != null : !this.MaxArrayLength.equals(endpointConfiguration.MaxArrayLength)) {
            return false;
        }
        if (this.MaxMessageSize == null ? endpointConfiguration.MaxMessageSize != null : !this.MaxMessageSize.equals(endpointConfiguration.MaxMessageSize)) {
            return false;
        }
        if (this.MaxBufferSize == null ? endpointConfiguration.MaxBufferSize != null : !this.MaxBufferSize.equals(endpointConfiguration.MaxBufferSize)) {
            return false;
        }
        if (this.ChannelLifetime == null ? endpointConfiguration.ChannelLifetime != null : !this.ChannelLifetime.equals(endpointConfiguration.ChannelLifetime)) {
            return false;
        }
        return !(this.SecurityTokenLifetime == null ? endpointConfiguration.SecurityTokenLifetime != null : !this.SecurityTokenLifetime.equals(endpointConfiguration.SecurityTokenLifetime));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.OperationTimeout == null ? 0 : this.OperationTimeout.hashCode());
        n = 31 * n + (this.UseBinaryEncoding == null ? 0 : this.UseBinaryEncoding.hashCode());
        n = 31 * n + (this.MaxStringLength == null ? 0 : this.MaxStringLength.hashCode());
        n = 31 * n + (this.MaxByteStringLength == null ? 0 : this.MaxByteStringLength.hashCode());
        n = 31 * n + (this.MaxArrayLength == null ? 0 : this.MaxArrayLength.hashCode());
        n = 31 * n + (this.MaxMessageSize == null ? 0 : this.MaxMessageSize.hashCode());
        n = 31 * n + (this.MaxBufferSize == null ? 0 : this.MaxBufferSize.hashCode());
        n = 31 * n + (this.ChannelLifetime == null ? 0 : this.ChannelLifetime.hashCode());
        n = 31 * n + (this.SecurityTokenLifetime == null ? 0 : this.SecurityTokenLifetime.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return "EndpointConfiguration: " + ObjectUtils.printFieldsDeep(this);
    }
}

