/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.core.ContentFilterElement;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.utils.ObjectUtils;

public class ContentFilter
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.ContentFilter);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.ContentFilter_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.ContentFilter_Encoding_DefaultXml);
    protected ContentFilterElement[] Elements;

    public ContentFilter() {
    }

    public ContentFilter(ContentFilterElement[] contentFilterElementArray) {
        this.Elements = contentFilterElementArray;
    }

    public ContentFilterElement[] getElements() {
        return this.Elements;
    }

    public void setElements(ContentFilterElement[] contentFilterElementArray) {
        this.Elements = contentFilterElementArray;
    }

    public ContentFilter clone() {
        ContentFilter contentFilter = new ContentFilter();
        if (this.Elements != null) {
            contentFilter.Elements = new ContentFilterElement[this.Elements.length];
            for (int i = 0; i < this.Elements.length; ++i) {
                contentFilter.Elements[i] = this.Elements[i].clone();
            }
        }
        return contentFilter;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ContentFilter contentFilter = (ContentFilter)object;
        return !(this.Elements == null ? contentFilter.Elements != null : !Arrays.equals(this.Elements, contentFilter.Elements));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.Elements == null ? 0 : Arrays.hashCode(this.Elements));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return "ContentFilter: " + ObjectUtils.printFieldsDeep(this);
    }
}

