/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ServiceResponse;
import org.opcfoundation.ua.core.CallMethodResult;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.ResponseHeader;
import org.opcfoundation.ua.utils.ObjectUtils;

public class CallResponse
implements ServiceResponse {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.CallResponse);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.CallResponse_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.CallResponse_Encoding_DefaultXml);
    protected ResponseHeader ResponseHeader;
    protected CallMethodResult[] Results;
    protected DiagnosticInfo[] DiagnosticInfos;

    public CallResponse() {
    }

    public CallResponse(ResponseHeader responseHeader, CallMethodResult[] callMethodResultArray, DiagnosticInfo[] diagnosticInfoArray) {
        this.ResponseHeader = responseHeader;
        this.Results = callMethodResultArray;
        this.DiagnosticInfos = diagnosticInfoArray;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.ResponseHeader;
    }

    @Override
    public void setResponseHeader(ResponseHeader responseHeader) {
        this.ResponseHeader = responseHeader;
    }

    public CallMethodResult[] getResults() {
        return this.Results;
    }

    public void setResults(CallMethodResult[] callMethodResultArray) {
        this.Results = callMethodResultArray;
    }

    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.DiagnosticInfos;
    }

    public void setDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
        this.DiagnosticInfos = diagnosticInfoArray;
    }

    public CallResponse clone() {
        CallResponse callResponse = new CallResponse();
        ResponseHeader responseHeader = callResponse.ResponseHeader = this.ResponseHeader == null ? null : this.ResponseHeader.clone();
        if (this.Results != null) {
            callResponse.Results = new CallMethodResult[this.Results.length];
            for (int i = 0; i < this.Results.length; ++i) {
                callResponse.Results[i] = this.Results[i].clone();
            }
        }
        callResponse.DiagnosticInfos = this.DiagnosticInfos == null ? null : (DiagnosticInfo[])this.DiagnosticInfos.clone();
        return callResponse;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CallResponse callResponse = (CallResponse)object;
        if (this.ResponseHeader == null ? callResponse.ResponseHeader != null : !this.ResponseHeader.equals(callResponse.ResponseHeader)) {
            return false;
        }
        if (this.Results == null ? callResponse.Results != null : !Arrays.equals(this.Results, callResponse.Results)) {
            return false;
        }
        return !(this.DiagnosticInfos == null ? callResponse.DiagnosticInfos != null : !Arrays.equals(this.DiagnosticInfos, callResponse.DiagnosticInfos));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.ResponseHeader == null ? 0 : this.ResponseHeader.hashCode());
        n = 31 * n + (this.Results == null ? 0 : Arrays.hashCode(this.Results));
        n = 31 * n + (this.DiagnosticInfos == null ? 0 : Arrays.hashCode(this.DiagnosticInfos));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return ObjectUtils.printFieldsDeep(this);
    }
}

