/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.core.CallMethodRequest;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.RequestHeader;
import org.opcfoundation.ua.utils.ObjectUtils;

public class CallRequest
implements ServiceRequest {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.CallRequest);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.CallRequest_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.CallRequest_Encoding_DefaultXml);
    protected RequestHeader RequestHeader;
    protected CallMethodRequest[] MethodsToCall;

    public CallRequest() {
    }

    public CallRequest(RequestHeader requestHeader, CallMethodRequest[] callMethodRequestArray) {
        this.RequestHeader = requestHeader;
        this.MethodsToCall = callMethodRequestArray;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.RequestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.RequestHeader = requestHeader;
    }

    public CallMethodRequest[] getMethodsToCall() {
        return this.MethodsToCall;
    }

    public void setMethodsToCall(CallMethodRequest[] callMethodRequestArray) {
        this.MethodsToCall = callMethodRequestArray;
    }

    public CallRequest clone() {
        CallRequest callRequest = new CallRequest();
        RequestHeader requestHeader = callRequest.RequestHeader = this.RequestHeader == null ? null : this.RequestHeader.clone();
        if (this.MethodsToCall != null) {
            callRequest.MethodsToCall = new CallMethodRequest[this.MethodsToCall.length];
            for (int i = 0; i < this.MethodsToCall.length; ++i) {
                callRequest.MethodsToCall[i] = this.MethodsToCall[i].clone();
            }
        }
        return callRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CallRequest callRequest = (CallRequest)object;
        if (this.RequestHeader == null ? callRequest.RequestHeader != null : !this.RequestHeader.equals(callRequest.RequestHeader)) {
            return false;
        }
        return !(this.MethodsToCall == null ? callRequest.MethodsToCall != null : !Arrays.equals(this.MethodsToCall, callRequest.MethodsToCall));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.RequestHeader == null ? 0 : this.RequestHeader.hashCode());
        n = 31 * n + (this.MethodsToCall == null ? 0 : Arrays.hashCode(this.MethodsToCall));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return ObjectUtils.printFieldsDeep(this);
    }
}

