/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.ReferenceDescription;
import org.opcfoundation.ua.utils.ObjectUtils;

public class BrowseResult
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.BrowseResult);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.BrowseResult_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.BrowseResult_Encoding_DefaultXml);
    protected StatusCode StatusCode;
    protected byte[] ContinuationPoint;
    protected ReferenceDescription[] References;

    public BrowseResult() {
    }

    public BrowseResult(StatusCode statusCode, byte[] byArray, ReferenceDescription[] referenceDescriptionArray) {
        this.StatusCode = statusCode;
        this.ContinuationPoint = byArray;
        this.References = referenceDescriptionArray;
    }

    public StatusCode getStatusCode() {
        return this.StatusCode;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.StatusCode = statusCode;
    }

    public byte[] getContinuationPoint() {
        return this.ContinuationPoint;
    }

    public void setContinuationPoint(byte[] byArray) {
        this.ContinuationPoint = byArray;
    }

    public ReferenceDescription[] getReferences() {
        return this.References;
    }

    public void setReferences(ReferenceDescription[] referenceDescriptionArray) {
        this.References = referenceDescriptionArray;
    }

    public BrowseResult clone() {
        BrowseResult browseResult = new BrowseResult();
        browseResult.StatusCode = this.StatusCode;
        browseResult.ContinuationPoint = this.ContinuationPoint;
        if (this.References != null) {
            browseResult.References = new ReferenceDescription[this.References.length];
            for (int i = 0; i < this.References.length; ++i) {
                browseResult.References[i] = this.References[i].clone();
            }
        }
        return browseResult;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BrowseResult browseResult = (BrowseResult)object;
        if (this.StatusCode == null ? browseResult.StatusCode != null : !this.StatusCode.equals(browseResult.StatusCode)) {
            return false;
        }
        if (this.ContinuationPoint == null ? browseResult.ContinuationPoint != null : !this.ContinuationPoint.equals(browseResult.ContinuationPoint)) {
            return false;
        }
        return !(this.References == null ? browseResult.References != null : !Arrays.equals(this.References, browseResult.References));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.StatusCode == null ? 0 : this.StatusCode.hashCode());
        n = 31 * n + (this.ContinuationPoint == null ? 0 : this.ContinuationPoint.hashCode());
        n = 31 * n + (this.References == null ? 0 : Arrays.hashCode(this.References));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return "BrowseResult: " + ObjectUtils.printFieldsDeep(this);
    }
}

