/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.BrowseDescription;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.RequestHeader;
import org.opcfoundation.ua.core.ViewDescription;
import org.opcfoundation.ua.utils.ObjectUtils;

public class BrowseRequest
implements ServiceRequest {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.BrowseRequest);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.BrowseRequest_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.BrowseRequest_Encoding_DefaultXml);
    protected RequestHeader RequestHeader;
    protected ViewDescription View;
    protected UnsignedInteger RequestedMaxReferencesPerNode;
    protected BrowseDescription[] NodesToBrowse;

    public BrowseRequest() {
    }

    public BrowseRequest(RequestHeader requestHeader, ViewDescription viewDescription, UnsignedInteger unsignedInteger, BrowseDescription[] browseDescriptionArray) {
        this.RequestHeader = requestHeader;
        this.View = viewDescription;
        this.RequestedMaxReferencesPerNode = unsignedInteger;
        this.NodesToBrowse = browseDescriptionArray;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.RequestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.RequestHeader = requestHeader;
    }

    public ViewDescription getView() {
        return this.View;
    }

    public void setView(ViewDescription viewDescription) {
        this.View = viewDescription;
    }

    public UnsignedInteger getRequestedMaxReferencesPerNode() {
        return this.RequestedMaxReferencesPerNode;
    }

    public void setRequestedMaxReferencesPerNode(UnsignedInteger unsignedInteger) {
        this.RequestedMaxReferencesPerNode = unsignedInteger;
    }

    public BrowseDescription[] getNodesToBrowse() {
        return this.NodesToBrowse;
    }

    public void setNodesToBrowse(BrowseDescription[] browseDescriptionArray) {
        this.NodesToBrowse = browseDescriptionArray;
    }

    public BrowseRequest clone() {
        BrowseRequest browseRequest = new BrowseRequest();
        browseRequest.RequestHeader = this.RequestHeader == null ? null : this.RequestHeader.clone();
        browseRequest.View = this.View == null ? null : this.View.clone();
        browseRequest.RequestedMaxReferencesPerNode = this.RequestedMaxReferencesPerNode;
        if (this.NodesToBrowse != null) {
            browseRequest.NodesToBrowse = new BrowseDescription[this.NodesToBrowse.length];
            for (int i = 0; i < this.NodesToBrowse.length; ++i) {
                browseRequest.NodesToBrowse[i] = this.NodesToBrowse[i].clone();
            }
        }
        return browseRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BrowseRequest browseRequest = (BrowseRequest)object;
        if (this.RequestHeader == null ? browseRequest.RequestHeader != null : !this.RequestHeader.equals(browseRequest.RequestHeader)) {
            return false;
        }
        if (this.View == null ? browseRequest.View != null : !this.View.equals(browseRequest.View)) {
            return false;
        }
        if (this.RequestedMaxReferencesPerNode == null ? browseRequest.RequestedMaxReferencesPerNode != null : !this.RequestedMaxReferencesPerNode.equals(browseRequest.RequestedMaxReferencesPerNode)) {
            return false;
        }
        return !(this.NodesToBrowse == null ? browseRequest.NodesToBrowse != null : !Arrays.equals(this.NodesToBrowse, browseRequest.NodesToBrowse));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.RequestHeader == null ? 0 : this.RequestHeader.hashCode());
        n = 31 * n + (this.View == null ? 0 : this.View.hashCode());
        n = 31 * n + (this.RequestedMaxReferencesPerNode == null ? 0 : this.RequestedMaxReferencesPerNode.hashCode());
        n = 31 * n + (this.NodesToBrowse == null ? 0 : Arrays.hashCode(this.NodesToBrowse));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return ObjectUtils.printFieldsDeep(this);
    }
}

