/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.RelativePath;
import org.opcfoundation.ua.utils.ObjectUtils;

public class BrowsePath
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.BrowsePath);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.BrowsePath_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.BrowsePath_Encoding_DefaultXml);
    protected NodeId StartingNode;
    protected RelativePath RelativePath;

    public BrowsePath() {
    }

    public BrowsePath(NodeId nodeId, RelativePath relativePath) {
        this.StartingNode = nodeId;
        this.RelativePath = relativePath;
    }

    public NodeId getStartingNode() {
        return this.StartingNode;
    }

    public void setStartingNode(NodeId nodeId) {
        this.StartingNode = nodeId;
    }

    public RelativePath getRelativePath() {
        return this.RelativePath;
    }

    public void setRelativePath(RelativePath relativePath) {
        this.RelativePath = relativePath;
    }

    public BrowsePath clone() {
        BrowsePath browsePath = new BrowsePath();
        browsePath.StartingNode = this.StartingNode;
        browsePath.RelativePath = this.RelativePath == null ? null : this.RelativePath.clone();
        return browsePath;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BrowsePath browsePath = (BrowsePath)object;
        if (this.StartingNode == null ? browsePath.StartingNode != null : !this.StartingNode.equals(browsePath.StartingNode)) {
            return false;
        }
        return !(this.RelativePath == null ? browsePath.RelativePath != null : !this.RelativePath.equals(browsePath.RelativePath));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.StartingNode == null ? 0 : this.StartingNode.hashCode());
        n = 31 * n + (this.RelativePath == null ? 0 : this.RelativePath.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return "BrowsePath: " + ObjectUtils.printFieldsDeep(this);
    }
}

