/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.opcfoundation.ua.builtintypes.Enumeration;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Identifiers;

public enum AttributeWriteMask implements Enumeration
{
    None(0),
    AccessLevel(1),
    ArrayDimensions(2),
    BrowseName(4),
    ContainsNoLoops(8),
    DataType(16),
    Description(32),
    DisplayName(64),
    EventNotifier(128),
    Executable(256),
    Historizing(512),
    InverseName(1024),
    IsAbstract(2048),
    MinimumSamplingInterval(4096),
    NodeClass(8192),
    NodeId(16384),
    Symmetric(32768),
    UserAccessLevel(65536),
    UserExecutable(131072),
    UserWriteMask(262144),
    ValueRank(524288),
    WriteMask(0x100000),
    ValueForVariableType(0x200000);

    public static final NodeId ID;
    public static EnumSet<AttributeWriteMask> NONE;
    public static EnumSet<AttributeWriteMask> ALL;
    private final int value;
    private static final Map<Integer, AttributeWriteMask> map;

    private AttributeWriteMask(int n2) {
        this.value = n2;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static AttributeWriteMask valueOf(int n) {
        return map.get(n);
    }

    public static AttributeWriteMask valueOf(Integer n) {
        return n == null ? null : AttributeWriteMask.valueOf((int)n);
    }

    public static AttributeWriteMask valueOf(UnsignedInteger unsignedInteger) {
        return unsignedInteger == null ? null : AttributeWriteMask.valueOf(unsignedInteger.intValue());
    }

    public static AttributeWriteMask[] valueOf(int[] nArray) {
        AttributeWriteMask[] attributeWriteMaskArray = new AttributeWriteMask[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            attributeWriteMaskArray[i] = AttributeWriteMask.valueOf(nArray[i]);
        }
        return attributeWriteMaskArray;
    }

    public static AttributeWriteMask[] valueOf(Integer[] integerArray) {
        AttributeWriteMask[] attributeWriteMaskArray = new AttributeWriteMask[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            attributeWriteMaskArray[i] = AttributeWriteMask.valueOf(integerArray[i]);
        }
        return attributeWriteMaskArray;
    }

    public static AttributeWriteMask[] valueOf(UnsignedInteger[] unsignedIntegerArray) {
        AttributeWriteMask[] attributeWriteMaskArray = new AttributeWriteMask[unsignedIntegerArray.length];
        for (int i = 0; i < unsignedIntegerArray.length; ++i) {
            attributeWriteMaskArray[i] = AttributeWriteMask.valueOf(unsignedIntegerArray[i]);
        }
        return attributeWriteMaskArray;
    }

    public static UnsignedInteger getMask(AttributeWriteMask ... attributeWriteMaskArray) {
        int n = 0;
        for (AttributeWriteMask attributeWriteMask : attributeWriteMaskArray) {
            n |= attributeWriteMask.value;
        }
        return UnsignedInteger.getFromBits(n);
    }

    public static UnsignedInteger getMask(Collection<AttributeWriteMask> collection) {
        int n = 0;
        for (AttributeWriteMask attributeWriteMask : collection) {
            n |= attributeWriteMask.value;
        }
        return UnsignedInteger.getFromBits(n);
    }

    public static EnumSet<AttributeWriteMask> getSet(UnsignedInteger unsignedInteger) {
        return AttributeWriteMask.getSet(unsignedInteger.intValue());
    }

    public static EnumSet<AttributeWriteMask> getSet(int n) {
        ArrayList<AttributeWriteMask> arrayList = new ArrayList<AttributeWriteMask>();
        for (AttributeWriteMask attributeWriteMask : AttributeWriteMask.values()) {
            if ((n & attributeWriteMask.value) != attributeWriteMask.value) continue;
            arrayList.add(attributeWriteMask);
        }
        return EnumSet.copyOf(arrayList);
    }

    static {
        ID = Identifiers.AttributeWriteMask;
        NONE = EnumSet.noneOf(AttributeWriteMask.class);
        ALL = EnumSet.allOf(AttributeWriteMask.class);
        map = new HashMap<Integer, AttributeWriteMask>();
        for (AttributeWriteMask attributeWriteMask : AttributeWriteMask.values()) {
            map.put(attributeWriteMask.value, attributeWriteMask);
        }
    }
}

