/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.core.AggregateConfiguration;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.MonitoringFilter;
import org.opcfoundation.ua.utils.ObjectUtils;

public class AggregateFilter
extends MonitoringFilter
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.AggregateFilter);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.AggregateFilter_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.AggregateFilter_Encoding_DefaultXml);
    protected DateTime StartTime;
    protected NodeId AggregateType;
    protected Double ProcessingInterval;
    protected AggregateConfiguration AggregateConfiguration;

    public AggregateFilter() {
    }

    public AggregateFilter(DateTime dateTime, NodeId nodeId, Double d, AggregateConfiguration aggregateConfiguration) {
        this.StartTime = dateTime;
        this.AggregateType = nodeId;
        this.ProcessingInterval = d;
        this.AggregateConfiguration = aggregateConfiguration;
    }

    public DateTime getStartTime() {
        return this.StartTime;
    }

    public void setStartTime(DateTime dateTime) {
        this.StartTime = dateTime;
    }

    public NodeId getAggregateType() {
        return this.AggregateType;
    }

    public void setAggregateType(NodeId nodeId) {
        this.AggregateType = nodeId;
    }

    public Double getProcessingInterval() {
        return this.ProcessingInterval;
    }

    public void setProcessingInterval(Double d) {
        this.ProcessingInterval = d;
    }

    public AggregateConfiguration getAggregateConfiguration() {
        return this.AggregateConfiguration;
    }

    public void setAggregateConfiguration(AggregateConfiguration aggregateConfiguration) {
        this.AggregateConfiguration = aggregateConfiguration;
    }

    @Override
    public AggregateFilter clone() {
        AggregateFilter aggregateFilter = new AggregateFilter();
        aggregateFilter.StartTime = this.StartTime;
        aggregateFilter.AggregateType = this.AggregateType;
        aggregateFilter.ProcessingInterval = this.ProcessingInterval;
        aggregateFilter.AggregateConfiguration = this.AggregateConfiguration == null ? null : this.AggregateConfiguration.clone();
        return aggregateFilter;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AggregateFilter aggregateFilter = (AggregateFilter)object;
        if (this.StartTime == null ? aggregateFilter.StartTime != null : !this.StartTime.equals(aggregateFilter.StartTime)) {
            return false;
        }
        if (this.AggregateType == null ? aggregateFilter.AggregateType != null : !this.AggregateType.equals(aggregateFilter.AggregateType)) {
            return false;
        }
        if (this.ProcessingInterval == null ? aggregateFilter.ProcessingInterval != null : !this.ProcessingInterval.equals(aggregateFilter.ProcessingInterval)) {
            return false;
        }
        return !(this.AggregateConfiguration == null ? aggregateFilter.AggregateConfiguration != null : !this.AggregateConfiguration.equals(aggregateFilter.AggregateConfiguration));
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.StartTime == null ? 0 : this.StartTime.hashCode());
        n = 31 * n + (this.AggregateType == null ? 0 : this.AggregateType.hashCode());
        n = 31 * n + (this.ProcessingInterval == null ? 0 : this.ProcessingInterval.hashCode());
        n = 31 * n + (this.AggregateConfiguration == null ? 0 : this.AggregateConfiguration.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    public String toString() {
        return "AggregateFilter: " + ObjectUtils.printFieldsDeep(this);
    }
}

