/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.common;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.utils.Description;

public class StatusCodeDescriptions {
    private static Map<UnsignedInteger, String> ERROR_NAMES = null;
    private static Map<UnsignedInteger, String> ERROR_DESCRIPTIONS = null;
    private static Map<String, UnsignedInteger> ERROR_NAMES_REV = null;
    private static final int MASK = -805371904;

    private static synchronized void readDescriptions() {
        if (ERROR_NAMES != null) {
            return;
        }
        ERROR_NAMES = new HashMap<UnsignedInteger, String>();
        ERROR_DESCRIPTIONS = new HashMap<UnsignedInteger, String>();
        ERROR_NAMES_REV = new HashMap<String, UnsignedInteger>();
        try {
            Class<?> clazz = Class.forName("org.opcfoundation.ua.core.StatusCodes");
            for (Field field : clazz.getFields()) {
                if (!field.getType().equals(UnsignedInteger.class)) continue;
                field.setAccessible(true);
                UnsignedInteger unsignedInteger = (UnsignedInteger)field.get(null);
                int n = unsignedInteger.intValue() & 0xCFFF0000;
                String string = field.getName();
                Description description = field.getAnnotation(Description.class);
                String string2 = description == null ? "" : description.value();
                unsignedInteger = UnsignedInteger.getFromBits(n);
                ERROR_DESCRIPTIONS.put(unsignedInteger, string2);
                ERROR_NAMES.put(unsignedInteger, string);
                ERROR_NAMES_REV.put(string, unsignedInteger);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getStatusCode(int n) {
        StatusCodeDescriptions.readDescriptions();
        UnsignedInteger unsignedInteger = UnsignedInteger.getFromBits(n & 0xCFFF0000);
        return ERROR_NAMES.get(unsignedInteger);
    }

    public static String getStatusCodeDescription(int n) {
        StatusCodeDescriptions.readDescriptions();
        UnsignedInteger unsignedInteger = UnsignedInteger.getFromBits(n & 0xCFFF0000);
        return ERROR_DESCRIPTIONS.get(unsignedInteger);
    }

    public static String getStatusCodeDescription(StatusCode statusCode) {
        StatusCodeDescriptions.readDescriptions();
        UnsignedInteger unsignedInteger = UnsignedInteger.getFromBits(statusCode.getValueAsIntBits());
        return ERROR_DESCRIPTIONS.get(unsignedInteger);
    }

    public static UnsignedInteger getStatusCode(String string) {
        StatusCodeDescriptions.readDescriptions();
        return ERROR_NAMES_REV.get(string);
    }
}

