/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.common;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.ServiceResult;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.common.StatusCodeDescriptions;
import org.opcfoundation.ua.core.StatusCodes;

public class ServiceResultException
extends Exception {
    private static final long serialVersionUID = 988605552235028178L;
    protected final StatusCode statusCode;
    protected final String text;

    public ServiceResultException(String string) {
        this(new StatusCode(StatusCodes.Bad_UnexpectedError), string);
    }

    public ServiceResultException(int n) {
        this(StatusCode.getFromBits(n), StatusCodeDescriptions.getStatusCodeDescription(n));
    }

    public ServiceResultException(int n, String string) {
        this(StatusCode.getFromBits(n), string);
    }

    public ServiceResultException(UnsignedInteger unsignedInteger) {
        this(new StatusCode(unsignedInteger), StatusCodeDescriptions.getStatusCodeDescription(unsignedInteger.intValue()));
    }

    public ServiceResultException(UnsignedInteger unsignedInteger, String string) {
        this(new StatusCode(unsignedInteger), string);
    }

    public ServiceResultException(UnsignedInteger unsignedInteger, Throwable throwable, String string) {
        super(string, throwable);
        if (unsignedInteger == null) {
            throw new IllegalArgumentException("statusCode is null");
        }
        this.statusCode = new StatusCode(unsignedInteger);
        this.text = string;
    }

    public ServiceResultException(StatusCode statusCode) {
        this(statusCode, statusCode.getDescription() != null ? statusCode.getDescription() : "");
    }

    public ServiceResultException(StatusCode statusCode, String string) {
        if (statusCode == null) {
            throw new IllegalArgumentException("statusCode is null");
        }
        this.statusCode = statusCode;
        this.text = string;
    }

    public ServiceResultException(StatusCode statusCode, Throwable throwable, String string) {
        super(string, throwable);
        if (statusCode == null) {
            throw new IllegalArgumentException("statusCode is null");
        }
        this.statusCode = statusCode;
        this.text = string;
    }

    public ServiceResultException(UnsignedInteger unsignedInteger, Throwable throwable) {
        super(throwable.getMessage(), throwable);
        if (unsignedInteger == null) {
            throw new IllegalArgumentException("statusCode is null");
        }
        this.statusCode = new StatusCode(unsignedInteger);
        this.text = unsignedInteger.toString() + ", " + throwable.getMessage();
    }

    public ServiceResultException(StatusCode statusCode, Throwable throwable) {
        super(throwable.getMessage(), throwable);
        if (statusCode == null) {
            throw new IllegalArgumentException("statusCode is null");
        }
        this.statusCode = statusCode;
        this.text = statusCode.toString() + ", " + throwable.getMessage();
    }

    public ServiceResultException(Throwable throwable) {
        super(throwable);
        this.statusCode = new StatusCode(StatusCodes.Bad_UnexpectedError);
        this.text = throwable.getMessage();
    }

    @Override
    public String getMessage() {
        if (this.text != null) {
            return String.format("%s (code=0x%08X, description=\"%s\")", this.statusCode.getName(), this.statusCode.getValueAsIntBits(), this.text);
        }
        return this.statusCode.toString();
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public String getAdditionalTextField() {
        return this.text;
    }

    public ServiceResult toServiceResult() {
        ServiceResult serviceResult = new ServiceResult();
        if (this.statusCode == null) {
            serviceResult.setCode(new StatusCode(StatusCodes.Bad_UnexpectedError));
        } else {
            serviceResult.setCode(this.statusCode);
        }
        serviceResult.setSymbolicId(this.statusCode.toString());
        serviceResult.setLocalizedText(new LocalizedText(this.getMessage(), ""));
        serviceResult.setAdditionalInfo(Arrays.toString(this.getStackTrace()));
        return serviceResult;
    }
}

