/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.common;

import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.common.UriTable;

public class NamespaceTable
extends UriTable {
    public static String OPCUA_NAMESPACE = "http://opcfoundation.org/UA/";
    private static NamespaceTable defaultInstance;

    public static NamespaceTable createFromArray(String[] stringArray) {
        NamespaceTable namespaceTable = new NamespaceTable();
        namespaceTable.addAll(stringArray);
        return namespaceTable;
    }

    public NamespaceTable() {
        this.add(0, OPCUA_NAMESPACE);
    }

    public boolean nodeIdEquals(ExpandedNodeId expandedNodeId, ExpandedNodeId expandedNodeId2) {
        if (ExpandedNodeId.isNull(expandedNodeId) && ExpandedNodeId.isNull(expandedNodeId2)) {
            return true;
        }
        if (ExpandedNodeId.isNull(expandedNodeId) || ExpandedNodeId.isNull(expandedNodeId2)) {
            return false;
        }
        if (!expandedNodeId.getValue().equals(expandedNodeId2.getValue())) {
            return false;
        }
        int n = expandedNodeId.getNamespaceUri() == null ? expandedNodeId.getNamespaceIndex() : this.getIndex(expandedNodeId.getNamespaceUri());
        int n2 = expandedNodeId2.getNamespaceUri() == null ? expandedNodeId2.getNamespaceIndex() : this.getIndex(expandedNodeId2.getNamespaceUri());
        return n == n2;
    }

    public boolean nodeIdEquals(NodeId nodeId, ExpandedNodeId expandedNodeId) {
        if (NodeId.isNull(nodeId) && ExpandedNodeId.isNull(expandedNodeId)) {
            return true;
        }
        if (NodeId.isNull(nodeId) || ExpandedNodeId.isNull(expandedNodeId)) {
            return false;
        }
        if (!nodeId.getValue().equals(expandedNodeId.getValue())) {
            return false;
        }
        int n = nodeId.getNamespaceIndex();
        int n2 = expandedNodeId.getNamespaceUri() == null ? expandedNodeId.getNamespaceIndex() : this.getIndex(expandedNodeId.getNamespaceUri());
        return n == n2;
    }

    public ExpandedNodeId toExpandedNodeId(NodeId nodeId) {
        return new ExpandedNodeId(null, this.getUri(nodeId.getNamespaceIndex()), nodeId.getValue());
    }

    public NodeId toNodeId(ExpandedNodeId expandedNodeId) throws ServiceResultException {
        if (ExpandedNodeId.isNull(expandedNodeId)) {
            return NodeId.NULL;
        }
        if (!expandedNodeId.isLocal()) {
            throw new ServiceResultException("Cannot convert ExpandedNodeId with server index to NodeId");
        }
        String string = expandedNodeId.getNamespaceUri();
        if (string == null) {
            return NodeId.get(expandedNodeId.getIdType(), expandedNodeId.getNamespaceIndex(), expandedNodeId.getValue());
        }
        int n = this.getIndex(string);
        if (n < 0) {
            throw new ServiceResultException("Index for uri \"" + string + "\" not found in NamespaceTable");
        }
        return NodeId.get(expandedNodeId.getIdType(), n, expandedNodeId.getValue());
    }

    public boolean namespaceEquals(NodeId nodeId, NodeId nodeId2) {
        return nodeId.getNamespaceIndex() == nodeId2.getNamespaceIndex();
    }

    public boolean namespaceEquals(NodeId nodeId, ExpandedNodeId expandedNodeId) {
        int n = expandedNodeId.getNamespaceUri() != null ? this.getIndex(expandedNodeId.getNamespaceUri()) : expandedNodeId.getNamespaceIndex();
        return nodeId.getNamespaceIndex() == n;
    }

    public boolean namespaceEquals(ExpandedNodeId expandedNodeId, ExpandedNodeId expandedNodeId2) {
        int n = expandedNodeId.getNamespaceUri() != null ? this.getIndex(expandedNodeId.getNamespaceUri()) : expandedNodeId.getNamespaceIndex();
        int n2 = expandedNodeId2.getNamespaceUri() != null ? this.getIndex(expandedNodeId2.getNamespaceUri()) : expandedNodeId2.getNamespaceIndex();
        return n == n2;
    }

    public static NamespaceTable getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = NamespaceTable.createFromArray(new String[]{OPCUA_NAMESPACE});
        }
        return defaultInstance;
    }
}

